/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client.scheduler;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.client.exception.BadRequestException;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.InternalErrorException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.QueryCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.ICallTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchQueryCall<ReqT, RespT>
implements IBatchCall<ReqT, RespT, QueryCallBatcherKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchQueryCall.class);
    private final QueryCallBatcherKey batcherKey;
    private final IQueryPipeline storePipeline;
    private Deque<BatchCallTask<ReqT, RespT>> batchCallTasks = new ArrayDeque<BatchCallTask<ReqT, RespT>>();

    protected BatchQueryCall(IQueryPipeline pipeline, QueryCallBatcherKey batcherKey) {
        this.storePipeline = pipeline;
        this.batcherKey = batcherKey;
    }

    public void add(ICallTask<ReqT, RespT, QueryCallBatcherKey> callTask) {
        BatchCallTask<ReqT, RespT> lastBatchCallTask = this.batchCallTasks.peekLast();
        if (lastBatchCallTask == null) {
            lastBatchCallTask = new BatchCallTask(this.batcherKey.storeId, this.batcherKey.ver);
            lastBatchCallTask.batchedTasks.add(callTask);
            this.batchCallTasks.add(lastBatchCallTask);
        } else {
            lastBatchCallTask.batchedTasks.add(callTask);
        }
    }

    protected abstract ROCoProcInput makeBatch(Iterator<ReqT> var1);

    protected abstract void handleOutput(Queue<ICallTask<ReqT, RespT, QueryCallBatcherKey>> var1, ROCoProcOutput var2);

    protected abstract void handleException(ICallTask<ReqT, RespT, QueryCallBatcherKey> var1, Throwable var2);

    public void reset(boolean abort) {
        if (abort) {
            this.batchCallTasks = new ArrayDeque<BatchCallTask<ReqT, RespT>>();
        }
    }

    public CompletableFuture<Void> execute() {
        return this.execute(this.batchCallTasks);
    }

    private CompletableFuture<Void> execute(Deque<BatchCallTask<ReqT, RespT>> batchCallTasks) {
        BatchCallTask<ReqT, RespT> batchCallTask;
        CompletionStage<Object> chained = CompletableFuture.completedFuture(null);
        while ((batchCallTask = batchCallTasks.poll()) != null) {
            BatchCallTask<ReqT, RespT> current = batchCallTask;
            chained = chained.thenCompose(v -> this.fireSingleBatch(current));
        }
        return chained;
    }

    private CompletableFuture<Void> fireSingleBatch(BatchCallTask<ReqT, RespT> batchCallTask) {
        ROCoProcInput input = this.makeBatch(batchCallTask.batchedTasks.stream().map(ICallTask::call).iterator());
        long reqId = System.nanoTime();
        return ((CompletableFuture)this.storePipeline.query(KVRangeRORequest.newBuilder().setReqId(reqId).setVer(batchCallTask.ver).setKvRangeId(this.batcherKey.id).setRoCoProc(input).build()).thenApply(reply -> {
            switch (reply.getCode()) {
                case Ok: {
                    break;
                }
                case TryLater: {
                    throw new TryLaterException();
                }
                case BadVersion: {
                    throw new BadVersionException();
                }
                case BadRequest: {
                    throw new BadRequestException();
                }
                default: {
                    throw new InternalErrorException();
                }
            }
            return reply.getRoCoProcResult();
        })).handle(CompletableFutureUtil.unwrap((v, e) -> {
            if (e != null) {
                ICallTask callTask;
                while ((callTask = batchCallTask.batchedTasks.poll()) != null) {
                    this.handleException(callTask, (Throwable)e);
                }
            } else {
                this.handleOutput(batchCallTask.batchedTasks, (ROCoProcOutput)v);
            }
            return null;
        }));
    }

    private static class BatchCallTask<ReqT, RespT> {
        final String storeId;
        final long ver;
        final LinkedList<ICallTask<ReqT, RespT, QueryCallBatcherKey>> batchedTasks = new LinkedList();

        private BatchCallTask(String storeId, long ver) {
            this.storeId = storeId;
            this.ver = ver;
        }
    }
}

