---
id: 'contribution'
title: 'Contributor Guide'
---

Welcome every user and developer in the community to become contributors. Whether it's reporting issues, improving documentation, submitting code, or providing technical support, your participation will help make it better.

## Contribution Directions

There are many ways to contribute to this project:

- Fix typos
- Fix bugs
- Remove redundant code
- Add test cases
- Enhance functionality
- Add comments to improve code readability
- Optimize code structure
- Improve or refine documentation

### Principle

- Any pull request that contributes to the improvement of the project should be encouraged.
- Before contributing a new feature, please propose and discuss it in an `issue` or `discussion`. We will not merge features that have not been discussed and confirmed.

## Contribution Process

### Find tasks

Find the issue you are interested in! On our GitHub repo issue list, we often publish some issues with the label `good first issue` or `help wanted`. These issues welcome the help of contributors. Among them, `good first issues` tend to have low thresholds and are suitable for beginners.

Of course, if you have a good idea, you can also propose it directly on GitHub Discussion or contact with community.

### Discuss

Please refer to [Issue Feedback](./feedback.md) to create an issue or discussion and endeavour to reach consensus.

**Note**: To request an issue, please note that it is not just a "please assign it to me", you need to explain your understanding of the issue, and your design, and if possible, you need to provide your POC code.

### Implement

Implement the change according to the approach agreed upon in the issue.

- Only start working on the implementation if there is consensus on the approach (e.g. you are assigned to the ticket)
- If you are newer, can refer to [Code Contribution](./contribution/contribute-code.md) to setup a dev environment.

### Review

Create the pull request and work with the reviewer.

- Make sure no unrelated or unnecessary reformatting changes are included.
- After submitting the PR, the CI process will be triggered. Please make sure that it has passed the CI checks.
- Please ensure that the test passing.
- Please don't resolve conversation.

### Merge

- A committer of project checks if the contribution fulfills the requirements and merges the code to the codebase.

## Contribution Code

All improvements can be implemented through Pull Request (PR). Before submitting a Pull Request.
Please refer to [Code Contribution](./contribution/contribute-code.md) for information on how to contribute code.

## Contribution of Test Cases

Any contribution of test cases is encouraged, especially unit tests. It is recommended to create `XXXTest.java` files in the corresponding module's `test` directory, preferably using the `JUnit5` framework.

## Contribution Document

Documentation is an important component of the project official website and serves as a vital bridge between the project and the community. Please refer to [Docs Contribution](./contribution/contribute-doc.md) for information on how to contribute document.

## Other Ways to Contribute

Apart from directly contributing code, the following ways are also valuable support for Apache Fesod (Incubating):

- Answering other users' questions.
- Assisting in reviewing others' PRs.
- Providing improvement suggestions.
- Writing technical blogs to promote Apache Fesod (Incubating).
- Sharing project-related knowledge in the community.
