/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.model.RestApiResponse;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.rest.ShardAPI;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class ShardAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(ShardAPI.class);
    @Autowired
    PDRestService pdRestService;
    @Autowired
    PDService pdService;

    @GetMapping(value={"/shards"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse getShards() {
        try {
            ArrayList<Shard> resultShardList = new ArrayList<Shard>();
            List graphs = this.pdRestService.getGraphs();
            for (Metapb.Graph graph : graphs) {
                String graphName = graph.getGraphName();
                List partitions = this.pdRestService.getPartitions(graphName);
                for (Metapb.Partition pt : partitions) {
                    Metapb.PartitionStats partitionStats = this.pdRestService.getPartitionStats(graphName, pt.getId());
                    if (partitionStats != null) {
                        List shardStatsList = partitionStats.getShardStatsList();
                        for (Metapb.ShardStats shardStats : shardStatsList) {
                            Shard resultShard = new Shard(this);
                            resultShard.storeId = shardStats.getStoreId();
                            resultShard.partitionId = pt.getId();
                            resultShard.role = String.valueOf(shardStats.getRole());
                            resultShard.state = String.valueOf(shardStats.getState());
                            resultShard.graphName = graphName;
                            resultShard.progress = shardStats.getProgress();
                            resultShardList.add(resultShard);
                        }
                        continue;
                    }
                    List shardList = new ArrayList();
                    Metapb.ShardGroup shardGroup = this.pdService.getStoreNodeService().getShardGroup(pt.getId());
                    if (shardGroup != null) {
                        shardList = shardGroup.getShardsList();
                    } else {
                        log.error("ShardAPI.getShards(), get shards of group id: {} returns null.", (Object)pt.getId());
                    }
                    for (Metapb.Shard shard : shardList) {
                        Shard resultShard = new Shard(this);
                        resultShard.storeId = shard.getStoreId();
                        resultShard.partitionId = pt.getId();
                        resultShard.role = String.valueOf(shard.getRole());
                        resultShard.state = String.valueOf(Metapb.ShardState.SState_Normal);
                        resultShard.graphName = graphName;
                        resultShard.progress = 0;
                        resultShardList.add(resultShard);
                    }
                }
            }
            HashMap<String, ArrayList<Shard>> dataMap = new HashMap<String, ArrayList<Shard>>();
            dataMap.put("shards", resultShardList);
            return new RestApiResponse(dataMap, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
        }
        catch (PDException e) {
            log.error("PDException: ", (Throwable)e);
            return new RestApiResponse(null, e.getErrorCode(), e.getMessage());
        }
    }
}

