/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdbsst;

import java.util.List;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBSessions;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBStore;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBTable;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBTables;
import org.apache.hugegraph.backend.store.rocksdbsst.RocksDBSstSessions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.type.HugeType;
import org.rocksdb.RocksDBException;

public abstract class RocksDBSstStore
extends RocksDBStore {
    public RocksDBSstStore(BackendStoreProvider provider, String database, String store) {
        super(provider, database, store);
    }

    @Override
    protected RocksDBSessions openSessionPool(HugeConfig config, String dataPath, String walPath, List<String> tableNames) throws RocksDBException {
        if (tableNames == null) {
            return new RocksDBSstSessions(config, this.database(), this.store(), dataPath);
        }
        return new RocksDBSstSessions(config, this.database(), this.store(), dataPath, tableNames);
    }

    public static class RocksDBSstGraphStore
    extends RocksDBSstStore {
        public RocksDBSstGraphStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX, (RocksDBTable)new RocksDBTables.Vertex(database));
            this.registerTableManager(HugeType.EDGE_OUT, (RocksDBTable)RocksDBTables.Edge.out(database));
            this.registerTableManager(HugeType.EDGE_IN, (RocksDBTable)RocksDBTables.Edge.in(database));
            this.registerTableManager(HugeType.SECONDARY_INDEX, (RocksDBTable)new RocksDBTables.SecondaryIndex(database));
            this.registerTableManager(HugeType.VERTEX_LABEL_INDEX, (RocksDBTable)new RocksDBTables.VertexLabelIndex(database));
            this.registerTableManager(HugeType.EDGE_LABEL_INDEX, (RocksDBTable)new RocksDBTables.EdgeLabelIndex(database));
            this.registerTableManager(HugeType.RANGE_INT_INDEX, (RocksDBTable)new RocksDBTables.RangeIntIndex(database));
            this.registerTableManager(HugeType.RANGE_FLOAT_INDEX, (RocksDBTable)new RocksDBTables.RangeFloatIndex(database));
            this.registerTableManager(HugeType.RANGE_LONG_INDEX, (RocksDBTable)new RocksDBTables.RangeLongIndex(database));
            this.registerTableManager(HugeType.RANGE_DOUBLE_INDEX, (RocksDBTable)new RocksDBTables.RangeDoubleIndex(database));
            this.registerTableManager(HugeType.SEARCH_INDEX, (RocksDBTable)new RocksDBTables.SearchIndex(database));
            this.registerTableManager(HugeType.SHARD_INDEX, (RocksDBTable)new RocksDBTables.ShardIndex(database));
            this.registerTableManager(HugeType.UNIQUE_INDEX, (RocksDBTable)new RocksDBTables.UniqueIndex(database));
        }

        public boolean isSchemaStore() {
            return false;
        }

        public Id nextId(HugeType type) {
            throw new UnsupportedOperationException("RocksDBSstGraphStore.nextId()");
        }

        public void increaseCounter(HugeType type, long increment) {
            throw new UnsupportedOperationException("RocksDBSstGraphStore.increaseCounter()");
        }

        public long getCounter(HugeType type) {
            throw new UnsupportedOperationException("RocksDBSstGraphStore.getCounter()");
        }
    }
}

