/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.stages;

import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.backend.BackendColumn;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.structure.BaseElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializationStage
implements QueryStage {
    private static final Logger log = LoggerFactory.getLogger(DeserializationStage.class);
    private HugeGraphSupplier graph;
    private String table;

    public void init(Object ... objects) {
        this.table = (String)objects[0];
        this.graph = (HugeGraphSupplier)objects[1];
    }

    public PipelineResult handle(PipelineResult result) {
        if (result.isEmpty()) {
            return result;
        }
        RocksDBSession.BackendColumn column = result.getColumn();
        if (column.value == null) {
            return null;
        }
        try {
            BaseElement element = QueryUtil.parseEntry((HugeGraphSupplier)this.graph, (BackendColumn)BackendColumn.of((byte[])column.name, (byte[])column.value), (boolean)QueryUtil.isVertex((String)this.table));
            return new PipelineResult(element);
        }
        catch (Exception e) {
            log.error("Deserialization error: {}", (Object)this.graph, (Object)e);
            return null;
        }
    }

    public String getName() {
        return "DESERIALIZATION_STAGE";
    }
}

