/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import com.alipay.sofa.jraft.core.NodeMetrics;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.node.util.HgRegexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JRaftMetrics {
    private static final Logger log = LoggerFactory.getLogger(JRaftMetrics.class);
    public static final String PREFIX = "jraft";
    public static final String LABELS = "quantile";
    public static final String LABEL_50 = "0.5";
    public static final String LABEL_75 = "0.75";
    public static final String LABEL_95 = "0.95";
    public static final String LABEL_98 = "0.98";
    public static final String LABEL_99 = "0.99";
    public static final String LABEL_999 = "0.999";
    private static final HgStoreEngine storeEngine = HgStoreEngine.getInstance();
    private static final AtomicInteger groups = new AtomicInteger(0);
    private static final Tag handleDataTag = Tag.of((String)"handle", (String)"data");
    private static final Set<String> groupSet = new HashSet();
    private static final String REGEX_REFINE_REPLICATOR = "(replicator)(.+?:\\d+)(.*)";
    private static MeterRegistry registry;

    private JRaftMetrics() {
    }

    public static synchronized void init(MeterRegistry meterRegistry) {
        if (registry == null) {
            registry = meterRegistry;
            JRaftMetrics.registerMeters();
        }
    }

    private static void registerMeters() {
        io.micrometer.core.instrument.Gauge.builder((String)"jraft.groups", JRaftMetrics::updateGroups).description("Number of raft-groups, which handled the data of graph.").tags(Collections.singleton(handleDataTag)).register(registry);
    }

    private static int updateGroups() {
        int buf = JRaftMetrics.getGroups();
        if (buf != groups.get()) {
            groups.set(buf);
            JRaftMetrics.registerNodeMetrics();
        }
        return buf;
    }

    private static int getGroups() {
        return storeEngine.getRaftGroupCount();
    }

    private static Map<String, NodeMetrics> getRaftGroupMetrics() {
        Map map = storeEngine.getNodeMetrics();
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerNodeMetrics() {
        Map map = JRaftMetrics.getRaftGroupMetrics();
        Set set = groupSet;
        synchronized (set) {
            map.forEach((group, metrics) -> {
                if (!groupSet.add(group)) {
                    return;
                }
                metrics.getMetricRegistry().getGauges().forEach((k, v) -> JRaftMetrics.registerGauge((String)group, (String)k, (Gauge)v));
                metrics.getMetricRegistry().getMeters().forEach((k, v) -> JRaftMetrics.registerMeter((String)group, (String)k, (Meter)v));
                metrics.getMetricRegistry().getCounters().forEach((k, v) -> JRaftMetrics.registerCounter((String)group, (String)k, (Counter)v));
                metrics.getMetricRegistry().getTimers().forEach((k, v) -> JRaftMetrics.registerTimer((String)group, (String)k, (Timer)v));
                metrics.getMetricRegistry().getHistograms().forEach((k, v) -> JRaftMetrics.registerHistogram((String)group, (String)k, (Histogram)v));
            });
        }
    }

    private static String refineMetrics(String name, List<Tag> tags) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        List buf = HgRegexUtil.toGroupValues((String)"(replicator)(.+?:\\d+)(.*)", (String)name);
        Object res = null;
        if (buf != null && buf.size() == 4) {
            res = (String)buf.get(1) + (String)buf.get(3);
            String value = (String)buf.get(2);
            if (value != null && value.startsWith("-")) {
                value = value.substring(1);
            }
            tags.add(Tag.of((String)"replicator", (String)value));
        } else {
            res = name;
        }
        return res;
    }

    private static void registerHistogram(String group, String name, Histogram histogram) {
        if (histogram == null) {
            return;
        }
        LinkedList<Tag> tags = new LinkedList<Tag>();
        tags.add(handleDataTag);
        tags.add(Tag.of((String)"group", (String)group));
        name = JRaftMetrics.refineMetrics((String)name, tags);
        String baseName = "jraft." + name.toLowerCase();
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".median"), (Object)histogram, h -> h.getSnapshot().getMedian()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".min"), (Object)histogram, h -> h.getSnapshot().getMin()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".max"), (Object)histogram, h -> h.getSnapshot().getMax()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".mean"), (Object)histogram, h -> h.getSnapshot().getMean()).tags(tags).register(registry);
        baseName = baseName + ".summary";
        io.micrometer.core.instrument.Gauge.builder((String)baseName, (Object)histogram, h -> h.getSnapshot().getMedian()).tags(tags).tag("quantile", "0.5").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)baseName, (Object)histogram, h -> h.getSnapshot().get75thPercentile()).tags(tags).tag("quantile", "0.75").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)baseName, (Object)histogram, h -> h.getSnapshot().get95thPercentile()).tags(tags).tag("quantile", "0.95").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)baseName, (Object)histogram, h -> h.getSnapshot().get98thPercentile()).tags(tags).tag("quantile", "0.98").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)baseName, (Object)histogram, h -> h.getSnapshot().get99thPercentile()).tags(tags).tag("quantile", "0.99").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)baseName, (Object)histogram, h -> h.getSnapshot().get999thPercentile()).tags(tags).tag("quantile", "0.999").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".sum"), (Object)histogram, h -> Arrays.stream(h.getSnapshot().getValues()).sum()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".count"), (Object)histogram, h -> h.getSnapshot().size()).tags(tags).register(registry);
    }

    private static void registerTimer(String group, String name, Timer timer) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        tags.add(handleDataTag);
        tags.add(Tag.of((String)"group", (String)group));
        name = JRaftMetrics.refineMetrics((String)name, tags);
        String baseName = "jraft." + name.toLowerCase();
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".count"), (Object)timer, t -> t.getCount()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".min"), (Object)timer, t -> t.getSnapshot().getMin()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".max"), (Object)timer, t -> t.getSnapshot().getMax()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".mean"), (Object)timer, t -> t.getSnapshot().getMean()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".stddev"), (Object)timer, t -> t.getSnapshot().getStdDev()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".p50"), (Object)timer, t -> t.getSnapshot().getMedian()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".p75"), (Object)timer, t -> t.getSnapshot().get75thPercentile()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".p95"), (Object)timer, t -> t.getSnapshot().get95thPercentile()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".p98"), (Object)timer, t -> t.getSnapshot().get98thPercentile()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".p99"), (Object)timer, t -> t.getSnapshot().get99thPercentile()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".p999"), (Object)timer, t -> t.getSnapshot().get999thPercentile()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".m1_rate"), (Object)timer, t -> t.getOneMinuteRate()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".m5_rate"), (Object)timer, t -> t.getFiveMinuteRate()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".m15_rate"), (Object)timer, t -> t.getFifteenMinuteRate()).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".mean_rate"), (Object)timer, t -> t.getMeanRate()).tags(tags).register(registry);
    }

    private static void registerMeter(String group, String name, Meter meter) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        tags.add(handleDataTag);
        tags.add(Tag.of((String)"group", (String)group));
        name = JRaftMetrics.refineMetrics((String)name, tags);
        String baseName = "jraft." + name.toLowerCase();
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".count"), (Object)meter, Meter::getCount).tags(tags).register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".rate"), (Object)meter, Meter::getCount).tags(tags).tag("rate", "1m").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".rate"), (Object)meter, Meter::getCount).tags(tags).tag("rate", "5m").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".rate"), (Object)meter, Meter::getCount).tags(tags).tag("rate", "15m").register(registry);
        io.micrometer.core.instrument.Gauge.builder((String)(baseName + ".rate"), (Object)meter, Meter::getCount).tags(tags).tag("rate", "mean").register(registry);
    }

    private static void registerCounter(String group, String name, Counter counter) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        tags.add(handleDataTag);
        tags.add(Tag.of((String)"group", (String)group));
        name = JRaftMetrics.refineMetrics((String)name, tags);
        name = name.toLowerCase();
        io.micrometer.core.instrument.Gauge.builder((String)("jraft." + name + ".count"), (Object)counter, Counter::getCount).tags(tags).register(registry);
    }

    private static void registerGauge(String group, String name, Gauge<?> gauge) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        tags.add(handleDataTag);
        tags.add(Tag.of((String)"group", (String)group));
        name = JRaftMetrics.refineMetrics((String)name, tags);
        name = name.toLowerCase();
        if (gauge.getValue() instanceof Number) {
            io.micrometer.core.instrument.Gauge.builder((String)("jraft." + name), gauge, g -> ((Number)g.getValue()).doubleValue()).tags(tags).register(registry);
        } else {
            io.micrometer.core.instrument.Gauge.builder((String)("jraft." + name), () -> 1.0).tags(tags).tag("str.gauge", String.valueOf(gauge.getValue())).register(registry);
        }
    }
}

