/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.serializer.TableSerializerV2;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.mysql.MysqlBackendEntry;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.JsonUtil;

public class MysqlSerializer
extends TableSerializerV2 {
    public MysqlSerializer(HugeConfig config) {
        super(config);
    }

    public MysqlBackendEntry newBackendEntry(HugeType type, Id id) {
        return new MysqlBackendEntry(type, id);
    }

    protected TableBackendEntry newBackendEntry(TableBackendEntry.Row row) {
        return new MysqlBackendEntry(row);
    }

    protected MysqlBackendEntry convertEntry(BackendEntry backendEntry) {
        if (!(backendEntry instanceof MysqlBackendEntry)) {
            throw new BackendException("Not supported by MysqlSerializer");
        }
        return (MysqlBackendEntry)backendEntry;
    }

    protected Set<Object> parseIndexElemIds(TableBackendEntry entry) {
        Set elemIds = InsertionOrderUtil.newSet();
        elemIds.add(entry.column(HugeKeys.ELEMENT_IDS));
        for (TableBackendEntry.Row row : entry.subRows()) {
            elemIds.add(row.column(HugeKeys.ELEMENT_IDS));
        }
        return elemIds;
    }

    protected Id toId(Number number) {
        return IdGenerator.of((long)number.longValue());
    }

    protected Id[] toIdArray(Object object) {
        assert (object instanceof String);
        String value = (String)object;
        Number[] values = (Number[])JsonUtil.fromJson((String)value, Number[].class);
        Id[] ids = new Id[values.length];
        int i = 0;
        for (Number number : values) {
            ids[i++] = IdGenerator.of((long)number.longValue());
        }
        return ids;
    }

    protected Object toLongSet(Collection<Id> ids) {
        return this.toLongList(ids);
    }

    protected Object toLongList(Collection<Id> ids) {
        long[] values = new long[ids.size()];
        int i = 0;
        for (Id id : ids) {
            values[i++] = id.asLong();
        }
        return JsonUtil.toJson((Object)values);
    }

    protected void formatProperty(HugeProperty<?> prop, TableBackendEntry.Row row) {
        throw new BackendException("Not support updating single property by MySQL");
    }

    protected void formatProperties(HugeElement element, TableBackendEntry.Row row) {
        HashMap<Long, Object> properties = new HashMap<Long, Object>();
        for (HugeProperty prop : element.getProperties()) {
            Long key = prop.propertyKey().id().asLong();
            Object val = prop.value();
            properties.put(key, val);
        }
        row.column(HugeKeys.PROPERTIES, (Object)JsonUtil.toJson(properties));
    }

    protected void parseProperties(HugeElement element, TableBackendEntry.Row row) {
        String properties = (String)row.column(HugeKeys.PROPERTIES);
        if (properties.isEmpty()) {
            return;
        }
        Map props = (Map)JsonUtil.fromJson((String)properties, Map.class);
        for (Map.Entry prop : props.entrySet()) {
            Id pkeyId = this.toId(Long.valueOf((String)prop.getKey()));
            String colJson = JsonUtil.toJson(prop.getValue());
            this.parseProperty(pkeyId, colJson, element);
        }
    }

    protected void writeUserdata(SchemaElement schema, TableBackendEntry entry) {
        assert (entry instanceof MysqlBackendEntry);
        entry.column(HugeKeys.USER_DATA, (Object)JsonUtil.toJson((Object)schema.userdata()));
    }

    protected void readUserdata(SchemaElement schema, TableBackendEntry entry) {
        assert (entry instanceof MysqlBackendEntry);
        String json = (String)entry.column(HugeKeys.USER_DATA);
        Map userdata = (Map)JsonUtil.fromJson((String)json, Map.class);
        for (Map.Entry e : userdata.entrySet()) {
            schema.userdata((String)e.getKey(), e.getValue());
        }
    }

    public BackendEntry writeOlapVertex(HugeVertex vertex) {
        throw new NotImplementedException("Unsupported writeOlapVertex()");
    }
}

