/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rpc;

import com.alipay.remoting.RemotingServer;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.bolt.BoltServer;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.RpcOptions;
import org.apache.hugegraph.rpc.RpcCommonConfig;
import org.apache.hugegraph.rpc.RpcProviderConfig;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class RpcServer {
    private static final Logger LOG = Log.logger(RpcServer.class);
    private final HugeConfig conf;
    private final RpcProviderConfig configs;
    private final ServerConfig serverConfig;

    public RpcServer(HugeConfig config) {
        RpcCommonConfig.initRpcConfigs(config);
        this.conf = config;
        this.configs = new RpcProviderConfig();
        String host = (String)config.get(RpcOptions.RPC_SERVER_HOST);
        if (StringUtils.isNotBlank((CharSequence)host)) {
            int port = (Integer)config.get(RpcOptions.RPC_SERVER_PORT);
            boolean adaptivePort = (Boolean)config.get(RpcOptions.RPC_ADAPTIVE_PORT);
            this.serverConfig = new ServerConfig();
            this.serverConfig.setProtocol((String)config.get(RpcOptions.RPC_PROTOCOL)).setHost(host).setPort(port).setAdaptivePort(adaptivePort).setSerialization((String)config.get(RpcOptions.RPC_SERIALIZATION)).setDaemon(false);
        } else {
            this.serverConfig = null;
        }
    }

    public boolean enabled() {
        return this.serverConfig != null;
    }

    public RpcProviderConfig config() {
        this.checkEnabled();
        return this.configs;
    }

    public String host() {
        this.checkEnabled();
        return this.serverConfig.getBoundHost();
    }

    public int port() {
        this.checkEnabled();
        Server server = this.serverConfig.getServer();
        if (server instanceof BoltServer && server.isStarted()) {
            RemotingServer rs = (RemotingServer)Whitebox.getInternalState((Object)server, (String)"remotingServer");
            return rs.port();
        }
        return this.serverConfig.getPort();
    }

    public void exportAll() {
        this.checkEnabled();
        LOG.debug("RpcServer starting on port {}", (Object)this.port());
        Map<String, ProviderConfig<?>> configs = this.configs.configs();
        if (MapUtils.isEmpty(configs)) {
            LOG.info("RpcServer config is empty, skip starting RpcServer");
            return;
        }
        int timeout = (Integer)this.conf.get(RpcOptions.RPC_SERVER_TIMEOUT) * 1000;
        for (ProviderConfig<?> providerConfig : configs.values()) {
            providerConfig.setServer(this.serverConfig).setTimeout(timeout).export();
        }
        LOG.info("RpcServer started success on port {}", (Object)this.port());
    }

    public void unexportAll() {
        this.configs.removeAllService();
    }

    public void unexport(String serviceId) {
        this.configs.removeService(serviceId);
    }

    public void destroy() {
        if (!this.enabled()) {
            return;
        }
        LOG.info("RpcServer stop on port {}", (Object)this.port());
        for (ProviderConfig<?> config : this.configs.configs().values()) {
            Object service = config.getRef();
            if (!(service instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)service).close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close service {}", service, (Object)e);
            }
        }
        this.serverConfig.destroy();
        this.configs.removeAllService();
    }

    private void checkEnabled() {
        E.checkArgument((boolean)this.enabled(), (String)"RpcServer is not enabled, please config option '%s'", (Object[])new Object[]{RpcOptions.RPC_SERVER_HOST.name()});
    }
}

