/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class RelationshipManager<T extends SchemaDefine.Relationship> {
    private final HugeGraphParams graph;
    private final String label;
    private final Function<Edge, T> deser;
    private final ThreadLocal<Boolean> autoCommit = new ThreadLocal();
    private static final long NO_LIMIT = -1L;

    public RelationshipManager(HugeGraphParams graph, String label, Function<Edge, T> deser) {
        E.checkNotNull((Object)graph, (String)"graph");
        this.graph = graph;
        this.label = label;
        this.deser = deser;
        this.autoCommit.set(true);
    }

    private GraphTransaction tx() {
        return this.graph.systemTransaction();
    }

    private HugeGraph graph() {
        return this.graph.graph();
    }

    private String unhideLabel() {
        return Graph.Hidden.unHide((String)this.label);
    }

    public Id add(T relationship) {
        E.checkArgumentNotNull(relationship, (String)"Relationship can't be null", (Object[])new Object[0]);
        return this.save(relationship, false);
    }

    public Id update(T relationship) {
        E.checkArgumentNotNull(relationship, (String)"Relationship can't be null", (Object[])new Object[0]);
        ((SchemaDefine.AuthElement)relationship).onUpdate();
        return this.save(relationship, true);
    }

    public T delete(Id id) {
        SchemaDefine.Relationship relationship = null;
        Iterator<Edge> edges = this.tx().queryEdges(id);
        if (edges.hasNext()) {
            HugeEdge edge = (HugeEdge)edges.next();
            relationship = (SchemaDefine.Relationship)this.deser.apply(edge);
            this.tx().removeEdge(edge);
            this.commitOrRollback();
            assert (!edges.hasNext());
        }
        return (T)relationship;
    }

    public T get(Id id) {
        SchemaDefine.Relationship relationship = null;
        Iterator<Edge> edges = this.tx().queryEdges(id);
        if (edges.hasNext()) {
            relationship = (SchemaDefine.Relationship)this.deser.apply(edges.next());
            assert (!edges.hasNext());
        }
        if (relationship == null) {
            throw new NotFoundException("Can't find %s with id '%s'", this.unhideLabel(), id);
        }
        return (T)relationship;
    }

    public boolean exists(Id id) {
        Iterator<Edge> edges = this.tx().queryEdges(id);
        if (edges.hasNext()) {
            Edge edge = edges.next();
            return this.label.equals(edge.label());
        }
        return false;
    }

    public List<T> list(List<Id> ids) {
        return this.toList(this.queryById(ids));
    }

    public List<T> list(long limit) {
        Iterator<Edge> edges = this.queryRelationship(null, null, this.label, (Map<String, Object>)ImmutableMap.of(), limit);
        return this.toList(edges);
    }

    public List<T> list(Id source, Directions direction, String label, long limit) {
        Iterator<Edge> edges = this.queryRelationship(source, direction, label, (Map<String, Object>)ImmutableMap.of(), limit);
        return this.toList(edges);
    }

    public List<T> list(Id source, Directions direction, String label, String key, Object value, long limit) {
        ImmutableMap conditions = ImmutableMap.of((Object)key, (Object)value);
        Iterator<Edge> edges = this.queryRelationship(source, direction, label, (Map<String, Object>)conditions, limit);
        return this.toList(edges);
    }

    protected List<T> toList(Iterator<Edge> edges) {
        MapperIterator iter = new MapperIterator(edges, this.deser);
        return (List)QueryResults.toList(iter).list();
    }

    private Iterator<Edge> queryById(List<Id> ids) {
        Object[] idArray = ids.toArray(new Id[0]);
        return this.tx().queryEdges(idArray);
    }

    private Iterator<Edge> queryRelationship(Id source, Directions direction, String label, Map<String, Object> conditions, long limit) {
        ConditionQuery query = new ConditionQuery(HugeType.EDGE);
        EdgeLabel el = this.graph().edgeLabel(label);
        if (direction == null) {
            direction = Directions.OUT;
        }
        if (source != null) {
            query.eq(HugeKeys.OWNER_VERTEX, source);
            query.eq(HugeKeys.DIRECTION, direction);
        }
        if (label != null) {
            query.eq(HugeKeys.LABEL, el.id());
        }
        for (Map.Entry<String, Object> entry : conditions.entrySet()) {
            PropertyKey pk = this.graph().propertyKey(entry.getKey());
            query.query(Condition.eq(pk.id(), entry.getValue()));
        }
        query.showHidden(true);
        if (limit != -1L) {
            query.limit(limit);
        }
        Iterator<Edge> edges = this.tx().queryEdges(query);
        if (limit == -1L) {
            return edges;
        }
        long[] size = new long[1];
        return new MapperIterator(edges, edge -> {
            size[0] = size[0] + 1L;
            if (size[0] > limit) {
                return null;
            }
            return edge;
        });
    }

    private Id save(T relationship, boolean expectExists) {
        if (!this.graph().existsEdgeLabel(((SchemaDefine.AuthElement)relationship).label())) {
            throw new HugeException("Schema is missing for %s '%s'", ((SchemaDefine.AuthElement)relationship).label(), ((SchemaDefine.Relationship)relationship).source());
        }
        HugeVertex source = this.newVertex(((SchemaDefine.Relationship)relationship).source(), ((SchemaDefine.Relationship)relationship).sourceLabel());
        HugeVertex target = this.newVertex(((SchemaDefine.Relationship)relationship).target(), ((SchemaDefine.Relationship)relationship).targetLabel());
        HugeEdge edge = source.constructEdge(((SchemaDefine.AuthElement)relationship).label(), target, ((SchemaDefine.AuthElement)relationship).asArray());
        E.checkArgument((this.exists(edge.id()) == expectExists ? 1 : 0) != 0, (String)"Can't save %s '%s' that %s exists", (Object[])new Object[]{this.unhideLabel(), edge.id(), expectExists ? "not" : "already"});
        this.tx().addEdge(edge);
        this.commitOrRollback();
        return edge.id();
    }

    private HugeVertex newVertex(Object id, String label) {
        VertexLabel vl = this.graph().vertexLabel(label);
        Id idValue = HugeVertex.getIdValue(id);
        return HugeVertex.create(this.tx(), idValue, vl);
    }

    private void commitOrRollback() {
        Boolean autoCommit = this.autoCommit.get();
        if (autoCommit != null && !autoCommit.booleanValue()) {
            return;
        }
        this.tx().commitOrRollback();
    }

    public void autoCommit(boolean value) {
        this.autoCommit.set(value);
    }
}

