/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.allocator;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.allocator.MemoryAllocator;

public class OnHeapMemoryAllocator
implements MemoryAllocator {
    private final MemoryManager memoryManager;

    public OnHeapMemoryAllocator(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public AtomicReference<byte[]> tryToAllocate(long size) {
        if (this.memoryManager.getCurrentOnHeapAllocatedMemoryInBytes().get() + this.memoryManager.getCurrentOffHeapAllocatedMemoryInBytes().get() + size < MemoryManager.MAX_MEMORY_CAPACITY_IN_BYTES) {
            this.memoryManager.getCurrentOnHeapAllocatedMemoryInBytes().addAndGet(size);
            byte[] memoryBlock = new byte[(int)size];
            return new AtomicReference<byte[]>(memoryBlock);
        }
        return null;
    }

    @Override
    public AtomicReference<byte[]> forceAllocate(long size) {
        this.memoryManager.getCurrentOnHeapAllocatedMemoryInBytes().addAndGet(size);
        byte[] memoryBlock = new byte[(int)size];
        return new AtomicReference<byte[]>(memoryBlock);
    }

    @Override
    public void returnMemoryToManager(long size) {
        this.memoryManager.getCurrentOnHeapAllocatedMemoryInBytes().addAndGet(-size);
    }

    @Override
    public void releaseMemoryBlock(Object memoryBlock) {
        ((AtomicReference)memoryBlock).set(null);
    }
}

