/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.service.PendingRangeCalculatorService;
import org.apache.cassandra.service.PendingRangeCalculatorServiceEvent;

final class PendingRangeCalculatorServiceDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private PendingRangeCalculatorServiceDiagnostics() {
    }

    static void taskStarted(PendingRangeCalculatorService calculatorService, AtomicInteger taskCount) {
        if (PendingRangeCalculatorServiceDiagnostics.isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_STARTED)) {
            service.publish(new PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_STARTED, calculatorService, taskCount.get()));
        }
    }

    static void taskFinished(PendingRangeCalculatorService calculatorService, AtomicInteger taskCount) {
        if (PendingRangeCalculatorServiceDiagnostics.isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_FINISHED_SUCCESSFULLY)) {
            service.publish(new PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_FINISHED_SUCCESSFULLY, calculatorService, taskCount.get()));
        }
    }

    static void taskRejected(PendingRangeCalculatorService calculatorService, AtomicInteger taskCount) {
        if (PendingRangeCalculatorServiceDiagnostics.isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_EXECUTION_REJECTED)) {
            service.publish(new PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_EXECUTION_REJECTED, calculatorService, taskCount.get()));
        }
    }

    static void taskCountChanged(PendingRangeCalculatorService calculatorService, int taskCount) {
        if (PendingRangeCalculatorServiceDiagnostics.isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_COUNT_CHANGED)) {
            service.publish(new PendingRangeCalculatorServiceEvent(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType.TASK_COUNT_CHANGED, calculatorService, taskCount));
        }
    }

    private static boolean isEnabled(PendingRangeCalculatorServiceEvent.PendingRangeCalculatorServiceEventType type) {
        return service.isEnabled(PendingRangeCalculatorServiceEvent.class, type);
    }
}

