/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.codahale.metrics.JmxReporter;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.cassandra.batchlog.BatchlogManagerMBean;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.fql.FullQueryLoggerOptions;
import org.apache.cassandra.fql.FullQueryLoggerOptionsCompositeData;
import org.apache.cassandra.gms.FailureDetectorMBean;
import org.apache.cassandra.gms.GossiperMBean;
import org.apache.cassandra.hints.HintsServiceMBean;
import org.apache.cassandra.locator.DynamicEndpointSnitchMBean;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.service.ActiveRepairServiceMBean;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.service.GCInspectorMXBean;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.streaming.StreamManagerMBean;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.streaming.management.StreamStateCompositeData;
import org.apache.cassandra.tools.BootstrapMonitor;
import org.apache.cassandra.tools.ColumnFamilyStoreMBeanIterator;
import org.apache.cassandra.tools.Output;
import org.apache.cassandra.tools.RepairRunner;
import org.apache.cassandra.utils.NativeLibrary;

public class NodeProbe
implements AutoCloseable {
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final String ssObjName = "org.apache.cassandra.db:type=StorageService";
    private static final int defaultPort = 7199;
    static long JMX_NOTIFICATION_POLL_INTERVAL_SECONDS = Long.getLong("cassandra.nodetool.jmx_notification_poll_interval_seconds", TimeUnit.SECONDS.convert(5L, TimeUnit.MINUTES));
    final String host;
    final int port;
    private String username;
    private String password;
    protected JMXConnector jmxc;
    protected MBeanServerConnection mbeanServerConn;
    protected CompactionManagerMBean compactionProxy;
    protected StorageServiceMBean ssProxy;
    protected GossiperMBean gossProxy;
    protected MemoryMXBean memProxy;
    protected GCInspectorMXBean gcProxy;
    protected RuntimeMXBean runtimeProxy;
    protected StreamManagerMBean streamProxy;
    protected MessagingServiceMBean msProxy;
    protected FailureDetectorMBean fdProxy;
    protected CacheServiceMBean cacheService;
    protected StorageProxyMBean spProxy;
    protected HintsServiceMBean hsProxy;
    protected BatchlogManagerMBean bmProxy;
    protected ActiveRepairServiceMBean arsProxy;
    protected Output output;
    private boolean failed;

    public NodeProbe(String host, int port, String username, String password) throws IOException {
        assert (username != null && !username.isEmpty() && password != null && !password.isEmpty()) : "neither username nor password can be blank";
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.output = Output.CONSOLE;
        this.connect();
    }

    public NodeProbe(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.output = Output.CONSOLE;
        this.connect();
    }

    public NodeProbe(String host) throws IOException {
        this.host = host;
        this.port = 7199;
        this.output = Output.CONSOLE;
        this.connect();
    }

    protected NodeProbe() {
        this.host = "";
        this.port = 0;
        this.output = Output.CONSOLE;
    }

    protected void connect() throws IOException {
        String host = this.host;
        if (host.contains(":")) {
            host = "[" + host + "]";
        }
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, host, this.port));
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.username != null) {
            String[] creds = new String[]{this.username, this.password};
            env.put("jmx.remote.credentials", creds);
        }
        env.put("com.sun.jndi.rmi.factory.socket", this.getRMIClientSocketFactory());
        this.jmxc = JMXConnectorFactory.connect(jmxUrl, env);
        this.mbeanServerConn = this.jmxc.getMBeanServerConnection();
        try {
            ObjectName name = new ObjectName(ssObjName);
            this.ssProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=MessagingService");
            this.msProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, MessagingServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=StreamManager");
            this.streamProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StreamManagerMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=CompactionManager");
            this.compactionProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, CompactionManagerMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=FailureDetector");
            this.fdProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, FailureDetectorMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=Caches");
            this.cacheService = JMX.newMBeanProxy(this.mbeanServerConn, name, CacheServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=StorageProxy");
            this.spProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageProxyMBean.class);
            name = new ObjectName("org.apache.cassandra.hints:type=HintsService");
            this.hsProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, HintsServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.service:type=GCInspector");
            this.gcProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, GCInspectorMXBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=Gossiper");
            this.gossProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, GossiperMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=BatchlogManager");
            this.bmProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, BatchlogManagerMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=RepairService");
            this.arsProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, ActiveRepairServiceMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        this.memProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Memory", MemoryMXBean.class);
        this.runtimeProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
    }

    private RMIClientSocketFactory getRMIClientSocketFactory() {
        if (Boolean.parseBoolean(System.getProperty("ssl.enable"))) {
            return new SslRMIClientSocketFactory();
        }
        return RMISocketFactory.getDefaultSocketFactory();
    }

    @Override
    public void close() throws IOException {
        try {
            this.jmxc.close();
        }
        catch (ConnectException e) {
            System.out.println("Cassandra has shutdown.");
        }
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    public Output output() {
        return this.output;
    }

    public int forceKeyspaceCleanup(int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.forceKeyspaceCleanup(jobs, keyspaceName, tables);
    }

    public int scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTL, int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.scrub(disableSnapshot, skipCorrupted, checkData, reinsertOverflowedTTL, jobs, keyspaceName, tables);
    }

    public int verify(boolean extendedVerify, boolean checkVersion, boolean diskFailurePolicy, boolean mutateRepairStatus, boolean checkOwnsTokens, boolean quick, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.verify(extendedVerify, checkVersion, diskFailurePolicy, mutateRepairStatus, checkOwnsTokens, quick, keyspaceName, tableNames);
    }

    public int upgradeSSTables(String keyspaceName, boolean excludeCurrentVersion, int jobs, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.upgradeSSTables(keyspaceName, excludeCurrentVersion, jobs, tableNames);
    }

    public int garbageCollect(String tombstoneOption, int jobs, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.garbageCollect(tombstoneOption, jobs, keyspaceName, tableNames);
    }

    private void checkJobs(PrintStream out, int jobs) {
        int compactors = this.ssProxy.getConcurrentCompactors();
        if (jobs > compactors) {
            out.println(String.format("jobs (%d) is bigger than configured concurrent_compactors (%d) on the host, using at most %d threads", jobs, compactors, compactors));
        }
    }

    public void forceKeyspaceCleanup(PrintStream out, int jobs, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        this.checkJobs(out, jobs);
        switch (this.forceKeyspaceCleanup(jobs, keyspaceName, tableNames)) {
            case 1: {
                this.failed = true;
                out.println("Aborted cleaning up at least one table in keyspace " + keyspaceName + ", check server logs for more information.");
                break;
            }
            case 2: {
                this.failed = true;
                out.println("Failed marking some sstables compacting in keyspace " + keyspaceName + ", check server logs for more information");
            }
        }
    }

    public void scrub(PrintStream out, boolean disableSnapshot, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTL, int jobs, String keyspaceName, String ... tables) throws IOException, ExecutionException, InterruptedException {
        this.checkJobs(out, jobs);
        switch (this.ssProxy.scrub(disableSnapshot, skipCorrupted, checkData, reinsertOverflowedTTL, jobs, keyspaceName, tables)) {
            case 1: {
                this.failed = true;
                out.println("Aborted scrubbing at least one table in keyspace " + keyspaceName + ", check server logs for more information.");
                break;
            }
            case 2: {
                this.failed = true;
                out.println("Failed marking some sstables compacting in keyspace " + keyspaceName + ", check server logs for more information");
            }
        }
    }

    public void verify(PrintStream out, boolean extendedVerify, boolean checkVersion, boolean diskFailurePolicy, boolean mutateRepairStatus, boolean checkOwnsTokens, boolean quick, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        switch (this.verify(extendedVerify, checkVersion, diskFailurePolicy, mutateRepairStatus, checkOwnsTokens, quick, keyspaceName, tableNames)) {
            case 1: {
                this.failed = true;
                out.println("Aborted verifying at least one table in keyspace " + keyspaceName + ", check server logs for more information.");
                break;
            }
            case 2: {
                this.failed = true;
                out.println("Failed marking some sstables compacting in keyspace " + keyspaceName + ", check server logs for more information");
            }
        }
    }

    public void upgradeSSTables(PrintStream out, String keyspaceName, boolean excludeCurrentVersion, int jobs, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        this.checkJobs(out, jobs);
        switch (this.upgradeSSTables(keyspaceName, excludeCurrentVersion, jobs, tableNames)) {
            case 1: {
                this.failed = true;
                out.println("Aborted upgrading sstables for at least one table in keyspace " + keyspaceName + ", check server logs for more information.");
                break;
            }
            case 2: {
                this.failed = true;
                out.println("Failed marking some sstables compacting in keyspace " + keyspaceName + ", check server logs for more information");
            }
        }
    }

    public void garbageCollect(PrintStream out, String tombstoneOption, int jobs, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        if (this.garbageCollect(tombstoneOption, jobs, keyspaceName, tableNames) != 0) {
            this.failed = true;
            out.println("Aborted garbage collection for at least one table in keyspace " + keyspaceName + ", check server logs for more information.");
        }
    }

    public void forceUserDefinedCompaction(String datafiles) throws IOException, ExecutionException, InterruptedException {
        this.compactionProxy.forceUserDefinedCompaction(datafiles);
    }

    public void forceKeyspaceCompaction(boolean splitOutput, String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceKeyspaceCompaction(splitOutput, keyspaceName, tableNames);
    }

    public void relocateSSTables(int jobs, String keyspace, String[] cfnames) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.relocateSSTables(jobs, keyspace, cfnames);
    }

    public void forceKeyspaceCompactionForTokenRange(String keyspaceName, String startToken, String endToken, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceKeyspaceCompactionForTokenRange(keyspaceName, startToken, endToken, tableNames);
    }

    public void forceKeyspaceFlush(String keyspaceName, String ... tableNames) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceKeyspaceFlush(keyspaceName, tableNames);
    }

    public String getKeyspaceReplicationInfo(String keyspaceName) {
        return this.ssProxy.getKeyspaceReplicationInfo(keyspaceName);
    }

    public void repairAsync(PrintStream out, String keyspace, Map<String, String> options) throws IOException {
        RepairRunner runner = new RepairRunner(out, this.ssProxy, keyspace, options);
        try {
            if (this.jmxc != null) {
                this.jmxc.addConnectionNotificationListener(runner, null, null);
            }
            this.ssProxy.addNotificationListener(runner, null, null);
            runner.run();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            try {
                this.ssProxy.removeNotificationListener(runner);
                if (this.jmxc != null) {
                    this.jmxc.removeConnectionNotificationListener(runner);
                }
            }
            catch (Throwable e) {
                out.println("Exception occurred during clean-up. " + e);
            }
        }
    }

    public Map<String, List<CompositeData>> getPartitionSample(int capacity, int durationMillis, int count, List<String> samplers) throws OpenDataException {
        return this.ssProxy.samplePartitions(durationMillis, capacity, count, samplers);
    }

    public Map<String, List<CompositeData>> getPartitionSample(String ks, String cf, int capacity, int durationMillis, int count, List<String> samplers) throws OpenDataException {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(ks, cf);
        for (String sampler : samplers) {
            cfsProxy.beginLocalSampling(sampler, capacity, durationMillis);
        }
        Uninterruptibles.sleepUninterruptibly((long)durationMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap result = Maps.newHashMap();
        for (String sampler : samplers) {
            result.put(sampler, cfsProxy.finishLocalSampling(sampler, count));
        }
        return result;
    }

    public double getDroppableTombstoneRatio(String keyspace, String table) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(keyspace, table);
        return cfsProxy.getDroppableTombstoneRatio();
    }

    public void invalidateCounterCache() {
        this.cacheService.invalidateCounterCache();
    }

    public void invalidateKeyCache() {
        this.cacheService.invalidateKeyCache();
    }

    public void invalidateRowCache() {
        this.cacheService.invalidateRowCache();
    }

    public void drain() throws IOException, InterruptedException, ExecutionException {
        this.ssProxy.drain();
    }

    public Map<String, String> getTokenToEndpointMap(boolean withPort) {
        return withPort ? this.ssProxy.getTokenToEndpointWithPortMap() : this.ssProxy.getTokenToEndpointMap();
    }

    public List<String> getLiveNodes(boolean withPort) {
        return withPort ? this.ssProxy.getLiveNodesWithPort() : this.ssProxy.getLiveNodes();
    }

    public List<String> getJoiningNodes(boolean withPort) {
        return withPort ? this.ssProxy.getJoiningNodesWithPort() : this.ssProxy.getJoiningNodes();
    }

    public List<String> getLeavingNodes(boolean withPort) {
        return withPort ? this.ssProxy.getLeavingNodesWithPort() : this.ssProxy.getLeavingNodes();
    }

    public List<String> getMovingNodes(boolean withPort) {
        return withPort ? this.ssProxy.getMovingNodesWithPort() : this.ssProxy.getMovingNodes();
    }

    public List<String> getUnreachableNodes(boolean withPort) {
        return withPort ? this.ssProxy.getUnreachableNodesWithPort() : this.ssProxy.getUnreachableNodes();
    }

    public Map<String, String> getLoadMap(boolean withPort) {
        return withPort ? this.ssProxy.getLoadMapWithPort() : this.ssProxy.getLoadMap();
    }

    public Map<InetAddress, Float> getOwnership() {
        return this.ssProxy.getOwnership();
    }

    public Map<String, Float> getOwnershipWithPort() {
        return this.ssProxy.getOwnershipWithPort();
    }

    public Map<InetAddress, Float> effectiveOwnership(String keyspace) throws IllegalStateException {
        return this.ssProxy.effectiveOwnership(keyspace);
    }

    public Map<String, Float> effectiveOwnershipWithPort(String keyspace) throws IllegalStateException {
        return this.ssProxy.effectiveOwnershipWithPort(keyspace);
    }

    public MBeanServerConnection getMbeanServerConn() {
        return this.mbeanServerConn;
    }

    public CacheServiceMBean getCacheServiceMBean() {
        String cachePath = "org.apache.cassandra.db:type=Caches";
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(cachePath), CacheServiceMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public double[] getAndResetGCStats() {
        return this.gcProxy.getAndResetStats();
    }

    public Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> getColumnFamilyStoreMBeanProxies() {
        try {
            return new ColumnFamilyStoreMBeanIterator(this.mbeanServerConn);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public CompactionManagerMBean getCompactionManagerProxy() {
        return this.compactionProxy;
    }

    public List<String> getTokens() {
        return this.ssProxy.getTokens();
    }

    public List<String> getTokens(String endpoint) {
        try {
            return this.ssProxy.getTokens(endpoint);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocalHostId() {
        return this.ssProxy.getLocalHostId();
    }

    public Map<String, String> getHostIdMap(boolean withPort) {
        return withPort ? this.ssProxy.getEndpointWithPortToHostId() : this.ssProxy.getEndpointToHostId();
    }

    public String getLoadString() {
        return this.ssProxy.getLoadString();
    }

    public String getReleaseVersion() {
        return this.ssProxy.getReleaseVersion();
    }

    public int getCurrentGenerationNumber() {
        return this.ssProxy.getCurrentGenerationNumber();
    }

    public long getUptime() {
        return this.runtimeProxy.getUptime();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.memProxy.getHeapMemoryUsage();
    }

    public long getSnapshotLinksPerSecond() {
        return this.ssProxy.getSnapshotLinksPerSecond();
    }

    public void setSnapshotLinksPerSecond(long throttle) {
        this.ssProxy.setSnapshotLinksPerSecond(throttle);
    }

    public void takeSnapshot(String snapshotName, String table, Map<String, String> options, String ... keyspaces) throws IOException {
        if (table != null) {
            if (keyspaces.length != 1) {
                throw new IOException("When specifying the table for a snapshot, you must specify one and only one keyspace");
            }
            this.ssProxy.takeSnapshot(snapshotName, options, keyspaces[0] + "." + table);
        } else {
            this.ssProxy.takeSnapshot(snapshotName, options, keyspaces);
        }
    }

    public void takeMultipleTableSnapshot(String snapshotName, Map<String, String> options, String ... tableList) throws IOException {
        if (null == tableList || tableList.length == 0) {
            throw new IOException("The column family List  for a snapshot should not be empty or null");
        }
        this.ssProxy.takeSnapshot(snapshotName, options, tableList);
    }

    public void clearSnapshot(String tag, String ... keyspaces) throws IOException {
        this.ssProxy.clearSnapshot(tag, keyspaces);
    }

    public Map<String, TabularData> getSnapshotDetails() {
        return this.ssProxy.getSnapshotDetails();
    }

    public long trueSnapshotsSize() {
        return this.ssProxy.trueSnapshotsSize();
    }

    public boolean isJoined() {
        return this.ssProxy.isJoined();
    }

    public boolean isDrained() {
        return this.ssProxy.isDrained();
    }

    public boolean isDraining() {
        return this.ssProxy.isDraining();
    }

    public boolean isBootstrapMode() {
        return this.ssProxy.isBootstrapMode();
    }

    public void joinRing() throws IOException {
        this.ssProxy.joinRing();
    }

    public void decommission(boolean force) throws InterruptedException {
        this.ssProxy.decommission(force);
    }

    public void move(String newToken) throws IOException {
        this.ssProxy.move(newToken);
    }

    public void removeNode(String token) {
        this.ssProxy.removeNode(token);
    }

    public String getRemovalStatus(boolean withPort) {
        return withPort ? this.ssProxy.getRemovalStatusWithPort() : this.ssProxy.getRemovalStatus();
    }

    public void forceRemoveCompletion() {
        this.ssProxy.forceRemoveCompletion();
    }

    public void assassinateEndpoint(String address) throws UnknownHostException {
        this.gossProxy.assassinateEndpoint(address);
    }

    public List<String> reloadSeeds() {
        return this.gossProxy.reloadSeeds();
    }

    public List<String> getSeeds() {
        return this.gossProxy.getSeeds();
    }

    public void setCompactionThreshold(String ks, String cf, int minimumCompactionThreshold, int maximumCompactionThreshold) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(ks, cf);
        cfsProxy.setCompactionThresholds(minimumCompactionThreshold, maximumCompactionThreshold);
    }

    public void disableAutoCompaction(String ks, String ... tables) throws IOException {
        this.ssProxy.disableAutoCompaction(ks, tables);
    }

    public void enableAutoCompaction(String ks, String ... tableNames) throws IOException {
        this.ssProxy.enableAutoCompaction(ks, tableNames);
    }

    public Map<String, Boolean> getAutoCompactionDisabled(String ks, String ... tableNames) throws IOException {
        return this.ssProxy.getAutoCompactionStatus(ks, tableNames);
    }

    public void setIncrementalBackupsEnabled(boolean enabled) {
        this.ssProxy.setIncrementalBackupsEnabled(enabled);
    }

    public boolean isIncrementalBackupsEnabled() {
        return this.ssProxy.isIncrementalBackupsEnabled();
    }

    public void setCacheCapacities(int keyCacheCapacity, int rowCacheCapacity, int counterCacheCapacity) {
        CacheServiceMBean cacheMBean = this.getCacheServiceMBean();
        cacheMBean.setKeyCacheCapacityInMB(keyCacheCapacity);
        cacheMBean.setRowCacheCapacityInMB(rowCacheCapacity);
        cacheMBean.setCounterCacheCapacityInMB(counterCacheCapacity);
    }

    public void setCacheKeysToSave(int keyCacheKeysToSave, int rowCacheKeysToSave, int counterCacheKeysToSave) {
        CacheServiceMBean cacheMBean = this.getCacheServiceMBean();
        cacheMBean.setKeyCacheKeysToSave(keyCacheKeysToSave);
        cacheMBean.setRowCacheKeysToSave(rowCacheKeysToSave);
        cacheMBean.setCounterCacheKeysToSave(counterCacheKeysToSave);
    }

    public void setHintedHandoffThrottleInKB(int throttleInKB) {
        this.ssProxy.setHintedHandoffThrottleInKB(throttleInKB);
    }

    public List<String> getEndpointsWithPort(String keyspace, String cf, String key) {
        return this.ssProxy.getNaturalEndpointsWithPort(keyspace, cf, key);
    }

    public List<InetAddress> getEndpoints(String keyspace, String cf, String key) {
        return this.ssProxy.getNaturalEndpoints(keyspace, cf, key);
    }

    public List<String> getSSTables(String keyspace, String cf, String key, boolean hexFormat) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(keyspace, cf);
        return cfsProxy.getSSTablesForKey(key, hexFormat);
    }

    public Set<StreamState> getStreamStatus() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.streamProxy.getCurrentStreams(), (Function)new Function<CompositeData, StreamState>(){

            public StreamState apply(CompositeData input) {
                return StreamStateCompositeData.fromCompositeData(input);
            }
        }));
    }

    public String getOperationMode() {
        return this.ssProxy.getOperationMode();
    }

    public boolean isStarting() {
        return this.ssProxy.isStarting();
    }

    public void truncate(String keyspaceName, String tableName) {
        try {
            this.ssProxy.truncate(keyspaceName, tableName);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
    }

    public EndpointSnitchInfoMBean getEndpointSnitchInfoProxy() {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.db:type=EndpointSnitchInfo"), EndpointSnitchInfoMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public DynamicEndpointSnitchMBean getDynamicEndpointSnitchInfoProxy() {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.db:type=DynamicEndpointSnitch"), DynamicEndpointSnitchMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnFamilyStoreMBean getCfsProxy(String ks, String cf) {
        ColumnFamilyStoreMBean cfsProxy = null;
        try {
            String type = cf.contains(".") ? "IndexColumnFamilies" : "ColumnFamilies";
            Set<ObjectName> beans = this.mbeanServerConn.queryNames(new ObjectName("org.apache.cassandra.db:type=*" + type + ",keyspace=" + ks + ",columnfamily=" + cf), null);
            if (beans.isEmpty()) {
                throw new MalformedObjectNameException("couldn't find that bean");
            }
            assert (beans.size() == 1);
            for (ObjectName bean : beans) {
                cfsProxy = JMX.newMBeanProxy(this.mbeanServerConn, bean, ColumnFamilyStoreMBean.class);
            }
        }
        catch (MalformedObjectNameException mone) {
            System.err.println("ColumnFamilyStore for " + ks + "/" + cf + " not found.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("ColumnFamilyStore for " + ks + "/" + cf + " not found: " + e);
            System.exit(1);
        }
        return cfsProxy;
    }

    public StorageProxyMBean getSpProxy() {
        return this.spProxy;
    }

    public StorageServiceMBean getStorageService() {
        return this.ssProxy;
    }

    public GossiperMBean getGossProxy() {
        return this.gossProxy;
    }

    public String getEndpoint() {
        Map<String, String> hostIdToEndpoint = this.ssProxy.getHostIdToEndpoint();
        return hostIdToEndpoint.get(this.ssProxy.getLocalHostId());
    }

    public String getDataCenter() {
        return this.getEndpointSnitchInfoProxy().getDatacenter();
    }

    public String getRack() {
        return this.getEndpointSnitchInfoProxy().getRack();
    }

    public List<String> getKeyspaces() {
        return this.ssProxy.getKeyspaces();
    }

    public List<String> getNonSystemKeyspaces() {
        return this.ssProxy.getNonSystemKeyspaces();
    }

    public List<String> getNonLocalStrategyKeyspaces() {
        return this.ssProxy.getNonLocalStrategyKeyspaces();
    }

    public String getClusterName() {
        return this.ssProxy.getClusterName();
    }

    public String getPartitioner() {
        return this.ssProxy.getPartitionerName();
    }

    public void disableHintedHandoff() {
        this.spProxy.setHintedHandoffEnabled(false);
    }

    public void enableHintedHandoff() {
        this.spProxy.setHintedHandoffEnabled(true);
    }

    public boolean isHandoffEnabled() {
        return this.spProxy.getHintedHandoffEnabled();
    }

    public void enableHintsForDC(String dc) {
        this.spProxy.enableHintsForDC(dc);
    }

    public void disableHintsForDC(String dc) {
        this.spProxy.disableHintsForDC(dc);
    }

    public Set<String> getHintedHandoffDisabledDCs() {
        return this.spProxy.getHintedHandoffDisabledDCs();
    }

    public Map<String, String> getViewBuildStatuses(String keyspace, String view) {
        return this.ssProxy.getViewBuildStatuses(keyspace, view);
    }

    public void pauseHintsDelivery() {
        this.hsProxy.pauseDispatch();
    }

    public void resumeHintsDelivery() {
        this.hsProxy.resumeDispatch();
    }

    public void truncateHints(String host) {
        this.hsProxy.deleteAllHintsForEndpoint(host);
    }

    public void truncateHints() {
        this.hsProxy.deleteAllHints();
    }

    public void refreshSizeEstimates() {
        try {
            this.ssProxy.refreshSizeEstimates();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while refreshing system.size_estimates", e);
        }
    }

    public void stopNativeTransport() {
        this.ssProxy.stopNativeTransport();
    }

    public void startNativeTransport() {
        this.ssProxy.startNativeTransport();
    }

    public boolean isNativeTransportRunning() {
        return this.ssProxy.isNativeTransportRunning();
    }

    public void stopGossiping() {
        this.ssProxy.stopGossiping();
    }

    public void startGossiping() {
        this.ssProxy.startGossiping();
    }

    public boolean isGossipRunning() {
        return this.ssProxy.isGossipRunning();
    }

    public void stopCassandraDaemon() {
        this.ssProxy.stopDaemon();
    }

    public boolean isInitialized() {
        return this.ssProxy.isInitialized();
    }

    public void setCompactionThroughput(int value) {
        this.ssProxy.setCompactionThroughputMbPerSec(value);
    }

    public int getCompactionThroughput() {
        return this.ssProxy.getCompactionThroughputMbPerSec();
    }

    public void setBatchlogReplayThrottle(int value) {
        this.ssProxy.setBatchlogReplayThrottleInKB(value);
    }

    public int getBatchlogReplayThrottle() {
        return this.ssProxy.getBatchlogReplayThrottleInKB();
    }

    public void setConcurrentCompactors(int value) {
        this.ssProxy.setConcurrentCompactors(value);
    }

    public int getConcurrentCompactors() {
        return this.ssProxy.getConcurrentCompactors();
    }

    public void setConcurrentViewBuilders(int value) {
        this.ssProxy.setConcurrentViewBuilders(value);
    }

    public int getConcurrentViewBuilders() {
        return this.ssProxy.getConcurrentViewBuilders();
    }

    public void setMaxHintWindow(int value) {
        this.spProxy.setMaxHintWindow(value);
    }

    public int getMaxHintWindow() {
        return this.spProxy.getMaxHintWindow();
    }

    public long getTimeout(String type) {
        switch (type) {
            case "misc": {
                return this.ssProxy.getRpcTimeout();
            }
            case "read": {
                return this.ssProxy.getReadRpcTimeout();
            }
            case "range": {
                return this.ssProxy.getRangeRpcTimeout();
            }
            case "write": {
                return this.ssProxy.getWriteRpcTimeout();
            }
            case "counterwrite": {
                return this.ssProxy.getCounterWriteRpcTimeout();
            }
            case "cascontention": {
                return this.ssProxy.getCasContentionTimeout();
            }
            case "truncate": {
                return this.ssProxy.getTruncateRpcTimeout();
            }
            case "internodeconnect": {
                return this.ssProxy.getInternodeTcpConnectTimeoutInMS();
            }
            case "internodeuser": {
                return this.ssProxy.getInternodeTcpUserTimeoutInMS();
            }
            case "internodestreaminguser": {
                return this.ssProxy.getInternodeStreamingTcpUserTimeoutInMS();
            }
        }
        throw new RuntimeException("Timeout type requires one of (read, range, write, counterwrite, cascontention, truncate, internodeconnect, internodeuser, internodestreaminguser, misc (general rpc_timeout_in_ms))");
    }

    public int getStreamThroughput() {
        return this.ssProxy.getStreamThroughputMbPerSec();
    }

    public int getInterDCStreamThroughput() {
        return this.ssProxy.getInterDCStreamThroughputMbPerSec();
    }

    public double getTraceProbability() {
        return this.ssProxy.getTraceProbability();
    }

    public int getExceptionCount() {
        return (int)StorageMetrics.uncaughtExceptions.getCount();
    }

    public Map<String, Integer> getDroppedMessages() {
        return this.msProxy.getDroppedMessages();
    }

    @Deprecated
    public void loadNewSSTables(String ksName, String cfName) {
        this.ssProxy.loadNewSSTables(ksName, cfName);
    }

    public List<String> importNewSSTables(String ksName, String cfName, Set<String> srcPaths, boolean resetLevel, boolean clearRepaired, boolean verifySSTables, boolean verifyTokens, boolean invalidateCaches, boolean extendedVerify, boolean copyData) {
        return this.getCfsProxy(ksName, cfName).importNewSSTables(srcPaths, resetLevel, clearRepaired, verifySSTables, verifyTokens, invalidateCaches, extendedVerify, copyData);
    }

    public void rebuildIndex(String ksName, String cfName, String ... idxNames) {
        this.ssProxy.rebuildSecondaryIndex(ksName, cfName, idxNames);
    }

    public String getGossipInfo(boolean withPort) {
        return withPort ? this.fdProxy.getAllEndpointStatesWithPort() : this.fdProxy.getAllEndpointStates();
    }

    public void stop(String string) {
        this.compactionProxy.stopCompaction(string);
    }

    public void setTimeout(String type, long value) {
        if (value < 0L) {
            throw new RuntimeException("timeout must be non-negative");
        }
        switch (type) {
            case "misc": {
                this.ssProxy.setRpcTimeout(value);
                break;
            }
            case "read": {
                this.ssProxy.setReadRpcTimeout(value);
                break;
            }
            case "range": {
                this.ssProxy.setRangeRpcTimeout(value);
                break;
            }
            case "write": {
                this.ssProxy.setWriteRpcTimeout(value);
                break;
            }
            case "counterwrite": {
                this.ssProxy.setCounterWriteRpcTimeout(value);
                break;
            }
            case "cascontention": {
                this.ssProxy.setCasContentionTimeout(value);
                break;
            }
            case "truncate": {
                this.ssProxy.setTruncateRpcTimeout(value);
                break;
            }
            case "internodeconnect": {
                this.ssProxy.setInternodeTcpConnectTimeoutInMS((int)value);
                break;
            }
            case "internodeuser": {
                this.ssProxy.setInternodeTcpUserTimeoutInMS((int)value);
                break;
            }
            case "internodestreaminguser": {
                this.ssProxy.setInternodeStreamingTcpUserTimeoutInMS((int)value);
                break;
            }
            default: {
                throw new RuntimeException("Timeout type requires one of (read, range, write, counterwrite, cascontention, truncate, internodeconnect, internodeuser, internodestreaminguser, misc (general rpc_timeout_in_ms))");
            }
        }
    }

    public void stopById(String compactionId) {
        this.compactionProxy.stopCompactionById(compactionId);
    }

    public void setStreamThroughput(int value) {
        this.ssProxy.setStreamThroughputMbPerSec(value);
    }

    public void setInterDCStreamThroughput(int value) {
        this.ssProxy.setInterDCStreamThroughputMbPerSec(value);
    }

    public void setTraceProbability(double value) {
        this.ssProxy.setTraceProbability(value);
    }

    public String getSchemaVersion() {
        return this.ssProxy.getSchemaVersion();
    }

    public List<String> describeRing(String keyspaceName, boolean withPort) throws IOException {
        return withPort ? this.ssProxy.describeRingWithPortJMX(keyspaceName) : this.ssProxy.describeRingJMX(keyspaceName);
    }

    public void rebuild(String sourceDc, String keyspace, String tokens, String specificSources) {
        this.ssProxy.rebuild(sourceDc, keyspace, tokens, specificSources);
    }

    public List<String> sampleKeyRange() {
        return this.ssProxy.sampleKeyRange();
    }

    public void resetLocalSchema() throws IOException {
        this.ssProxy.resetLocalSchema();
    }

    public void reloadLocalSchema() {
        this.ssProxy.reloadLocalSchema();
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void failed() {
        this.failed = true;
    }

    public long getReadRepairAttempted() {
        return this.spProxy.getReadRepairAttempted();
    }

    public long getReadRepairRepairedBlocking() {
        return this.spProxy.getReadRepairRepairedBlocking();
    }

    public long getReadRepairRepairedBackground() {
        return this.spProxy.getReadRepairRepairedBackground();
    }

    public Object getCacheMetric(String cacheType, String metricName) {
        try {
            switch (metricName) {
                case "Capacity": 
                case "Entries": 
                case "HitRate": 
                case "Size": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Cache,scope=" + cacheType + ",name=" + metricName), CassandraMetricsRegistry.JmxGaugeMBean.class).getValue();
                }
                case "Requests": 
                case "Hits": 
                case "Misses": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Cache,scope=" + cacheType + ",name=" + metricName), CassandraMetricsRegistry.JmxMeterMBean.class).getCount();
                }
                case "MissLatency": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Cache,scope=" + cacheType + ",name=" + metricName), CassandraMetricsRegistry.JmxTimerMBean.class).getMean();
                }
                case "MissLatencyUnit": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Cache,scope=" + cacheType + ",name=MissLatency"), CassandraMetricsRegistry.JmxTimerMBean.class).getDurationUnit();
                }
            }
            throw new RuntimeException("Unknown Cache metric name " + metricName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getBufferPoolMetric(String poolType, String metricName) {
        try {
            switch (metricName) {
                case "UsedSize": 
                case "OverflowSize": 
                case "Capacity": 
                case "Size": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=BufferPool,scope=" + poolType + ",name=" + metricName), CassandraMetricsRegistry.JmxGaugeMBean.class).getValue();
                }
                case "Hits": 
                case "Misses": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=BufferPool,scope=" + poolType + ",name=" + metricName), CassandraMetricsRegistry.JmxMeterMBean.class).getCount();
                }
            }
            throw new RuntimeException("Unknown BufferPool metric name " + metricName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    private static Multimap<String, String> getJmxThreadPools(MBeanServerConnection mbeanServerConn) {
        try {
            HashMultimap threadPools = HashMultimap.create();
            Set<ObjectName> threadPoolObjectNames = mbeanServerConn.queryNames(new ObjectName("org.apache.cassandra.metrics:type=ThreadPools,*"), null);
            for (ObjectName oName : threadPoolObjectNames) {
                threadPools.put((Object)oName.getKeyProperty("path"), (Object)oName.getKeyProperty("scope"));
            }
            return threadPools;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Bad query to JMX server: ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting threadpool names from JMX", e);
        }
    }

    public Object getThreadPoolMetric(String pathName, String poolName, String metricName) {
        String name = String.format("org.apache.cassandra.metrics:type=ThreadPools,path=%s,scope=%s,name=%s", pathName, poolName, metricName);
        try {
            ObjectName oName = new ObjectName(name);
            if (!this.mbeanServerConn.isRegistered(oName)) {
                return "N/A";
            }
            switch (metricName) {
                case "ActiveTasks": 
                case "PendingTasks": 
                case "CompletedTasks": 
                case "MaxPoolSize": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, JmxReporter.JmxGaugeMBean.class).getValue();
                }
                case "TotalBlockedTasks": 
                case "CurrentlyBlockedTasks": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, JmxReporter.JmxCounterMBean.class).getCount();
                }
            }
            throw new AssertionError((Object)("Unknown ThreadPools metric name " + metricName));
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading: " + name, e);
        }
    }

    public Multimap<String, String> getThreadPools() {
        return NodeProbe.getJmxThreadPools(this.mbeanServerConn);
    }

    public int getNumberOfTables() {
        return this.spProxy.getNumberOfTables();
    }

    public Object getColumnFamilyMetric(String ks, String cf, String metricName) {
        try {
            ObjectName oName = null;
            if (!Strings.isNullOrEmpty((String)ks) && !Strings.isNullOrEmpty((String)cf)) {
                String type = cf.contains(".") ? "IndexTable" : "Table";
                oName = new ObjectName(String.format("org.apache.cassandra.metrics:type=%s,keyspace=%s,scope=%s,name=%s", type, ks, cf, metricName));
            } else {
                oName = !Strings.isNullOrEmpty((String)ks) ? new ObjectName(String.format("org.apache.cassandra.metrics:type=Keyspace,keyspace=%s,name=%s", ks, metricName)) : new ObjectName(String.format("org.apache.cassandra.metrics:type=Table,name=%s", metricName));
            }
            switch (metricName) {
                case "BloomFilterDiskSpaceUsed": 
                case "BloomFilterFalsePositives": 
                case "BloomFilterFalseRatio": 
                case "BloomFilterOffHeapMemoryUsed": 
                case "IndexSummaryOffHeapMemoryUsed": 
                case "CompressionMetadataOffHeapMemoryUsed": 
                case "CompressionRatio": 
                case "EstimatedColumnCountHistogram": 
                case "EstimatedPartitionSizeHistogram": 
                case "EstimatedPartitionCount": 
                case "KeyCacheHitRate": 
                case "LiveSSTableCount": 
                case "OldVersionSSTableCount": 
                case "MaxPartitionSize": 
                case "MeanPartitionSize": 
                case "MemtableColumnsCount": 
                case "MemtableLiveDataSize": 
                case "MemtableOffHeapSize": 
                case "MinPartitionSize": 
                case "PercentRepaired": 
                case "BytesRepaired": 
                case "BytesUnrepaired": 
                case "BytesPendingRepair": 
                case "RecentBloomFilterFalsePositives": 
                case "RecentBloomFilterFalseRatio": 
                case "SnapshotsSize": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, CassandraMetricsRegistry.JmxGaugeMBean.class).getValue();
                }
                case "LiveDiskSpaceUsed": 
                case "MemtableSwitchCount": 
                case "SpeculativeRetries": 
                case "TotalDiskSpaceUsed": 
                case "WriteTotalLatency": 
                case "ReadTotalLatency": 
                case "PendingFlushes": 
                case "DroppedMutations": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, CassandraMetricsRegistry.JmxCounterMBean.class).getCount();
                }
                case "CoordinatorReadLatency": 
                case "CoordinatorScanLatency": 
                case "ReadLatency": 
                case "WriteLatency": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, CassandraMetricsRegistry.JmxTimerMBean.class);
                }
                case "LiveScannedHistogram": 
                case "SSTablesPerReadHistogram": 
                case "TombstoneScannedHistogram": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, CassandraMetricsRegistry.JmxHistogramMBean.class);
                }
            }
            throw new RuntimeException("Unknown table metric " + metricName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public CassandraMetricsRegistry.JmxTimerMBean getProxyMetric(String scope) {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=ClientRequest,scope=" + scope + ",name=Latency"), CassandraMetricsRegistry.JmxTimerMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public CassandraMetricsRegistry.JmxTimerMBean getMessagingQueueWaitMetrics(String verb) {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:name=" + verb + "-WaitLatency,type=Messaging"), CassandraMetricsRegistry.JmxTimerMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getCompactionMetric(String metricName) {
        try {
            switch (metricName) {
                case "BytesCompacted": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Compaction,name=" + metricName), CassandraMetricsRegistry.JmxCounterMBean.class);
                }
                case "CompletedTasks": 
                case "PendingTasks": 
                case "PendingTasksByTableName": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Compaction,name=" + metricName), CassandraMetricsRegistry.JmxGaugeMBean.class).getValue();
                }
                case "TotalCompactionsCompleted": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Compaction,name=" + metricName), CassandraMetricsRegistry.JmxMeterMBean.class);
                }
            }
            throw new RuntimeException("Unknown compaction metric.");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getClientMetric(String metricName) {
        try {
            switch (metricName) {
                case "connections": 
                case "connectedNativeClients": 
                case "connectedNativeClientsByUser": 
                case "clientsByProtocolVersion": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Client,name=" + metricName), CassandraMetricsRegistry.JmxGaugeMBean.class).getValue();
                }
            }
            throw new RuntimeException("Unknown client metric " + metricName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public long getStorageMetric(String metricName) {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Storage,name=" + metricName), CassandraMetricsRegistry.JmxCounterMBean.class).getCount();
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public Double[] metricPercentilesAsArray(CassandraMetricsRegistry.JmxHistogramMBean metric) {
        return new Double[]{metric.get50thPercentile(), metric.get75thPercentile(), metric.get95thPercentile(), metric.get98thPercentile(), metric.get99thPercentile(), metric.getMin(), metric.getMax()};
    }

    public Double[] metricPercentilesAsArray(CassandraMetricsRegistry.JmxTimerMBean metric) {
        return new Double[]{metric.get50thPercentile(), metric.get75thPercentile(), metric.get95thPercentile(), metric.get98thPercentile(), metric.get99thPercentile(), metric.getMin(), metric.getMax()};
    }

    public TabularData getCompactionHistory() {
        return this.compactionProxy.getCompactionHistory();
    }

    public void reloadTriggers() {
        this.spProxy.reloadTriggerClasses();
    }

    public void setLoggingLevel(String classQualifier, String level) {
        try {
            this.ssProxy.setLoggingLevel(classQualifier, level);
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting log for " + classQualifier + " on level " + level + ". Please check logback configuration and ensure to have <jmxConfigurator /> set", e);
        }
    }

    public Map<String, String> getLoggingLevels() {
        return this.ssProxy.getLoggingLevels();
    }

    public long getPid() {
        return NativeLibrary.getProcessID();
    }

    public void resumeBootstrap(PrintStream out) throws IOException {
        BootstrapMonitor monitor = new BootstrapMonitor(out);
        try {
            if (this.jmxc != null) {
                this.jmxc.addConnectionNotificationListener(monitor, null, null);
            }
            this.ssProxy.addNotificationListener(monitor, null, null);
            if (this.ssProxy.resumeBootstrap()) {
                out.println("Resuming bootstrap");
                monitor.awaitCompletion();
            } else {
                out.println("Node is already bootstrapped.");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            try {
                this.ssProxy.removeNotificationListener(monitor);
                if (this.jmxc != null) {
                    this.jmxc.removeConnectionNotificationListener(monitor);
                }
            }
            catch (Throwable e) {
                out.println("Exception occurred during clean-up. " + e);
            }
        }
    }

    public Map<String, List<Integer>> getMaximumPoolSizes(List<String> stageNames) {
        return this.ssProxy.getConcurrency(stageNames);
    }

    public void setConcurrency(String stageName, int coreThreads, int maxConcurrency) {
        this.ssProxy.setConcurrency(stageName, coreThreads, maxConcurrency);
    }

    public void replayBatchlog() throws IOException {
        try {
            this.bmProxy.forceBatchlogReplay();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public TabularData getFailureDetectorPhilValues(boolean withPort) {
        try {
            return withPort ? this.fdProxy.getPhiValuesWithPort() : this.fdProxy.getPhiValues();
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public ActiveRepairServiceMBean getRepairServiceProxy() {
        return this.arsProxy;
    }

    public void reloadSslCerts() throws IOException {
        this.msProxy.reloadSslCertificates();
    }

    public void clearConnectionHistory() {
        this.ssProxy.clearConnectionHistory();
    }

    public void disableAuditLog() {
        this.ssProxy.disableAuditLog();
    }

    public void enableAuditLog(String loggerName, Map<String, String> parameters, String includedKeyspaces, String excludedKeyspaces, String includedCategories, String excludedCategories, String includedUsers, String excludedUsers) {
        this.ssProxy.enableAuditLog(loggerName, parameters, includedKeyspaces, excludedKeyspaces, includedCategories, excludedCategories, includedUsers, excludedUsers);
    }

    public void enableAuditLog(String loggerName, String includedKeyspaces, String excludedKeyspaces, String includedCategories, String excludedCategories, String includedUsers, String excludedUsers) {
        this.enableAuditLog(loggerName, Collections.emptyMap(), includedKeyspaces, excludedKeyspaces, includedCategories, excludedCategories, includedUsers, excludedUsers);
    }

    public void enableOldProtocolVersions() {
        this.ssProxy.enableNativeTransportOldProtocolVersions();
    }

    public void disableOldProtocolVersions() {
        this.ssProxy.disableNativeTransportOldProtocolVersions();
    }

    public MessagingServiceMBean getMessagingServiceProxy() {
        return this.msProxy;
    }

    public void enableFullQueryLogger(String path, String rollCycle, Boolean blocking, int maxQueueWeight, long maxLogSize, @Nullable String archiveCommand, int maxArchiveRetries) {
        this.ssProxy.enableFullQueryLogger(path, rollCycle, blocking, maxQueueWeight, maxLogSize, archiveCommand, maxArchiveRetries);
    }

    public void stopFullQueryLogger() {
        this.ssProxy.stopFullQueryLogger();
    }

    public void resetFullQueryLogger() {
        this.ssProxy.resetFullQueryLogger();
    }

    public FullQueryLoggerOptions getFullQueryLoggerOptions() {
        return FullQueryLoggerOptionsCompositeData.fromCompositeData(this.ssProxy.getFullQueryLoggerOptions());
    }
}

