/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.Iterables;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.commons.lang3.StringUtils;

@Command(name="clearsnapshot", description="Remove the snapshot with the given name from the given keyspaces")
public class ClearSnapshot
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspaces>...] ", description="Remove snapshots from the given keyspaces")
    private List<String> keyspaces = new ArrayList<String>();
    @Option(title="snapshot_name", name={"-t"}, description="Remove the snapshot with a given name")
    private String snapshotName = "";
    @Option(title="clear_all_snapshots", name={"--all"}, description="Removes all snapshots")
    private boolean clearAllSnapshots = false;

    @Override
    public void execute(NodeProbe probe) {
        if (this.snapshotName.isEmpty() && !this.clearAllSnapshots) {
            throw new RuntimeException("Specify snapshot name or --all");
        }
        if (!this.snapshotName.isEmpty() && this.clearAllSnapshots) {
            throw new RuntimeException("Specify only one of snapshot name or --all");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Requested clearing snapshot(s) for ");
        if (this.keyspaces.isEmpty()) {
            sb.append("[all keyspaces]");
        } else {
            sb.append("[").append(StringUtils.join(this.keyspaces, (String)", ")).append("]");
        }
        if (this.snapshotName.isEmpty()) {
            sb.append(" with [all snapshots]");
        } else {
            sb.append(" with snapshot name [").append(this.snapshotName).append("]");
        }
        probe.output().out.println(sb.toString());
        try {
            probe.clearSnapshot(this.snapshotName, (String[])Iterables.toArray(this.keyspaces, String.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Error during clearing snapshots", e);
        }
    }
}

