/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.polaris.core.persistence.dao.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;

/** Response object for the loadResolvedEntities call. */
public class ResolvedEntitiesResult extends BaseResult {
  private final List<ResolvedPolarisEntity> resolvedEntities;

  public ResolvedEntitiesResult(List<ResolvedPolarisEntity> resolvedEntities) {
    super(ReturnStatus.SUCCESS, null);
    this.resolvedEntities = resolvedEntities;
  }

  public ResolvedEntitiesResult(
      @Nonnull ReturnStatus returnStatus, @Nullable String extraInformation) {
    super(returnStatus, extraInformation);
    this.resolvedEntities = null;
  }

  @JsonCreator
  private ResolvedEntitiesResult(
      @JsonProperty("returnStatus") ReturnStatus returnStatus,
      @JsonProperty("extraInformation") String extraInformation,
      @JsonProperty("resolvedEntities") List<ResolvedPolarisEntity> resolvedEntities) {
    super(returnStatus, extraInformation);
    this.resolvedEntities = resolvedEntities;
  }

  public List<ResolvedPolarisEntity> getResolvedEntities() {
    return resolvedEntities;
  }
}
