/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.basicconfig.RetryConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class RetryConfigImpl
implements RetryConfig {
    private final String description;
    private final String configKey;
    private final Retry instance;
    private Integer _maxRetries;
    private Long _delay;
    private ChronoUnit _delayUnit;
    private Long _maxDuration;
    private ChronoUnit _durationUnit;
    private Long _jitter;
    private ChronoUnit _jitterDelayUnit;
    private Class<? extends Throwable>[] _retryOn;
    private Class<? extends Throwable>[] _abortOn;

    private RetryConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(Retry.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.retry;
    }

    private RetryConfigImpl(String id, Retry instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static RetryConfigImpl create(FaultToleranceMethod method) {
        if (method.retry == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("retry.enabled", "Retry/enabled", method.method)) {
            return null;
        }
        return new RetryConfigImpl(method);
    }

    public static RetryConfigImpl create(String id, Supplier<Retry> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("retry.enabled", "Retry/enabled", id)) {
            return null;
        }
        return new RetryConfigImpl(id, supplier.get());
    }

    public Class<? extends Annotation> annotationType() {
        return Retry.class;
    }

    public int maxRetries() {
        if (this._maxRetries == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.max-retries";
            Object oldKey = this.configKey + "/Retry/maxRetries";
            this._maxRetries = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> RetryConfigImpl.lambda$maxRetries$0(config, (String)oldKey)).orElse(null);
            if (this._maxRetries == null) {
                newKey = "smallrye.faulttolerance.global.retry.max-retries";
                oldKey = "Retry/maxRetries";
                this._maxRetries = config.getOptionalValue((String)newKey, Integer.TYPE).or(() -> RetryConfigImpl.lambda$maxRetries$1(config, (String)oldKey)).orElse(null);
            }
            if (this._maxRetries == null) {
                this._maxRetries = this.instance.maxRetries();
            }
        }
        return this._maxRetries;
    }

    public long delay() {
        if (this._delay == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.delay";
            Object oldKey = this.configKey + "/Retry/delay";
            this._delay = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RetryConfigImpl.lambda$delay$2(config, (String)oldKey)).orElse(null);
            if (this._delay == null) {
                newKey = "smallrye.faulttolerance.global.retry.delay";
                oldKey = "Retry/delay";
                this._delay = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RetryConfigImpl.lambda$delay$3(config, (String)oldKey)).orElse(null);
            }
            if (this._delay == null) {
                this._delay = this.instance.delay();
            }
        }
        return this._delay;
    }

    public ChronoUnit delayUnit() {
        if (this._delayUnit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.delay-unit";
            Object oldKey = this.configKey + "/Retry/delayUnit";
            this._delayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RetryConfigImpl.lambda$delayUnit$4(config, (String)oldKey)).orElse(null);
            if (this._delayUnit == null) {
                newKey = "smallrye.faulttolerance.global.retry.delay-unit";
                oldKey = "Retry/delayUnit";
                this._delayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RetryConfigImpl.lambda$delayUnit$5(config, (String)oldKey)).orElse(null);
            }
            if (this._delayUnit == null) {
                this._delayUnit = this.instance.delayUnit();
            }
        }
        return this._delayUnit;
    }

    public long maxDuration() {
        if (this._maxDuration == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.max-duration";
            Object oldKey = this.configKey + "/Retry/maxDuration";
            this._maxDuration = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RetryConfigImpl.lambda$maxDuration$6(config, (String)oldKey)).orElse(null);
            if (this._maxDuration == null) {
                newKey = "smallrye.faulttolerance.global.retry.max-duration";
                oldKey = "Retry/maxDuration";
                this._maxDuration = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RetryConfigImpl.lambda$maxDuration$7(config, (String)oldKey)).orElse(null);
            }
            if (this._maxDuration == null) {
                this._maxDuration = this.instance.maxDuration();
            }
        }
        return this._maxDuration;
    }

    public ChronoUnit durationUnit() {
        if (this._durationUnit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.max-duration-unit";
            Object oldKey = this.configKey + "/Retry/durationUnit";
            this._durationUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RetryConfigImpl.lambda$durationUnit$8(config, (String)oldKey)).orElse(null);
            if (this._durationUnit == null) {
                newKey = "smallrye.faulttolerance.global.retry.max-duration-unit";
                oldKey = "Retry/durationUnit";
                this._durationUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RetryConfigImpl.lambda$durationUnit$9(config, (String)oldKey)).orElse(null);
            }
            if (this._durationUnit == null) {
                this._durationUnit = this.instance.durationUnit();
            }
        }
        return this._durationUnit;
    }

    public long jitter() {
        if (this._jitter == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.jitter";
            Object oldKey = this.configKey + "/Retry/jitter";
            this._jitter = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RetryConfigImpl.lambda$jitter$10(config, (String)oldKey)).orElse(null);
            if (this._jitter == null) {
                newKey = "smallrye.faulttolerance.global.retry.jitter";
                oldKey = "Retry/jitter";
                this._jitter = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> RetryConfigImpl.lambda$jitter$11(config, (String)oldKey)).orElse(null);
            }
            if (this._jitter == null) {
                this._jitter = this.instance.jitter();
            }
        }
        return this._jitter;
    }

    public ChronoUnit jitterDelayUnit() {
        if (this._jitterDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.jitter-unit";
            Object oldKey = this.configKey + "/Retry/jitterDelayUnit";
            this._jitterDelayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RetryConfigImpl.lambda$jitterDelayUnit$12(config, (String)oldKey)).orElse(null);
            if (this._jitterDelayUnit == null) {
                newKey = "smallrye.faulttolerance.global.retry.jitter-unit";
                oldKey = "Retry/jitterDelayUnit";
                this._jitterDelayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> RetryConfigImpl.lambda$jitterDelayUnit$13(config, (String)oldKey)).orElse(null);
            }
            if (this._jitterDelayUnit == null) {
                this._jitterDelayUnit = this.instance.jitterDelayUnit();
            }
        }
        return this._jitterDelayUnit;
    }

    public Class<? extends Throwable>[] retryOn() {
        if (this._retryOn == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.retry-on";
            Object oldKey = this.configKey + "/Retry/retryOn";
            this._retryOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> RetryConfigImpl.lambda$retryOn$14(config, (String)oldKey)).orElse(null);
            if (this._retryOn == null) {
                newKey = "smallrye.faulttolerance.global.retry.retry-on";
                oldKey = "Retry/retryOn";
                this._retryOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> RetryConfigImpl.lambda$retryOn$15(config, (String)oldKey)).orElse(null);
            }
            if (this._retryOn == null) {
                this._retryOn = this.instance.retryOn();
            }
        }
        return this._retryOn;
    }

    public Class<? extends Throwable>[] abortOn() {
        if (this._abortOn == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.abort-on";
            Object oldKey = this.configKey + "/Retry/abortOn";
            this._abortOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> RetryConfigImpl.lambda$abortOn$16(config, (String)oldKey)).orElse(null);
            if (this._abortOn == null) {
                newKey = "smallrye.faulttolerance.global.retry.abort-on";
                oldKey = "Retry/abortOn";
                this._abortOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> RetryConfigImpl.lambda$abortOn$17(config, (String)oldKey)).orElse(null);
            }
            if (this._abortOn == null) {
                this._abortOn = this.instance.abortOn();
            }
        }
        return this._abortOn;
    }

    public void materialize() {
        this.maxRetries();
        this.delay();
        this.delayUnit();
        this.maxDuration();
        this.durationUnit();
        this.jitter();
        this.jitterDelayUnit();
        this.retryOn();
        this.abortOn();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Retry on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Retry." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$abortOn$17(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$abortOn$16(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$retryOn$15(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$retryOn$14(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$jitterDelayUnit$13(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$jitterDelayUnit$12(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$jitter$11(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$jitter$10(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$durationUnit$9(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$durationUnit$8(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$maxDuration$7(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$maxDuration$6(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$delayUnit$5(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$delayUnit$4(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$delay$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$delay$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$maxRetries$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }

    private static /* synthetic */ Optional lambda$maxRetries$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Integer.TYPE);
    }
}

