/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.annotation.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.Optional;

final class ParameterizedClass {
    private final Class<?> rawClass;
    private final Type[] typeArguments;

    public static ParameterizedClass of(Type type) {
        Objects.requireNonNull(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawClass = (Class)parameterizedType.getRawType();
            return new ParameterizedClass(rawClass, parameterizedType.getActualTypeArguments());
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            return new ParameterizedClass(cls, cls.getTypeParameters());
        }
        throw new IllegalArgumentException();
    }

    private ParameterizedClass(Class<?> rawClass, Type[] typeArguments) {
        this.rawClass = rawClass;
        this.typeArguments = typeArguments;
    }

    public Class<?> getRawClass() {
        return this.rawClass;
    }

    public Type[] getActualTypeArguments() {
        return (Type[])this.typeArguments.clone();
    }

    public ParameterizedClass getParameterizedSuperclass() {
        return this.resolveSuperTypeActualTypeArguments(this.rawClass.getGenericSuperclass());
    }

    public ParameterizedClass[] getParameterizedInterfaces() {
        Type[] interfaceTypes = this.rawClass.getGenericInterfaces();
        ParameterizedClass[] parameterizedClasses = new ParameterizedClass[interfaceTypes.length];
        for (int i = 0; i < interfaceTypes.length; ++i) {
            parameterizedClasses[i] = this.resolveSuperTypeActualTypeArguments(interfaceTypes[i]);
        }
        return parameterizedClasses;
    }

    public Optional<ParameterizedClass> findParameterizedSuperclass(Class<?> superClass) {
        Objects.requireNonNull(superClass);
        return ParameterizedClass.findParameterizedSuperclassImpl(this, superClass);
    }

    private static Optional<ParameterizedClass> findParameterizedSuperclassImpl(ParameterizedClass current, Class<?> superClass) {
        if (current == null) {
            return Optional.empty();
        }
        if (current.rawClass.equals(superClass)) {
            return Optional.of(current);
        }
        if (superClass.isInterface()) {
            for (ParameterizedClass interfaceType : current.getParameterizedInterfaces()) {
                if (!interfaceType.rawClass.equals(superClass)) continue;
                return Optional.of(interfaceType);
            }
        }
        return ParameterizedClass.findParameterizedSuperclassImpl(current.getParameterizedSuperclass(), superClass);
    }

    private ParameterizedClass resolveSuperTypeActualTypeArguments(Type superType) {
        if (superType instanceof ParameterizedType) {
            ParameterizedType parameterizedSuperType = (ParameterizedType)superType;
            TypeVariable<Class<?>>[] typeParameters = this.rawClass.getTypeParameters();
            return ParameterizedClass.resolveSuperTypeActualTypeArguments(parameterizedSuperType, typeParameters, this.typeArguments);
        }
        if (superType != null) {
            return ParameterizedClass.of(superType);
        }
        return null;
    }

    private static ParameterizedClass resolveSuperTypeActualTypeArguments(ParameterizedType parameterizedSuperType, TypeVariable<?>[] typeParameters, Type[] actualTypeArguments) {
        Type[] superTypeArguments = parameterizedSuperType.getActualTypeArguments();
        for (int i = 0; i < superTypeArguments.length; ++i) {
            Type superTypeArgument = superTypeArguments[i];
            if (!(superTypeArgument instanceof TypeVariable)) continue;
            TypeVariable superTypeVariable = (TypeVariable)superTypeArgument;
            superTypeArguments[i] = ParameterizedClass.mapTypeVariableToActualTypeArgument(superTypeVariable, typeParameters, actualTypeArguments);
        }
        Class rawSuperClass = (Class)parameterizedSuperType.getRawType();
        return new ParameterizedClass(rawSuperClass, superTypeArguments);
    }

    private static Type mapTypeVariableToActualTypeArgument(TypeVariable<?> superTypeVariable, TypeVariable<?>[] typeParameters, Type[] actualTypeArguments) {
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!ParameterizedClass.equalsTypeVariable(superTypeVariable, typeParameters[i])) continue;
            return actualTypeArguments[i];
        }
        return superTypeVariable;
    }

    private static boolean equalsTypeVariable(TypeVariable<?> left, TypeVariable<?> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.getGenericDeclaration().equals(right.getGenericDeclaration()) && left.getName().equals(right.getName());
    }
}

