/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.rds.runtime;

import io.quarkiverse.amazon.common.AmazonClient;
import io.quarkiverse.amazon.common.runtime.ClientUtil;
import io.quarkiverse.amazon.rds.runtime.RdsCredentialsProviderBuildTimeConfig;
import io.quarkiverse.amazon.rds.runtime.RdsCredentialsProviderConfig;
import io.quarkus.credentials.CredentialsProvider;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.Map;
import software.amazon.awssdk.services.rds.RdsClient;

@ApplicationScoped
@Named(value="rds-credentials-provider")
public class RdsCredentialsProvider
implements CredentialsProvider {
    @Inject
    RdsCredentialsProviderConfig rdsConfig;
    @Inject
    RdsCredentialsProviderBuildTimeConfig rdsBuildTimeConfig;
    @Inject
    Instance<RdsClient> rdsClients;

    public Map<String, String> getCredentials(String credentialsProviderName) {
        RdsCredentialsProviderConfig.CredentialsProviderConfig credentialProviderConfig = this.rdsConfig.credentialsProvider().get(credentialsProviderName);
        if (credentialProviderConfig == null) {
            throw new IllegalArgumentException("unknown credentials provider with name " + credentialsProviderName);
        }
        RdsClient rdsClient = this.getRdsClient(this.rdsBuildTimeConfig.credentialsProvider().get(credentialsProviderName));
        String token = this.generateRdsAuthToken(credentialProviderConfig, rdsClient);
        return Map.ofEntries(Map.entry("user", credentialProviderConfig.username()), Map.entry("password", token));
    }

    private String generateRdsAuthToken(RdsCredentialsProviderConfig.CredentialsProviderConfig config, RdsClient rdsClient) {
        return rdsClient.utilities().generateAuthenticationToken(builder -> builder.username(config.username()).port(config.port()).hostname(config.hostname()));
    }

    private RdsClient getRdsClient(RdsCredentialsProviderBuildTimeConfig.CredentialsProviderBuildTimeConfig credentialsProviderBuildTimeConfig) {
        if (credentialsProviderBuildTimeConfig != null && credentialsProviderBuildTimeConfig.useQuarkusClient()) {
            return this.getRdsClient(credentialsProviderBuildTimeConfig.name().orElse("<default>"));
        }
        return RdsClient.create();
    }

    private RdsClient getRdsClient(String clientName) {
        return ClientUtil.isDefaultClient((String)clientName) ? (RdsClient)this.rdsClients.select(new Annotation[]{Default.Literal.INSTANCE}).get() : (RdsClient)this.rdsClients.select(new Annotation[]{new AmazonClient.AmazonClientLiteral(clientName)}).get();
    }
}

