/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.metrics.registry.compact;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.metrics.Counter;
import org.apache.seata.metrics.Gauge;
import org.apache.seata.metrics.Id;
import org.apache.seata.metrics.Measurement;
import org.apache.seata.metrics.Meter;
import org.apache.seata.metrics.Summary;
import org.apache.seata.metrics.Timer;
import org.apache.seata.metrics.registry.Registry;
import org.apache.seata.metrics.registry.compact.CompactCounter;
import org.apache.seata.metrics.registry.compact.CompactGauge;
import org.apache.seata.metrics.registry.compact.CompactSummary;
import org.apache.seata.metrics.registry.compact.CompactTimer;

@LoadLevel(name="compact", order=1)
public class CompactRegistry
implements Registry {
    private static final Map<String, Meter> METERS = new ConcurrentHashMap<String, Meter>();

    public <T extends Number> Gauge<T> getGauge(Id id, Supplier<T> supplier) {
        return (Gauge)CollectionUtils.computeIfAbsent(METERS, (Object)id.getMeterKey(), key -> new CompactGauge(new Id(id.getName()).withTag(id.getTags()), supplier));
    }

    public Counter getCounter(Id id) {
        return (Counter)CollectionUtils.computeIfAbsent(METERS, (Object)id.getMeterKey(), key -> new CompactCounter(new Id(id.getName()).withTag(id.getTags())));
    }

    public Summary getSummary(Id id) {
        return (Summary)CollectionUtils.computeIfAbsent(METERS, (Object)id.getMeterKey(), key -> new CompactSummary(new Id(id.getName()).withTag(id.getTags())));
    }

    public Timer getTimer(Id id) {
        return (Timer)CollectionUtils.computeIfAbsent(METERS, (Object)id.getMeterKey(), key -> new CompactTimer(new Id(id.getName()).withTag(id.getTags())));
    }

    public Iterable<Measurement> measure() {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        if (METERS.isEmpty()) {
            return measurements;
        }
        METERS.values().iterator().forEachRemaining(meter -> meter.measure().forEach(measurements::add));
        return measurements;
    }

    public void clearUp() {
        METERS.clear();
    }
}

