/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.metrics.exporter.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.metrics.Measurement;
import org.apache.seata.metrics.exporter.Exporter;
import org.apache.seata.metrics.registry.Registry;

@LoadLevel(name="prometheus", order=1)
public class PrometheusExporter
extends Collector
implements Collector.Describable,
Exporter {
    private final HTTPServer server;
    private Registry registry;

    public PrometheusExporter() throws IOException {
        int port = ConfigurationFactory.getInstance().getInt("metrics.exporterPrometheusPort", 9898);
        CollectorRegistry collectorRegistry = new CollectorRegistry(true);
        this.register(collectorRegistry);
        this.server = new HTTPServer(new InetSocketAddress(port), collectorRegistry, true);
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> familySamples = new ArrayList<Collector.MetricFamilySamples>();
        if (this.registry != null) {
            Iterable measurements = this.registry.measure();
            ArrayList samples = new ArrayList();
            measurements.forEach(measurement -> samples.add(this.convertMeasurementToSample((Measurement)measurement)));
            if (!samples.isEmpty()) {
                Collector.Type unknownType = PrometheusExporter.getUnknownType();
                familySamples.add(new Collector.MetricFamilySamples("seata", unknownType, "seata", samples));
            }
        }
        return familySamples;
    }

    private Collector.MetricFamilySamples.Sample convertMeasurementToSample(Measurement measurement) {
        String prometheusName = measurement.getId().getName().replace(".", "_");
        ArrayList<String> labelNames = new ArrayList<String>();
        ArrayList<String> labelValues = new ArrayList<String>();
        for (Map.Entry tag : measurement.getId().getTags()) {
            labelNames.add((String)tag.getKey());
            labelValues.add((String)tag.getValue());
        }
        return new Collector.MetricFamilySamples.Sample(prometheusName, labelNames, labelValues, measurement.getValue(), Long.valueOf((long)measurement.getTimestamp()));
    }

    public static Collector.Type getUnknownType() {
        Collector.Type unknownType;
        try {
            unknownType = Collector.Type.valueOf((String)"UNKNOWN");
        }
        catch (IllegalArgumentException e) {
            unknownType = Collector.Type.valueOf((String)"UNTYPED");
        }
        return unknownType;
    }

    public List<Collector.MetricFamilySamples> describe() {
        return this.collect();
    }

    public void close() {
        this.server.stop();
    }
}

