/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.types.RowKind;

public class AuditUtils {
    public static final String DELIMITER = "&";
    private static final String IP_OR_HOST_PORT = "^(.*):([0-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5])$";

    public static HashSet<String> extractAuditIpPorts(String inlongAudit) {
        String[] ipPorts;
        HashSet<String> ipPortList = new HashSet<String>();
        for (String ipPort : ipPorts = inlongAudit.split(DELIMITER)) {
            Preconditions.checkArgument((boolean)Pattern.matches(IP_OR_HOST_PORT, ipPort), (Object)("Error inLong audit format: " + inlongAudit));
            ipPortList.add(ipPort);
        }
        return ipPortList;
    }

    public static List<Integer> extractAuditKeys(String auditKeys) {
        return Arrays.stream(auditKeys.split(DELIMITER)).map(Integer::valueOf).collect(Collectors.toList());
    }

    public static Map<RowKind, Integer> extractChangelogAuditKeyMap(String changelogAuditKeys) {
        if (StringUtils.isBlank((CharSequence)changelogAuditKeys)) {
            return ImmutableMap.of();
        }
        return Splitter.on((String)DELIMITER).withKeyValueSeparator("=").split((CharSequence)changelogAuditKeys).entrySet().stream().collect(Collectors.toMap(entry -> RowKind.valueOf((String)((String)entry.getKey())), entry -> Integer.parseInt((String)entry.getValue())));
    }
}

