/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.cos;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.cos.COSSourceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSSourceDTO {
    private static final Logger log = LoggerFactory.getLogger(COSSourceDTO.class);
    @ApiModelProperty(value="Path regex pattern for file, such as /a/b/*.txt", required=true)
    private String pattern;
    @ApiModelProperty(value="Cycle unit")
    private String cycleUnit = "D";
    @ApiModelProperty(value="Whether retry")
    private Boolean retry = false;
    @ApiModelProperty(value="Column separator of data source ")
    private String dataSeparator;
    @ApiModelProperty(value="Data start time")
    private String dataTimeFrom;
    @ApiModelProperty(value="Data end time")
    private String dataTimeTo;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;
    @ApiModelProperty(value="Max file count")
    private String maxFileCount;
    @ApiModelProperty(value=" Type of data result for column separator         CSV format, set this parameter to a custom separator: , | :          Json format, set this parameter to json ")
    private String contentStyle;
    @ApiModelProperty(value="Audit version")
    private String auditVersion;
    @ApiModelProperty(value="filterStreams")
    private List<String> filterStreams;
    @ApiModelProperty(value="COS bucket name")
    private String bucketName;
    @ApiModelProperty(value="COS secret id")
    private String credentialsId;
    @ApiModelProperty(value="COS secret key")
    private String credentialsKey;
    @ApiModelProperty(value="COS region")
    private String region;

    public static COSSourceDTO getFromRequest(@NotNull COSSourceRequest cosSourceRequest, String extParams) {
        COSSourceDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? COSSourceDTO.getFromJson(extParams) : new COSSourceDTO();
        return (COSSourceDTO)CommonBeanUtils.copyProperties((Object)cosSourceRequest, (Object)dto, (boolean)true);
    }

    public static COSSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (COSSourceDTO)JsonUtils.parseObject((String)extParams, COSSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of COSSource failure: %s", e.getMessage()));
        }
    }

    public static COSSourceDTOBuilder builder() {
        return new COSSourceDTOBuilder();
    }

    public COSSourceDTO(String pattern, String cycleUnit, Boolean retry, String dataSeparator, String dataTimeFrom, String dataTimeTo, String timeOffset, String maxFileCount, String contentStyle, String auditVersion, List<String> filterStreams, String bucketName, String credentialsId, String credentialsKey, String region) {
        this.pattern = pattern;
        this.cycleUnit = cycleUnit;
        this.retry = retry;
        this.dataSeparator = dataSeparator;
        this.dataTimeFrom = dataTimeFrom;
        this.dataTimeTo = dataTimeTo;
        this.timeOffset = timeOffset;
        this.maxFileCount = maxFileCount;
        this.contentStyle = contentStyle;
        this.auditVersion = auditVersion;
        this.filterStreams = filterStreams;
        this.bucketName = bucketName;
        this.credentialsId = credentialsId;
        this.credentialsKey = credentialsKey;
        this.region = region;
    }

    public COSSourceDTO() {
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCycleUnit() {
        return this.cycleUnit;
    }

    public Boolean getRetry() {
        return this.retry;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataTimeFrom() {
        return this.dataTimeFrom;
    }

    public String getDataTimeTo() {
        return this.dataTimeTo;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public String getMaxFileCount() {
        return this.maxFileCount;
    }

    public String getContentStyle() {
        return this.contentStyle;
    }

    public String getAuditVersion() {
        return this.auditVersion;
    }

    public List<String> getFilterStreams() {
        return this.filterStreams;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCredentialsKey() {
        return this.credentialsKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setCycleUnit(String cycleUnit) {
        this.cycleUnit = cycleUnit;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataTimeFrom(String dataTimeFrom) {
        this.dataTimeFrom = dataTimeFrom;
    }

    public void setDataTimeTo(String dataTimeTo) {
        this.dataTimeTo = dataTimeTo;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public void setMaxFileCount(String maxFileCount) {
        this.maxFileCount = maxFileCount;
    }

    public void setContentStyle(String contentStyle) {
        this.contentStyle = contentStyle;
    }

    public void setAuditVersion(String auditVersion) {
        this.auditVersion = auditVersion;
    }

    public void setFilterStreams(List<String> filterStreams) {
        this.filterStreams = filterStreams;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public void setCredentialsKey(String credentialsKey) {
        this.credentialsKey = credentialsKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSSourceDTO)) {
            return false;
        }
        COSSourceDTO other = (COSSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$retry = this.getRetry();
        Boolean other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$cycleUnit = this.getCycleUnit();
        String other$cycleUnit = other.getCycleUnit();
        if (this$cycleUnit == null ? other$cycleUnit != null : !this$cycleUnit.equals(other$cycleUnit)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataTimeFrom = this.getDataTimeFrom();
        String other$dataTimeFrom = other.getDataTimeFrom();
        if (this$dataTimeFrom == null ? other$dataTimeFrom != null : !this$dataTimeFrom.equals(other$dataTimeFrom)) {
            return false;
        }
        String this$dataTimeTo = this.getDataTimeTo();
        String other$dataTimeTo = other.getDataTimeTo();
        if (this$dataTimeTo == null ? other$dataTimeTo != null : !this$dataTimeTo.equals(other$dataTimeTo)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        if (this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset)) {
            return false;
        }
        String this$maxFileCount = this.getMaxFileCount();
        String other$maxFileCount = other.getMaxFileCount();
        if (this$maxFileCount == null ? other$maxFileCount != null : !this$maxFileCount.equals(other$maxFileCount)) {
            return false;
        }
        String this$contentStyle = this.getContentStyle();
        String other$contentStyle = other.getContentStyle();
        if (this$contentStyle == null ? other$contentStyle != null : !this$contentStyle.equals(other$contentStyle)) {
            return false;
        }
        String this$auditVersion = this.getAuditVersion();
        String other$auditVersion = other.getAuditVersion();
        if (this$auditVersion == null ? other$auditVersion != null : !this$auditVersion.equals(other$auditVersion)) {
            return false;
        }
        List<String> this$filterStreams = this.getFilterStreams();
        List<String> other$filterStreams = other.getFilterStreams();
        if (this$filterStreams == null ? other$filterStreams != null : !((Object)this$filterStreams).equals(other$filterStreams)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$credentialsId = this.getCredentialsId();
        String other$credentialsId = other.getCredentialsId();
        if (this$credentialsId == null ? other$credentialsId != null : !this$credentialsId.equals(other$credentialsId)) {
            return false;
        }
        String this$credentialsKey = this.getCredentialsKey();
        String other$credentialsKey = other.getCredentialsKey();
        if (this$credentialsKey == null ? other$credentialsKey != null : !this$credentialsKey.equals(other$credentialsKey)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !this$region.equals(other$region));
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $cycleUnit = this.getCycleUnit();
        result = result * 59 + ($cycleUnit == null ? 43 : $cycleUnit.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataTimeFrom = this.getDataTimeFrom();
        result = result * 59 + ($dataTimeFrom == null ? 43 : $dataTimeFrom.hashCode());
        String $dataTimeTo = this.getDataTimeTo();
        result = result * 59 + ($dataTimeTo == null ? 43 : $dataTimeTo.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        String $maxFileCount = this.getMaxFileCount();
        result = result * 59 + ($maxFileCount == null ? 43 : $maxFileCount.hashCode());
        String $contentStyle = this.getContentStyle();
        result = result * 59 + ($contentStyle == null ? 43 : $contentStyle.hashCode());
        String $auditVersion = this.getAuditVersion();
        result = result * 59 + ($auditVersion == null ? 43 : $auditVersion.hashCode());
        List<String> $filterStreams = this.getFilterStreams();
        result = result * 59 + ($filterStreams == null ? 43 : ((Object)$filterStreams).hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $credentialsId = this.getCredentialsId();
        result = result * 59 + ($credentialsId == null ? 43 : $credentialsId.hashCode());
        String $credentialsKey = this.getCredentialsKey();
        result = result * 59 + ($credentialsKey == null ? 43 : $credentialsKey.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        return result;
    }

    public String toString() {
        return "COSSourceDTO(pattern=" + this.getPattern() + ", cycleUnit=" + this.getCycleUnit() + ", retry=" + this.getRetry() + ", dataSeparator=" + this.getDataSeparator() + ", dataTimeFrom=" + this.getDataTimeFrom() + ", dataTimeTo=" + this.getDataTimeTo() + ", timeOffset=" + this.getTimeOffset() + ", maxFileCount=" + this.getMaxFileCount() + ", contentStyle=" + this.getContentStyle() + ", auditVersion=" + this.getAuditVersion() + ", filterStreams=" + this.getFilterStreams() + ", bucketName=" + this.getBucketName() + ", credentialsId=" + this.getCredentialsId() + ", credentialsKey=" + this.getCredentialsKey() + ", region=" + this.getRegion() + ")";
    }

    public static class COSSourceDTOBuilder {
        private String pattern;
        private String cycleUnit;
        private Boolean retry;
        private String dataSeparator;
        private String dataTimeFrom;
        private String dataTimeTo;
        private String timeOffset;
        private String maxFileCount;
        private String contentStyle;
        private String auditVersion;
        private List<String> filterStreams;
        private String bucketName;
        private String credentialsId;
        private String credentialsKey;
        private String region;

        COSSourceDTOBuilder() {
        }

        public COSSourceDTOBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public COSSourceDTOBuilder cycleUnit(String cycleUnit) {
            this.cycleUnit = cycleUnit;
            return this;
        }

        public COSSourceDTOBuilder retry(Boolean retry) {
            this.retry = retry;
            return this;
        }

        public COSSourceDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public COSSourceDTOBuilder dataTimeFrom(String dataTimeFrom) {
            this.dataTimeFrom = dataTimeFrom;
            return this;
        }

        public COSSourceDTOBuilder dataTimeTo(String dataTimeTo) {
            this.dataTimeTo = dataTimeTo;
            return this;
        }

        public COSSourceDTOBuilder timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return this;
        }

        public COSSourceDTOBuilder maxFileCount(String maxFileCount) {
            this.maxFileCount = maxFileCount;
            return this;
        }

        public COSSourceDTOBuilder contentStyle(String contentStyle) {
            this.contentStyle = contentStyle;
            return this;
        }

        public COSSourceDTOBuilder auditVersion(String auditVersion) {
            this.auditVersion = auditVersion;
            return this;
        }

        public COSSourceDTOBuilder filterStreams(List<String> filterStreams) {
            this.filterStreams = filterStreams;
            return this;
        }

        public COSSourceDTOBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public COSSourceDTOBuilder credentialsId(String credentialsId) {
            this.credentialsId = credentialsId;
            return this;
        }

        public COSSourceDTOBuilder credentialsKey(String credentialsKey) {
            this.credentialsKey = credentialsKey;
            return this;
        }

        public COSSourceDTOBuilder region(String region) {
            this.region = region;
            return this;
        }

        public COSSourceDTO build() {
            return new COSSourceDTO(this.pattern, this.cycleUnit, this.retry, this.dataSeparator, this.dataTimeFrom, this.dataTimeTo, this.timeOffset, this.maxFileCount, this.contentStyle, this.auditVersion, this.filterStreams, this.bucketName, this.credentialsId, this.credentialsKey, this.region);
        }

        public String toString() {
            return "COSSourceDTO.COSSourceDTOBuilder(pattern=" + this.pattern + ", cycleUnit=" + this.cycleUnit + ", retry=" + this.retry + ", dataSeparator=" + this.dataSeparator + ", dataTimeFrom=" + this.dataTimeFrom + ", dataTimeTo=" + this.dataTimeTo + ", timeOffset=" + this.timeOffset + ", maxFileCount=" + this.maxFileCount + ", contentStyle=" + this.contentStyle + ", auditVersion=" + this.auditVersion + ", filterStreams=" + this.filterStreams + ", bucketName=" + this.bucketName + ", credentialsId=" + this.credentialsId + ", credentialsKey=" + this.credentialsKey + ", region=" + this.region + ")";
        }
    }
}

