/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.hudi;

import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.hudi.HudiSourceRequest;

public class HudiSourceDTO {
    @ApiModelProperty(value="The database name of hudi")
    private String dbName;
    @ApiModelProperty(value="The table name of hudi")
    private String tableName;
    @ApiModelProperty(value="The catalog uri of hudi")
    private String catalogUri;
    @ApiModelProperty(value="The dfs base path of hudi")
    private String warehouse;
    @ApiModelProperty(value="The flag indicate whether skip files in compaction")
    private boolean readStreamingSkipCompaction;
    @ApiModelProperty(value="The start commit id")
    private String readStartCommit;
    @ApiModelProperty(value="Extended properties")
    private List<HashMap<String, String>> extList;
    @ApiModelProperty(value="Properties for hudi")
    private Map<String, Object> properties;

    public static HudiSourceDTO getFromRequest(HudiSourceRequest request, String extParams) {
        HudiSourceDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? HudiSourceDTO.getFromJson(extParams) : new HudiSourceDTO();
        return (HudiSourceDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static HudiSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (HudiSourceDTO)JsonUtils.parseObject((String)extParams, HudiSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of HudiSource failure: %s", e.getMessage()));
        }
    }

    public static HudiSourceDTOBuilder builder() {
        return new HudiSourceDTOBuilder();
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public boolean isReadStreamingSkipCompaction() {
        return this.readStreamingSkipCompaction;
    }

    public String getReadStartCommit() {
        return this.readStartCommit;
    }

    public List<HashMap<String, String>> getExtList() {
        return this.extList;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setReadStreamingSkipCompaction(boolean readStreamingSkipCompaction) {
        this.readStreamingSkipCompaction = readStreamingSkipCompaction;
    }

    public void setReadStartCommit(String readStartCommit) {
        this.readStartCommit = readStartCommit;
    }

    public void setExtList(List<HashMap<String, String>> extList) {
        this.extList = extList;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiSourceDTO)) {
            return false;
        }
        HudiSourceDTO other = (HudiSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReadStreamingSkipCompaction() != other.isReadStreamingSkipCompaction()) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$readStartCommit = this.getReadStartCommit();
        String other$readStartCommit = other.getReadStartCommit();
        if (this$readStartCommit == null ? other$readStartCommit != null : !this$readStartCommit.equals(other$readStartCommit)) {
            return false;
        }
        List<HashMap<String, String>> this$extList = this.getExtList();
        List<HashMap<String, String>> other$extList = other.getExtList();
        if (this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HudiSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReadStreamingSkipCompaction() ? 79 : 97);
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $readStartCommit = this.getReadStartCommit();
        result = result * 59 + ($readStartCommit == null ? 43 : $readStartCommit.hashCode());
        List<HashMap<String, String>> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "HudiSourceDTO(dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", readStreamingSkipCompaction=" + this.isReadStreamingSkipCompaction() + ", readStartCommit=" + this.getReadStartCommit() + ", extList=" + this.getExtList() + ", properties=" + this.getProperties() + ")";
    }

    public HudiSourceDTO() {
    }

    public HudiSourceDTO(String dbName, String tableName, String catalogUri, String warehouse, boolean readStreamingSkipCompaction, String readStartCommit, List<HashMap<String, String>> extList, Map<String, Object> properties) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.catalogUri = catalogUri;
        this.warehouse = warehouse;
        this.readStreamingSkipCompaction = readStreamingSkipCompaction;
        this.readStartCommit = readStartCommit;
        this.extList = extList;
        this.properties = properties;
    }

    public static class HudiSourceDTOBuilder {
        private String dbName;
        private String tableName;
        private String catalogUri;
        private String warehouse;
        private boolean readStreamingSkipCompaction;
        private String readStartCommit;
        private List<HashMap<String, String>> extList;
        private Map<String, Object> properties;

        HudiSourceDTOBuilder() {
        }

        public HudiSourceDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public HudiSourceDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public HudiSourceDTOBuilder catalogUri(String catalogUri) {
            this.catalogUri = catalogUri;
            return this;
        }

        public HudiSourceDTOBuilder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public HudiSourceDTOBuilder readStreamingSkipCompaction(boolean readStreamingSkipCompaction) {
            this.readStreamingSkipCompaction = readStreamingSkipCompaction;
            return this;
        }

        public HudiSourceDTOBuilder readStartCommit(String readStartCommit) {
            this.readStartCommit = readStartCommit;
            return this;
        }

        public HudiSourceDTOBuilder extList(List<HashMap<String, String>> extList) {
            this.extList = extList;
            return this;
        }

        public HudiSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public HudiSourceDTO build() {
            return new HudiSourceDTO(this.dbName, this.tableName, this.catalogUri, this.warehouse, this.readStreamingSkipCompaction, this.readStartCommit, this.extList, this.properties);
        }

        public String toString() {
            return "HudiSourceDTO.HudiSourceDTOBuilder(dbName=" + this.dbName + ", tableName=" + this.tableName + ", catalogUri=" + this.catalogUri + ", warehouse=" + this.warehouse + ", readStreamingSkipCompaction=" + this.readStreamingSkipCompaction + ", readStartCommit=" + this.readStartCommit + ", extList=" + this.extList + ", properties=" + this.properties + ")";
        }
    }
}

