/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.workflow;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel(value="Workflow process request")
public class ProcessRequest
extends PageRequest {
    @ApiModelProperty(value="Process ID")
    private Integer id;
    @ApiModelProperty(value="Process id list")
    private List<Integer> idList;
    @ApiModelProperty(value="Process name list")
    private List<String> nameList;
    @ApiModelProperty(value="Process display name")
    private String displayName;
    @ApiModelProperty(value="Inlong tenant name")
    private String tenant;
    @ApiModelProperty(value="Applicant")
    private String applicant;
    @ApiModelProperty(value="Status")
    private ProcessStatus status;
    @ApiModelProperty(value="Inlong group id")
    private String inlongGroupId;
    @ApiModelProperty(value="Inlong stream id")
    private String inlongStreamId;
    @ApiModelProperty(value="Start time-lower limit")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTimeBegin;
    @ApiModelProperty(value="Start time-upper limit")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTimeEnd;
    @ApiModelProperty(value="End time-lower limit")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTimeBegin;
    @ApiModelProperty(value="End time-upper limit")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTimeEnd;
    @ApiModelProperty(value="Whether to hide, 0: not hidden, 1: hidden")
    private Integer hidden;
    @ApiModelProperty(value="Whether to include the current to-do task")
    private Boolean includeCurrentTask;
    @ApiModelProperty(value="Whether to include the form info displayed in the list")
    private Boolean includeShowInList;

    private static Integer $default$hidden() {
        return 0;
    }

    private static Boolean $default$includeCurrentTask() {
        return false;
    }

    private static Boolean $default$includeShowInList() {
        return true;
    }

    public static ProcessRequestBuilder builder() {
        return new ProcessRequestBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public List<Integer> getIdList() {
        return this.idList;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getApplicant() {
        return this.applicant;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public Date getStartTimeBegin() {
        return this.startTimeBegin;
    }

    public Date getStartTimeEnd() {
        return this.startTimeEnd;
    }

    public Date getEndTimeBegin() {
        return this.endTimeBegin;
    }

    public Date getEndTimeEnd() {
        return this.endTimeEnd;
    }

    public Integer getHidden() {
        return this.hidden;
    }

    public Boolean getIncludeCurrentTask() {
        return this.includeCurrentTask;
    }

    public Boolean getIncludeShowInList() {
        return this.includeShowInList;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setIdList(List<Integer> idList) {
        this.idList = idList;
    }

    public void setNameList(List<String> nameList) {
        this.nameList = nameList;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setApplicant(String applicant) {
        this.applicant = applicant;
    }

    public void setStatus(ProcessStatus status) {
        this.status = status;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setStartTimeBegin(Date startTimeBegin) {
        this.startTimeBegin = startTimeBegin;
    }

    public void setStartTimeEnd(Date startTimeEnd) {
        this.startTimeEnd = startTimeEnd;
    }

    public void setEndTimeBegin(Date endTimeBegin) {
        this.endTimeBegin = endTimeBegin;
    }

    public void setEndTimeEnd(Date endTimeEnd) {
        this.endTimeEnd = endTimeEnd;
    }

    public void setHidden(Integer hidden) {
        this.hidden = hidden;
    }

    public void setIncludeCurrentTask(Boolean includeCurrentTask) {
        this.includeCurrentTask = includeCurrentTask;
    }

    public void setIncludeShowInList(Boolean includeShowInList) {
        this.includeShowInList = includeShowInList;
    }

    public String toString() {
        return "ProcessRequest(id=" + this.getId() + ", idList=" + this.getIdList() + ", nameList=" + this.getNameList() + ", displayName=" + this.getDisplayName() + ", tenant=" + this.getTenant() + ", applicant=" + this.getApplicant() + ", status=" + this.getStatus() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", startTimeBegin=" + this.getStartTimeBegin() + ", startTimeEnd=" + this.getStartTimeEnd() + ", endTimeBegin=" + this.getEndTimeBegin() + ", endTimeEnd=" + this.getEndTimeEnd() + ", hidden=" + this.getHidden() + ", includeCurrentTask=" + this.getIncludeCurrentTask() + ", includeShowInList=" + this.getIncludeShowInList() + ")";
    }

    public ProcessRequest() {
        this.hidden = ProcessRequest.$default$hidden();
        this.includeCurrentTask = ProcessRequest.$default$includeCurrentTask();
        this.includeShowInList = ProcessRequest.$default$includeShowInList();
    }

    public ProcessRequest(Integer id, List<Integer> idList, List<String> nameList, String displayName, String tenant, String applicant, ProcessStatus status, String inlongGroupId, String inlongStreamId, Date startTimeBegin, Date startTimeEnd, Date endTimeBegin, Date endTimeEnd, Integer hidden, Boolean includeCurrentTask, Boolean includeShowInList) {
        this.id = id;
        this.idList = idList;
        this.nameList = nameList;
        this.displayName = displayName;
        this.tenant = tenant;
        this.applicant = applicant;
        this.status = status;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.startTimeBegin = startTimeBegin;
        this.startTimeEnd = startTimeEnd;
        this.endTimeBegin = endTimeBegin;
        this.endTimeEnd = endTimeEnd;
        this.hidden = hidden;
        this.includeCurrentTask = includeCurrentTask;
        this.includeShowInList = includeShowInList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessRequest)) {
            return false;
        }
        ProcessRequest other = (ProcessRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$hidden = this.getHidden();
        Integer other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        Boolean this$includeCurrentTask = this.getIncludeCurrentTask();
        Boolean other$includeCurrentTask = other.getIncludeCurrentTask();
        if (this$includeCurrentTask == null ? other$includeCurrentTask != null : !((Object)this$includeCurrentTask).equals(other$includeCurrentTask)) {
            return false;
        }
        Boolean this$includeShowInList = this.getIncludeShowInList();
        Boolean other$includeShowInList = other.getIncludeShowInList();
        if (this$includeShowInList == null ? other$includeShowInList != null : !((Object)this$includeShowInList).equals(other$includeShowInList)) {
            return false;
        }
        List<Integer> this$idList = this.getIdList();
        List<Integer> other$idList = other.getIdList();
        if (this$idList == null ? other$idList != null : !((Object)this$idList).equals(other$idList)) {
            return false;
        }
        List<String> this$nameList = this.getNameList();
        List<String> other$nameList = other.getNameList();
        if (this$nameList == null ? other$nameList != null : !((Object)this$nameList).equals(other$nameList)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$applicant = this.getApplicant();
        String other$applicant = other.getApplicant();
        if (this$applicant == null ? other$applicant != null : !this$applicant.equals(other$applicant)) {
            return false;
        }
        ProcessStatus this$status = this.getStatus();
        ProcessStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        Date this$startTimeBegin = this.getStartTimeBegin();
        Date other$startTimeBegin = other.getStartTimeBegin();
        if (this$startTimeBegin == null ? other$startTimeBegin != null : !((Object)this$startTimeBegin).equals(other$startTimeBegin)) {
            return false;
        }
        Date this$startTimeEnd = this.getStartTimeEnd();
        Date other$startTimeEnd = other.getStartTimeEnd();
        if (this$startTimeEnd == null ? other$startTimeEnd != null : !((Object)this$startTimeEnd).equals(other$startTimeEnd)) {
            return false;
        }
        Date this$endTimeBegin = this.getEndTimeBegin();
        Date other$endTimeBegin = other.getEndTimeBegin();
        if (this$endTimeBegin == null ? other$endTimeBegin != null : !((Object)this$endTimeBegin).equals(other$endTimeBegin)) {
            return false;
        }
        Date this$endTimeEnd = this.getEndTimeEnd();
        Date other$endTimeEnd = other.getEndTimeEnd();
        return !(this$endTimeEnd == null ? other$endTimeEnd != null : !((Object)this$endTimeEnd).equals(other$endTimeEnd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        Boolean $includeCurrentTask = this.getIncludeCurrentTask();
        result = result * 59 + ($includeCurrentTask == null ? 43 : ((Object)$includeCurrentTask).hashCode());
        Boolean $includeShowInList = this.getIncludeShowInList();
        result = result * 59 + ($includeShowInList == null ? 43 : ((Object)$includeShowInList).hashCode());
        List<Integer> $idList = this.getIdList();
        result = result * 59 + ($idList == null ? 43 : ((Object)$idList).hashCode());
        List<String> $nameList = this.getNameList();
        result = result * 59 + ($nameList == null ? 43 : ((Object)$nameList).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $applicant = this.getApplicant();
        result = result * 59 + ($applicant == null ? 43 : $applicant.hashCode());
        ProcessStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        Date $startTimeBegin = this.getStartTimeBegin();
        result = result * 59 + ($startTimeBegin == null ? 43 : ((Object)$startTimeBegin).hashCode());
        Date $startTimeEnd = this.getStartTimeEnd();
        result = result * 59 + ($startTimeEnd == null ? 43 : ((Object)$startTimeEnd).hashCode());
        Date $endTimeBegin = this.getEndTimeBegin();
        result = result * 59 + ($endTimeBegin == null ? 43 : ((Object)$endTimeBegin).hashCode());
        Date $endTimeEnd = this.getEndTimeEnd();
        result = result * 59 + ($endTimeEnd == null ? 43 : ((Object)$endTimeEnd).hashCode());
        return result;
    }

    public static class ProcessRequestBuilder {
        private Integer id;
        private List<Integer> idList;
        private List<String> nameList;
        private String displayName;
        private String tenant;
        private String applicant;
        private ProcessStatus status;
        private String inlongGroupId;
        private String inlongStreamId;
        private Date startTimeBegin;
        private Date startTimeEnd;
        private Date endTimeBegin;
        private Date endTimeEnd;
        private boolean hidden$set;
        private Integer hidden$value;
        private boolean includeCurrentTask$set;
        private Boolean includeCurrentTask$value;
        private boolean includeShowInList$set;
        private Boolean includeShowInList$value;

        ProcessRequestBuilder() {
        }

        public ProcessRequestBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public ProcessRequestBuilder idList(List<Integer> idList) {
            this.idList = idList;
            return this;
        }

        public ProcessRequestBuilder nameList(List<String> nameList) {
            this.nameList = nameList;
            return this;
        }

        public ProcessRequestBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ProcessRequestBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public ProcessRequestBuilder applicant(String applicant) {
            this.applicant = applicant;
            return this;
        }

        public ProcessRequestBuilder status(ProcessStatus status) {
            this.status = status;
            return this;
        }

        public ProcessRequestBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public ProcessRequestBuilder inlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
            return this;
        }

        public ProcessRequestBuilder startTimeBegin(Date startTimeBegin) {
            this.startTimeBegin = startTimeBegin;
            return this;
        }

        public ProcessRequestBuilder startTimeEnd(Date startTimeEnd) {
            this.startTimeEnd = startTimeEnd;
            return this;
        }

        public ProcessRequestBuilder endTimeBegin(Date endTimeBegin) {
            this.endTimeBegin = endTimeBegin;
            return this;
        }

        public ProcessRequestBuilder endTimeEnd(Date endTimeEnd) {
            this.endTimeEnd = endTimeEnd;
            return this;
        }

        public ProcessRequestBuilder hidden(Integer hidden) {
            this.hidden$value = hidden;
            this.hidden$set = true;
            return this;
        }

        public ProcessRequestBuilder includeCurrentTask(Boolean includeCurrentTask) {
            this.includeCurrentTask$value = includeCurrentTask;
            this.includeCurrentTask$set = true;
            return this;
        }

        public ProcessRequestBuilder includeShowInList(Boolean includeShowInList) {
            this.includeShowInList$value = includeShowInList;
            this.includeShowInList$set = true;
            return this;
        }

        public ProcessRequest build() {
            Integer hidden$value = this.hidden$value;
            if (!this.hidden$set) {
                hidden$value = ProcessRequest.$default$hidden();
            }
            Boolean includeCurrentTask$value = this.includeCurrentTask$value;
            if (!this.includeCurrentTask$set) {
                includeCurrentTask$value = ProcessRequest.$default$includeCurrentTask();
            }
            Boolean includeShowInList$value = this.includeShowInList$value;
            if (!this.includeShowInList$set) {
                includeShowInList$value = ProcessRequest.$default$includeShowInList();
            }
            return new ProcessRequest(this.id, this.idList, this.nameList, this.displayName, this.tenant, this.applicant, this.status, this.inlongGroupId, this.inlongStreamId, this.startTimeBegin, this.startTimeEnd, this.endTimeBegin, this.endTimeEnd, hidden$value, includeCurrentTask$value, includeShowInList$value);
        }

        public String toString() {
            return "ProcessRequest.ProcessRequestBuilder(id=" + this.id + ", idList=" + this.idList + ", nameList=" + this.nameList + ", displayName=" + this.displayName + ", tenant=" + this.tenant + ", applicant=" + this.applicant + ", status=" + this.status + ", inlongGroupId=" + this.inlongGroupId + ", inlongStreamId=" + this.inlongStreamId + ", startTimeBegin=" + this.startTimeBegin + ", startTimeEnd=" + this.startTimeEnd + ", endTimeBegin=" + this.endTimeBegin + ", endTimeEnd=" + this.endTimeEnd + ", hidden$value=" + this.hidden$value + ", includeCurrentTask$value=" + this.includeCurrentTask$value + ", includeShowInList$value=" + this.includeShowInList$value + ")";
        }
    }
}

