/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.encryption;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="encryption", names={"decode"}, parameter="(Binary binary,String charsetStr)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return the result of encoding 'binary' using the character set specified by 'charsetStr'.", "Note: 'charsetStr' is one of ('US-ASCII', 'ISO-8859-1', 'UTF-8', 'UTF-16BE', 'UTF-16LE', 'UTF-16')."}, examples={"decode(encode('Hello','UTF-8'),'UTF-8') = \"Hello\""})
public class DecodeFunction
implements ValueParser {
    private ValueParser binaryParser;
    private ValueParser characterSetParser;
    private static final Set<String> SUPPORTED_CHARSETS;

    public DecodeFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (expressions != null && expressions.size() == 2) {
            this.binaryParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.characterSetParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object binaryObj = this.binaryParser.parse(sourceData, rowIndex, context);
        Object characterObj = this.characterSetParser.parse(sourceData, rowIndex, context);
        if (binaryObj == null || characterObj == null) {
            return null;
        }
        String characterSetValue = OperatorTools.parseString(characterObj).toUpperCase();
        return this.decode((byte[])binaryObj, characterSetValue);
    }

    private String decode(byte[] binaryString, String charsetName) {
        if (binaryString == null || charsetName == null || charsetName.isEmpty()) {
            return "";
        }
        if (Charset.isSupported(charsetName) && SUPPORTED_CHARSETS.contains(charsetName)) {
            Charset charset = Charset.forName(charsetName);
            return new String(binaryString, charset);
        }
        return "";
    }

    static {
        HashSet<String> charsets = new HashSet<String>();
        charsets.add(StandardCharsets.US_ASCII.name());
        charsets.add(StandardCharsets.ISO_8859_1.name());
        charsets.add(StandardCharsets.UTF_8.name());
        charsets.add(StandardCharsets.UTF_16.name());
        charsets.add(StandardCharsets.UTF_16BE.name());
        charsets.add(StandardCharsets.UTF_16LE.name());
        SUPPORTED_CHARSETS = Collections.unmodifiableSet(charsets);
    }
}

