/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.apache.inlong.sdk.transform.process.utils.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="temporal", names={"timediff", "time_diff"}, parameter="(String dateStr1, String dateStr2)", descriptions={"- Return \"\" if 'dateStr1' or 'dateStr2' is NULL and the conversion types of 'dateStr1' and 'dateStr2' are different;", "- Return 'dateStr1' - 'dateStr2' expressed as a time value.", "Note: 'dateStr1' and 'dateStr2' are strings converted to TIME or DATETIME expressions."}, examples={"timediff('23:59:59.000001','01:01:01.000002') = \"22:58:57.999998\""})
public class TimeDiffFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(TimeDiffFunction.class);
    private final ValueParser leftDateParser;
    private final ValueParser rightDateParser;

    public TimeDiffFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.leftDateParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.rightDateParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftDateObj = this.leftDateParser.parse(sourceData, rowIndex, context);
        Object rightDateObj = this.rightDateParser.parse(sourceData, rowIndex, context);
        if (leftDateObj == null || rightDateObj == null) {
            return null;
        }
        String leftDate = OperatorTools.parseString(leftDateObj);
        String rightDate = OperatorTools.parseString(rightDateObj);
        if (leftDate.isEmpty() || rightDate.isEmpty()) {
            return null;
        }
        boolean leftHasTime = leftDate.indexOf(32) != -1;
        boolean rightHasTime = rightDate.indexOf(32) != -1;
        boolean leftHasMicros = leftDate.indexOf(46) != -1;
        boolean rightHasMicros = rightDate.indexOf(46) != -1;
        try {
            Comparable<ChronoLocalDateTime<?>> left = null;
            Comparable<ChronoLocalDateTime<?>> right = null;
            if (leftHasTime && rightHasTime) {
                left = DateUtil.parseLocalDateTime(leftDate);
                right = DateUtil.parseLocalDateTime(rightDate);
            } else if (!leftHasTime && !rightHasTime) {
                left = DateUtil.parseLocalTime(leftDate);
                right = DateUtil.parseLocalTime(rightDate);
            }
            if (left == null || right == null) {
                return null;
            }
            long nanoDifference = ChronoUnit.NANOS.between((Temporal)((Object)right), (Temporal)((Object)left));
            long totalSeconds = nanoDifference / 1000000000L;
            long microseconds = Math.abs(nanoDifference % 1000000000L / 1000L);
            boolean isNegative = nanoDifference < 0L;
            long absTotalSeconds = Math.abs(totalSeconds);
            long hours = absTotalSeconds / 3600L;
            long minutes = absTotalSeconds % 3600L / 60L;
            long seconds = absTotalSeconds % 60L;
            String between = String.format("%s%02d:%02d:%02d", isNegative ? "-" : "", Math.abs(hours), Math.abs(minutes), Math.abs(seconds));
            if (leftHasMicros || rightHasMicros) {
                between = between + String.format(".%06d", Math.abs(microseconds));
            }
            return between;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

