/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.admin.ZkSecurityMigrator$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$QuotaConfigs$;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ConfigCommand$
implements kafka.common.Config {
    public static ConfigCommand$ MODULE$;
    private final String BrokerDefaultEntityName;
    private final String BrokerLoggerConfigType;
    private final Seq<String> BrokerSupportedConfigTypes;
    private final Seq<String> ZkSupportedConfigTypes;
    private final int DefaultScramIterations;
    private final Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value) {
        kafka.common.Config.validateChars$(this, prop, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String BrokerDefaultEntityName() {
        return this.BrokerDefaultEntityName;
    }

    public String BrokerLoggerConfigType() {
        return this.BrokerLoggerConfigType;
    }

    public Seq<String> BrokerSupportedConfigTypes() {
        return this.BrokerSupportedConfigTypes;
    }

    public Seq<String> ZkSupportedConfigTypes() {
        return this.ZkSupportedConfigTypes;
    }

    public int DefaultScramIterations() {
        return this.DefaultScramIterations;
    }

    public Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning() {
        return this.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manipulate and describe entity config for a topic, client, user or broker");
            opts.checkArgs();
            if (!opts.options().has(opts.zkConnectOpt())) {
                this.processCommand(opts);
                return;
            }
            Predef$.MODULE$.println((Object)"Warning: --zookeeper is deprecated and will be removed in a future version of Kafka.");
            Predef$.MODULE$.println((Object)"Use --bootstrap-server instead to specify a broker to connect to.");
            this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException);
            if (bl) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(throwable.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable != null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString());
                throwable.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw null;
        }
    }

    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        Option<ZKClientConfig> option = ZkSecurityMigrator$.MODULE$.createZkClientConfigFromOption(opts.options(), opts.zkTlsConfigFile());
        if (option == null) {
            throw null;
        }
        Option<ZKClientConfig> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? ConfigCommand$.$anonfun$processCommandWithZk$1() : getOrElse_this.get();
        Object zkClientConfig = object;
        boolean x$2 = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled((ZKClientConfig)zkClientConfig);
        int x$3 = 30000;
        int x$4 = 30000;
        int x$5 = Integer.MAX_VALUE;
        Time x$6 = Time.SYSTEM;
        Some x$7 = new Some(zkClientConfig);
        String x$8 = KafkaZkClient$.MODULE$.apply$default$7();
        String x$9 = KafkaZkClient$.MODULE$.apply$default$8();
        Option<String> x$10 = KafkaZkClient$.MODULE$.apply$default$9();
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, x$2, x$3, x$4, x$5, x$6, x$8, x$9, x$10, (Option<ZKClientConfig>)x$7);
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfigWithZk(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfigWithZk(zkClient, opts, adminZkClient);
            }
        }
        finally {
            zkClient.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        } else {
            Set dynamicBrokerConfigs;
            String string3 = entityType;
            String string4 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && (dynamicBrokerConfigs = (Set)((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfigWithZk$1(elem)))).nonEmpty()) {
                String string5 = entityName;
                String string6 = ConfigEntityName$.MODULE$.Default();
                boolean perBrokerConfig = string5 == null ? string6 != null : !string5.equals(string6);
                String errorMessage = new StringBuilder(70).append("--bootstrap-server option must be specified to update broker configs ").append(dynamicBrokerConfigs).append(".").toString();
                String info = "Broker configuration updates using ZooKeeper are supported for bootstrapping before brokers are started to enable encrypted password configs to be stored in ZooKeeper.";
                if (perBrokerConfig) {
                    Option<Object> option = adminZkClient.parseBroker(entityName);
                    if (option == null) {
                        throw null;
                    }
                    Option<Object> foreach_this = option;
                    if (!foreach_this.isEmpty()) {
                        int n = BoxesRunTime.unboxToInt((Object)foreach_this.get());
                        ConfigCommand$.$anonfun$alterConfigWithZk$2(zkClient, errorMessage, entityName, info, n);
                    }
                } else {
                    void require_requirement;
                    boolean bl = zkClient.getAllBrokersInCluster().isEmpty();
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    if (require_requirement == false) {
                        throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$alterConfigWithZk$4(errorMessage, info)).toString());
                    }
                }
                this.preProcessBrokerConfigs(configsToBeAdded, perBrokerConfig);
            }
        }
        Properties configs = adminZkClient.fetchEntityConfig(entityType, entityName);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)configs.containsKey(x$1)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$2 -> configs.remove(x$2));
        adminZkClient.changeConfigs(entityType, entityName, configs);
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Completed updating config for entity: ").append(entity).append(".").toString());
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])org.apache.kafka.common.security.scram.internals.ScramMechanism.values()));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            org.apache.kafka.common.security.scram.internals.ScramMechanism scramMechanism = (org.apache.kafka.common.security.scram.internals.ScramMechanism)foreach_this.apply(foreach_i);
            ConfigCommand$.$anonfun$preProcessScramCredentials$1(this, configsToBeAdded, scramMechanism);
        }
    }

    public PasswordEncoder createPasswordEncoder(Map<String, String> encoderConfigs) {
        encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        String encoderSecret = (String)encoderConfigs.getOrElse((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Password encoder secret not specified");
        });
        Option option = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp());
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? Defaults$.MODULE$.PasswordEncoderCipherAlgorithm() : getOrElse_this.get();
        Option option2 = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp());
        if (option2 == null) {
            throw null;
        }
        Option map_this = option2;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$3((String)map_this.get())));
        if (object2 == null) {
            throw null;
        }
        Object object3 = object2.isEmpty() ? BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.PasswordEncoderKeyLength()) : object2.get();
        Option option3 = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp());
        if (option3 == null) {
            throw null;
        }
        Option map_this2 = option3;
        Object object4 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$5((String)map_this2.get())));
        if (object4 == null) {
            throw null;
        }
        Object object5 = object4.isEmpty() ? BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.PasswordEncoderIterations()) : object4.get();
        return new PasswordEncoder(new Password(encoderSecret), (Option<String>)None$.MODULE$, (String)object, BoxesRunTime.unboxToInt((Object)object3), BoxesRunTime.unboxToInt((Object)object5));
    }

    /*
     * WARNING - void declaration
     */
    private void preProcessBrokerConfigs(Properties configsToBeAdded, boolean perBrokerConfig) {
        Properties passwordEncoderConfigs = new Properties();
        Implicits$.MODULE$.PropertiesOps(passwordEncoderConfigs).$plus$plus$eq((Map<String, Object>)((Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$preProcessBrokerConfigs$1(x0$1)))));
        if (!passwordEncoderConfigs.isEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ConfigCommand$.$anonfun$preProcessBrokerConfigs$2(passwordEncoderConfigs)));
            }
            ((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()).keySet().foreach((Function1 & Serializable & scala.Serializable)x$1 -> configsToBeAdded.remove(x$1));
        }
        DynamicBrokerConfig$.MODULE$.validateConfigs(configsToBeAdded, perBrokerConfig);
        Set passwordConfigs = (Set)((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)));
        if (passwordConfigs.nonEmpty()) {
            void require_requirement;
            boolean bl = passwordEncoderConfigs.containsKey(KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (require_requirement == false) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$preProcessBrokerConfigs$5(passwordConfigs)).toString());
            }
            PasswordEncoder passwordEncoder = this.createPasswordEncoder((Map<String, String>)((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()));
            passwordConfigs.foreach((Function1 & Serializable & scala.Serializable)configName -> {
                String encodedValue = passwordEncoder.encode(new Password(configsToBeAdded.getProperty((String)configName)));
                return configsToBeAdded.setProperty((String)configName, encodedValue);
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var6_5 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        configEntity.getAllEntities(zkClient).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$describeConfigWithZk$1$adapted(kafka.zk.AdminZkClient boolean kafka.admin.ConfigCommand$ConfigEntity ), (Lkafka/admin/ConfigCommand$ConfigEntity;)Ljava/lang/Object;)((AdminZkClient)adminZkClient, (boolean)describeAllUsers));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        Properties props = new Properties();
        if (opts.options().has(opts.addConfigFile())) {
            String file = (String)opts.options().valueOf(opts.addConfigFile());
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(Utils.loadProps((String)file));
        }
        if (opts.options().has(opts.addConfig())) {
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.addConfig())).split(new StringBuilder(1).append(",").append(pattern).toString()))), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.split(new StringBuilder(7).append("\\s*=\\s*").append(pattern).toString(), -1), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            boolean bl = IndexedSeqOptimized.forall$((IndexedSeqOptimized)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded)), (Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(config)));
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$parseConfigsToBeAdded$3()).toString());
            }
            ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded));
            int foreach_len = foreach_this.length();
            for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                String[] stringArray = (String[])foreach_this.apply(foreach_i);
                props.setProperty(stringArray[0].trim(), stringArray[1].replaceAll("\\[?\\]?", "").trim());
            }
        }
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            Predef$.MODULE$.println((Object)new StringBuilder(165).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.trim(), Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$8 -> propsToBeDeleted.setProperty((String)x$8, ""));
            return var2_2;
        }
        return Nil$.MODULE$;
    }

    private void processCommand(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        Admin adminClient = Admin.create((Properties)props);
        if (opts.options().has((OptionSpec)opts.alterOpt()) && opts.entityTypes().size() != opts.entityNames().size()) {
            throw new IllegalArgumentException("An entity name must be specified for every entity type");
        }
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(adminClient, opts);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(adminClient, opts);
            }
        }
        finally {
            adminClient.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        List<String> entityTypes = opts.entityTypes();
        LinearSeqOptimized entityNames = opts.entityNames();
        String entityTypeHead = (String)entityTypes.head();
        String entityNameHead = (String)entityNames.head();
        scala.collection.immutable.Map configsToBeAddedMap = ((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(this.parseConfigsToBeAdded(opts)).asScala()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map configsToBeAdded = (scala.collection.immutable.Map)configsToBeAddedMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityTypeHead) : entityTypeHead != null)) {
            void $minus$greater$extension_$this;
            scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
            if (invalidConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
            }
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, entityNameHead);
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
            Collection alterEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1 & Serializable & scala.Serializable)x$9 -> new AlterConfigOp(x$9, AlterConfigOp.OpType.SET), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
            Tuple2[] tuple2Array = new Tuple2[1];
            Object object = Predef$.MODULE$.ArrowAssoc((Object)configResource);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)alterEntries);
            Void cfr_ignored_0 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        } else {
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityTypeHead) : entityTypeHead != null)) {
                void $minus$greater$extension_$this;
                scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
                if (invalidConfigs.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
                }
                scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)oldConfig.$plus$plus((GenTraversableOnce)configsToBeAdded).$minus$minus(configsToBeDeleted);
                scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$8(x$10)));
                if (sensitiveEntries.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(84).append("All sensitive broker config entries must be specified for --alter, missing entries: ").append(sensitiveEntries.keySet()).toString());
                }
                Config newConfig = new Config(((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityNameHead);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Tuple2[] tuple2Array = new Tuple2[1];
                Object object = Predef$.MODULE$.ArrowAssoc((Object)configResource);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)newConfig);
                Void cfr_ignored_1 = (Void)adminClient.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else {
                String string3 = this.BrokerLoggerConfigType();
                if (!(string3 != null ? !string3.equals(entityTypeHead) : entityTypeHead != null)) {
                    void $minus$greater$extension_$this;
                    Seq validLoggers = (Seq)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, true, false).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), Seq$.MODULE$.canBuildFrom());
                    Seq invalidBrokerLoggers = (Seq)((TraversableLike)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)))).$plus$plus((GenTraversableOnce)configsToBeAdded.keys().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem))), Seq$.MODULE$.canBuildFrom());
                    if (invalidBrokerLoggers.nonEmpty()) {
                        throw new InvalidConfigurationException(new StringBuilder(26).append("Invalid broker logger(s): ").append(invalidBrokerLoggers.mkString(",")).toString());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityNameHead);
                    AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                    Collection alterLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1 & Serializable & scala.Serializable)x$12 -> new AlterConfigOp(x$12, AlterConfigOp.OpType.SET), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
                    Tuple2[] tuple2Array = new Tuple2[1];
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)configResource);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)alterLogLevelEntries);
                    Void cfr_ignored_2 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
                } else {
                    boolean bl;
                    String string4 = ConfigType$.MODULE$.User();
                    if (!(string4 != null ? !string4.equals(entityTypeHead) : entityTypeHead != null)) {
                        bl = true;
                    } else {
                        String string5 = ConfigType$.MODULE$.Client();
                        bl = !(string5 != null ? !string5.equals(entityTypeHead) : entityTypeHead != null);
                    }
                    if (bl) {
                        boolean hasQuotaConfigsToAdd = configsToBeAdded.keys().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicConfig$QuotaConfigs$.MODULE$.isQuotaConfig(name)));
                        scala.collection.immutable.Map scramConfigsToAddMap = (scala.collection.immutable.Map)configsToBeAdded.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$15(entry)));
                        Iterable unknownConfigsToAdd = (Iterable)configsToBeAdded.keys().filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$16(key)));
                        boolean hasQuotaConfigsToDelete = configsToBeDeleted.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicConfig$QuotaConfigs$.MODULE$.isQuotaConfig(name)));
                        Seq scramConfigsToDelete = (Seq)configsToBeDeleted.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$18(x$1)));
                        Seq unknownConfigsToDelete = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$19(key)));
                        String string6 = entityTypeHead;
                        String string7 = ConfigType$.MODULE$.Client();
                        if (!(string6 == null ? string7 != null : !string6.equals(string7)) || entityTypes.size() == 2) {
                            if (unknownConfigsToAdd.nonEmpty() || scramConfigsToAddMap.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(90).append("Only quota configs can be added for '").append(ConfigType$.MODULE$.Client()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToAdd.$plus$plus((GenTraversableOnce)scramConfigsToAddMap.keys(), Iterable$.MODULE$.canBuildFrom())).toString());
                            }
                            if (unknownConfigsToDelete.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(92).append("Only quota configs can be deleted for '").append(ConfigType$.MODULE$.Client()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToDelete.$plus$plus((GenTraversableOnce)scramConfigsToDelete, Seq$.MODULE$.canBuildFrom())).toString());
                            }
                        } else {
                            if (unknownConfigsToAdd.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(111).append("Only quota and SCRAM credential configs can be added for '").append(ConfigType$.MODULE$.User()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToAdd).toString());
                            }
                            if (unknownConfigsToDelete.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(113).append("Only quota and SCRAM credential configs can be deleted for '").append(ConfigType$.MODULE$.User()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToDelete).toString());
                            }
                            if (scramConfigsToAddMap.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                                boolean bl2;
                                block34: {
                                    LinearSeqOptimized exists_these = entityNames;
                                    while (!exists_these.isEmpty()) {
                                        if (((String)exists_these.head()).isEmpty()) {
                                            bl2 = true;
                                            break block34;
                                        }
                                        exists_these = (LinearSeqOptimized)exists_these.tail();
                                    }
                                    bl2 = false;
                                }
                                if (bl2) {
                                    throw new IllegalArgumentException("The use of --entity-default or --user-defaults is not allowed with User SCRAM Credentials using --bootstrap-server.");
                                }
                                if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                                    throw new IllegalArgumentException(new StringBuilder(100).append("Cannot alter both quota and SCRAM credential configs simultaneously for '").append(ConfigType$.MODULE$.User()).append("' using --bootstrap-server.").toString());
                                }
                            }
                        }
                        if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                            this.alterQuotaConfigs(adminClient, entityTypes, (List<String>)entityNames, (Map<String, String>)configsToBeAddedMap, configsToBeDeleted);
                        } else {
                            if (entityNames.size() != 1) {
                                throw new IllegalStateException(new StringBuilder(84).append("Altering user SCRAM credentials should never occur for more zero or multiple users: ").append(entityNames).toString());
                            }
                            this.alterUserScramCredentialConfigs(adminClient, (String)entityNames.head(), (Map<String, ConfigEntry>)scramConfigsToAddMap, (Seq<String>)scramConfigsToDelete);
                        }
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported entity type: ").append(entityTypeHead).toString());
                    }
                }
            }
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (new StringOps(entityNameHead).nonEmpty()) {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Predef$.MODULE$.println((Object)new StringBuilder(32).append("Completed updating config for ").append(new StringOps(entityTypeHead).dropRight(1)).append(" ").append(entityNameHead).append(".").toString());
            return;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(54).append("Completed updating default config for ").append(entityTypeHead).append(" in the cluster.").toString());
    }

    private Void alterUserScramCredentialConfigs(Admin adminClient, String user, Map<String, ConfigEntry> scramConfigsToAddMap, Seq<String> scramConfigsToDelete) {
        Seq deletions = (Seq)scramConfigsToDelete.map((Function1 & Serializable & scala.Serializable)mechanismName -> new UserScramCredentialDeletion(user, ScramMechanism.fromMechanismName((String)mechanismName)), Seq$.MODULE$.canBuildFrom());
        Iterable upsertions = (Iterable)scramConfigsToAddMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            byte[] byArray;
            Integer n;
            String mechanismName;
            if (x0$1 != null) {
                mechanismName = (String)x0$1._1();
                ConfigEntry configEntry = (ConfigEntry)x0$1._2();
                Tuple2 tuple2 = this.iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism.forMechanismName((String)mechanismName), configEntry.value());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                n = (Integer)tuple2._1();
                byArray = (byte[])tuple2._2();
            } else {
                throw new MatchError(null);
            }
            Integer iterations = n;
            byte[] passwordBytes = byArray;
            UserScramCredentialUpsertion userScramCredentialUpsertion = new UserScramCredentialUpsertion(user, new ScramCredentialInfo(ScramMechanism.fromMechanismName((String)mechanismName), Predef$.MODULE$.Integer2int(iterations)), passwordBytes);
            return userScramCredentialUpsertion;
        }, Iterable$.MODULE$.canBuildFrom());
        return (Void)adminClient.alterUserScramCredentials((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)deletions.$plus$plus((GenTraversableOnce)upsertions, Seq$.MODULE$.canBuildFrom())).toList()).asJava()).all().get(60L, TimeUnit.SECONDS);
    }

    private Void alterQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames, Map<String, String> configsToBeAddedMap, Seq<String> configsToBeDeleted) {
        Map<String, Double> oldConfig = this.getClientQuotasConfig(adminClient, entityTypes, entityNames);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
        }
        List alterEntityTypes = (List)entityTypes.map((Function1 & Serializable & scala.Serializable)entType -> {
            String string;
            String string2 = ConfigType$.MODULE$.User();
            if (!(string2 != null ? !string2.equals(entType) : entType != null)) {
                string = "user";
            } else {
                String string3 = ConfigType$.MODULE$.Client();
                if (!(string3 != null ? !string3.equals(entType) : entType != null)) {
                    string = "client-id";
                } else {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected entity type: ").append((String)entType).toString());
                }
            }
            return string;
        }, List$.MODULE$.canBuildFrom());
        List alterEntityNames = (List)entityNames.map((Function1 & Serializable & scala.Serializable)en -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (new StringOps(en).nonEmpty()) {
                return en;
            }
            return null;
        }, List$.MODULE$.canBuildFrom());
        HashMap alterEntityMap = new HashMap();
        List list = (List)alterEntityTypes.zip((GenIterable)alterEntityNames, List$.MODULE$.canBuildFrom());
        if (list == null) {
            throw null;
        }
        List foreach_these = list;
        while (!foreach_these.isEmpty()) {
            Tuple2 tuple2 = (Tuple2)foreach_these.head();
            ConfigCommand$.$anonfun$alterQuotaConfigs$4(alterEntityMap, tuple2);
            foreach_these = (List)foreach_these.tail();
        }
        ClientQuotaEntity entity = new ClientQuotaEntity(alterEntityMap);
        AlterClientQuotasOptions alterOptions = new AlterClientQuotasOptions().validateOnly(false);
        Collection alterOps = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAddedMap.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            double d;
            String key;
            if (x0$2 != null) {
                key = (String)x0$2._1();
                String value = (String)x0$2._2();
                try {
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    d = new StringOps(value).toDouble();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Cannot parse quota configuration value for ").append(key).append(": ").append(value).toString());
                }
            } else {
                throw new MatchError(null);
            }
            double doubleValue = d;
            ClientQuotaAlteration.Op op = new ClientQuotaAlteration.Op(key, Predef$.MODULE$.double2Double(doubleValue));
            return op;
        }, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)key -> new ClientQuotaAlteration.Op(key, null), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
        return (Void)adminClient.alterClientQuotas(Collections.singleton(new ClientQuotaAlteration(entity, alterOps)), alterOptions).all().get(60L, TimeUnit.SECONDS);
    }

    public void describeConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        boolean bl;
        boolean bl2;
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        boolean describeAll = opts.options().has((OptionSpec)opts.allOpt());
        String string = (String)entityTypes.head();
        String string2 = ConfigType$.MODULE$.Topic();
        if (!(string2 != null ? !string2.equals(string) : string != null)) {
            bl2 = true;
        } else {
            String string3 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string) : string != null)) {
                bl2 = true;
            } else {
                String string4 = this.BrokerLoggerConfigType();
                bl2 = !(string4 != null ? !string4.equals(string) : string != null);
            }
        }
        if (bl2) {
            this.describeResourceConfig(adminClient, (String)entityTypes.head(), (Option<String>)entityNames.headOption(), describeAll);
            return;
        }
        String string5 = ConfigType$.MODULE$.User();
        if (!(string5 != null ? !string5.equals(string) : string != null)) {
            bl = true;
        } else {
            String string6 = ConfigType$.MODULE$.Client();
            bl = !(string6 != null ? !string6.equals(string) : string != null);
        }
        if (bl) {
            this.describeClientQuotaAndUserScramCredentialConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        throw new MatchError((Object)string);
    }

    private void describeResourceConfig(Admin adminClient, String entityType, Option<String> entityName, boolean describeAll) {
        if (entityName == null) {
            throw null;
        }
        Object object = entityName.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommand$.$anonfun$describeResourceConfig$1((String)entityName.get()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? ConfigCommand$.$anonfun$describeResourceConfig$2(entityType, adminClient) : object.get();
        ((Seq)object2).foreach((Function1 & Serializable & scala.Serializable)entity -> {
            ConfigCommand$.$anonfun$describeResourceConfig$4(entityType, describeAll, adminClient, entity);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<ConfigEntry> getResourceConfig(Admin adminClient, String entityType, String entityName, boolean includeSynonyms, boolean describeAll) {
        ConfigResource.Type type;
        Some some;
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            if (!entityName.isEmpty()) {
                Topic.validate((String)entityName);
            }
            some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG);
            type = ConfigResource.Type.TOPIC;
        } else {
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
                ConfigResource.Type type2;
                Some some2;
                String string3 = this.BrokerDefaultEntityName();
                if (!(string3 != null ? !string3.equals(entityName) : entityName != null)) {
                    some2 = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG);
                    type2 = ConfigResource.Type.BROKER;
                } else {
                    ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    some2 = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG);
                    type2 = ConfigResource.Type.BROKER;
                }
                some = some2;
                type = type2;
            } else {
                String string4 = this.BrokerLoggerConfigType();
                if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
                    if (!entityName.isEmpty()) {
                        ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    }
                    some = None$.MODULE$;
                    type = ConfigResource.Type.BROKER_LOGGER;
                } else {
                    throw new MatchError((Object)entityType);
                }
            }
        }
        ConfigResource.Type type3 = type;
        Option option = (Option)some;
        None$ configSourceFilter = describeAll ? None$.MODULE$ : option;
        ConfigResource configResource = new ConfigResource(type3, entityName);
        DescribeConfigsOptions describeOptions = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOptions).all().get(30L, TimeUnit.SECONDS);
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).filter(arg_0 -> ConfigCommand$.$anonfun$getResourceConfig$1$adapted((Option)configSourceFilter, arg_0))).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void describeClientQuotaAndUserScramCredentialConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        void forKeyValue$extension_foreachEntry$extension_f;
        void forKeyValue$extension_foreachEntry$extension_$this;
        void forKeyValue$extension_$this;
        void forKeyValue$extension_f;
        scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> quotaConfigs = this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(entity, entries) -> {
            ConfigCommand$.$anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(entity, entries);
            return BoxedUnit.UNIT;
        };
        Map<ClientQuotaEntity, java.util.Map<String, Double>> map = Implicits$.MODULE$.MapExtensionMethods(quotaConfigs);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        Function2 & Serializable & scala.Serializable intersect2 = (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1);
        Map map2 = package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this);
        if (MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        forKeyValue$extension_foreachEntry$extension_$this.foreach(arg_0 -> MapExtensionMethods$.$anonfun$foreachEntry$1((Function2)forKeyValue$extension_foreachEntry$extension_f, arg_0));
        if (!entityTypes.contains((Object)ConfigType$.MODULE$.Client()) && !entityNames.contains((Object)"")) {
            DescribeUserScramCredentialsResult result = adminClient.describeUserScramCredentials((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(entityNames).asJava());
            ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)result.users().get(30L, TimeUnit.SECONDS)).asScala()).foreach((Function1 & Serializable & scala.Serializable)user -> {
                ConfigCommand$.$anonfun$describeClientQuotaAndUserScramCredentialConfigs$4(result, user);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Map<String, Double> getClientQuotasConfig(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        if (entityTypes.size() != entityNames.size()) {
            throw new IllegalArgumentException("Exactly one entity name must be specified for every entity type");
        }
        Option option = this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames).headOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommand$.$anonfun$getClientQuotasConfig$1((Tuple2)map_this.get()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? Map$.MODULE$.empty() : object.get();
        return (Map)object2;
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> getAllClientQuotasConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        List components = (List)((List)((IterableLike)entityTypes.map((Function1 & Serializable & scala.Serializable)x$19 -> new Some(x$19), List$.MODULE$.canBuildFrom())).zipAll((GenIterable)entityNames.map((Function1 & Serializable & scala.Serializable)x$20 -> new Some(x$20), List$.MODULE$.canBuildFrom()), (Object)None$.MODULE$, (Object)None$.MODULE$, List$.MODULE$.canBuildFrom())).map(ConfigCommand$::$anonfun$getAllClientQuotasConfigs$3, List$.MODULE$.canBuildFrom());
        return (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)components).asJava()))).entities().get(30L, TimeUnit.SECONDS)).asScala();
    }

    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        String string;
        List<String> entityNames;
        List<String> entityTypes;
        block3: {
            block2: {
                entityTypes = opts.entityTypes();
                entityNames = opts.entityNames();
                Object object = entityTypes.head();
                String string2 = ConfigType$.MODULE$.User();
                if (!(object == null ? string2 != null : !object.equals(string2))) break block2;
                Object object2 = entityTypes.head();
                String string3 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string3) : string3 != null) break block3;
            }
            return this.parseClientQuotaEntity(opts, entityTypes, entityNames);
        }
        Option option = entityNames.headOption();
        Object object = option instanceof Some && "".equals(string = (String)((Some)option).value()) ? new Some((Object)ConfigEntityName$.MODULE$.Default()) : option;
        return new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)object), (Option<ConfigCommand.Entity>)None$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseClientQuotaEntity(ConfigCommand.ConfigCommandOptions opts, List<String> types, List<String> names) {
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.head();
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? types.reverse() : types;
        sortedNames = (reverse != false && names.length() == 2 ? names.reverse() : names).iterator();
        entities = (List)entityTypes.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseClientQuotaEntity$1(scala.collection.Iterator java.lang.String ), (Ljava/lang/String;)Lkafka/admin/ConfigCommand$Entity;)((Iterator)sortedNames), List$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public static final /* synthetic */ ZKClientConfig $anonfun$processCommandWithZk$1() {
        return new ZKClientConfig();
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigWithZk$1(String elem) {
        return MODULE$.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning().contains((Object)elem);
    }

    public static final /* synthetic */ String $anonfun$alterConfigWithZk$3(String errorMessage$1, String entityName$1, String info$1) {
        return new StringBuilder(26).append(errorMessage$1).append(" when broker ").append(entityName$1).append(" is running. ").append(info$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$alterConfigWithZk$2(KafkaZkClient zkClient$1, String errorMessage$1, String entityName$1, String info$1, int brokerId) {
        void require_requirement;
        boolean bl = zkClient$1.getBroker(brokerId).isEmpty();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$alterConfigWithZk$3(errorMessage$1, entityName$1, info$1)).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$alterConfigWithZk$4(String errorMessage$1, String info$1) {
        return new StringBuilder(47).append(errorMessage$1).append(" for default cluster if any broker is running. ").append(info$1).toString();
    }

    private final String scramCredential$1(org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism, String credentialStr) {
        int n;
        String string;
        String string2 = "(?:iterations=([0-9]*),)?password=(.*)";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Option option = new StringOps(string2).r().unapplySeq((CharSequence)credentialStr);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
            string = (String)((LinearSeqOptimized)option.get()).apply(1);
            if (iterations != null) {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                n = new StringOps(iterations).toInt();
            } else {
                n = this.DefaultScramIterations();
            }
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        int n2 = n;
        if (n2 < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append(n2).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism).toString());
        }
        return ScramCredentialUtils.credentialToString((ScramCredential)new ScramFormatter(mechanism).generateCredential(string, n2));
    }

    public static final /* synthetic */ Object $anonfun$preProcessScramCredentials$1(ConfigCommand$ $this, Properties configsToBeAdded$1, org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism) {
        String string = configsToBeAdded$1.getProperty(mechanism.mechanismName());
        Object object = string == null ? BoxedUnit.UNIT : configsToBeAdded$1.setProperty(mechanism.mechanismName(), $this.scramCredential$1(mechanism, string));
        return object;
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$3(String x$4) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(x$4).toInt();
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$5(String x$5) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(x$5).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$preProcessBrokerConfigs$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((String)x0$1._1()).startsWith("password.encoder.");
        return bl;
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$2(Properties passwordEncoderConfigs$1) {
        return new StringBuilder(101).append("Password encoder configs ").append(passwordEncoderConfigs$1.keySet()).append(" will be used for encrypting").append(" passwords, but will not be stored in ZooKeeper.").toString();
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$5(Set passwordConfigs$1) {
        return new StringBuilder(226).append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append(" must be specified to update ").append(passwordConfigs$1).append(".").append(" Other password encoder configs like cipher algorithm and iterations may also be specified").append(" to override the default encoding parameters. Password encoder configs will not be persisted").append(" in ZooKeeper.").toString();
    }

    public static final /* synthetic */ void $anonfun$describeConfigWithZk$1(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        Properties configs = adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
        if (!configs.isEmpty() || !describeAllUsers$1) {
            String string = "Configs for %s are %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$2(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ String $anonfun$parseConfigsToBeAdded$3() {
        return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$8(Tuple2 x$10) {
        return ((ConfigEntry)x$10._2()).value() == null;
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$15(Tuple2 entry) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)((String)entry._1()));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$16(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || DynamicConfig$QuotaConfigs$.MODULE$.isQuotaConfig(key);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$18(String x$1) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$19(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || DynamicConfig$QuotaConfigs$.MODULE$.isQuotaConfig(key);
    }

    private final Tuple2 iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism, String credentialStr) {
        int n;
        String string;
        String string2 = "(?:iterations=(\\-?[0-9]*),)?password=(.*)";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Option option = new StringOps(string2).r().unapplySeq((CharSequence)credentialStr);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
            string = (String)((LinearSeqOptimized)option.get()).apply(1);
            if (iterations != null && !iterations.equals("-1")) {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                n = new StringOps(iterations).toInt();
            } else {
                n = this.DefaultScramIterations();
            }
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        int n2 = n;
        if (n2 < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append(n2).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism.mechanismName()).toString());
        }
        return new Tuple2((Object)Predef$.MODULE$.int2Integer(n2), (Object)string.getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ String $anonfun$alterQuotaConfigs$4(HashMap alterEntityMap$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$1._1();
        String v = (String)x0$1._2();
        String string = alterEntityMap$1.put(k, v);
        return string;
    }

    public static final /* synthetic */ List $anonfun$describeResourceConfig$1(String name) {
        return new .colon.colon((Object)name, (List)Nil$.MODULE$);
    }

    public static final /* synthetic */ Seq $anonfun$describeResourceConfig$2(String entityType$1, Admin adminClient$1) {
        Seq seq;
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType$1) : entityType$1 != null)) {
            seq = ((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)adminClient$1.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).asScala()).toSeq();
        } else {
            boolean bl;
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityType$1) : entityType$1 != null)) {
                bl = true;
            } else {
                String string3 = MODULE$.BrokerLoggerConfigType();
                bl = !(string3 != null ? !string3.equals(entityType$1) : entityType$1 != null);
            }
            if (bl) {
                seq = (Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient$1.describeCluster(new DescribeClusterOptions()).nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.idString(), Iterable$.MODULE$.canBuildFrom())).toSeq().$colon$plus((Object)MODULE$.BrokerDefaultEntityName(), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)entityType$1);
            }
        }
        return seq;
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$5(ConfigEntry entry) {
        String synonyms = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(entry.synonyms()).asScala()).map((Function1 & Serializable & scala.Serializable)synonym -> new StringBuilder(2).append(synonym.source()).append(":").append(synonym.name()).append("=").append(synonym.value()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("  ").append(entry.name()).append("=").append(entry.value()).append(" sensitive=").append(entry.isSensitive()).append(" synonyms={").append(synonyms).append("}").toString());
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$4(String entityType$1, boolean describeAll$1, Admin adminClient$1, String entity) {
        String string = MODULE$.BrokerDefaultEntityName();
        if (!(string != null ? !string.equals(entity) : entity != null)) {
            Predef$.MODULE$.println((Object)new StringBuilder(40).append("Default configs for ").append(entityType$1).append(" in the cluster are:").toString());
        } else {
            String configSourceStr;
            String string2 = configSourceStr = describeAll$1 ? "All" : "Dynamic";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Predef$.MODULE$.println((Object)new StringBuilder(19).append(configSourceStr).append(" configs for ").append(new StringOps(entityType$1).dropRight(1)).append(" ").append(entity).append(" are:").toString());
        }
        MODULE$.getResourceConfig(adminClient$1, entityType$1, entity, true, describeAll$1).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ConfigCommand$.$anonfun$describeResourceConfig$5(entry);
            return BoxedUnit.UNIT;
        });
    }

    private static final void validateBrokerId$1(String entityName$2, String entityType$2) {
        try {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            new StringOps(entityName$2).toInt();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(63).append("The entity name for ").append(entityType$2).append(" must be a valid integer broker id, found: ").append(entityName$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getResourceConfig$1(Option configSourceFilter$1, ConfigEntry entry) {
        boolean bl;
        if (configSourceFilter$1 instanceof Some) {
            ConfigEntry.ConfigSource configSource = (ConfigEntry.ConfigSource)((Some)configSourceFilter$1).value();
            ConfigEntry.ConfigSource configSource2 = entry.source();
            bl = !(configSource2 != null ? !configSource2.equals(configSource) : configSource != null);
        } else if (None$.MODULE$.equals(configSourceFilter$1)) {
            bl = true;
        } else {
            throw new MatchError((Object)configSourceFilter$1);
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$describeClientQuotaAndUserScramCredentialConfigs$2(String entityType$3, String name) {
        String string;
        if ("user".equals(entityType$3)) {
            string = "user-principal";
        } else if ("client-id".equals(entityType$3)) {
            string = "client-id";
        } else {
            throw new MatchError((Object)entityType$3);
        }
        if (name != null) {
            return new StringBuilder(3).append(string).append(" '").append(name).append("'").toString();
        }
        return new StringBuilder(12).append("the default ").append(string).toString();
    }

    private static final Option entitySubstr$1(String entityType, scala.collection.mutable.Map entityEntries$1) {
        None$ none$;
        Option option = entityEntries$1.get((Object)entityType);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string = (String)map_this.get();
            none$ = new Some((Object)ConfigCommand$.$anonfun$describeClientQuotaAndUserScramCredentialConfigs$2(entityType, string));
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(ClientQuotaEntity entity, java.util.Map entries) {
        scala.collection.mutable.Map entityEntries = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entity.entries()).asScala();
        String entityStr = ((TraversableOnce)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("user", entityEntries)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("client-id", entityEntries)), Iterable$.MODULE$.canBuildFrom())).mkString(", ");
        String entriesStr = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entries).asScala()).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(1).append(e._1()).append("=").append(e._2()).toString(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(", ");
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Quota configs for ").append(entityStr).append(" are ").append(entriesStr).toString());
    }

    public static final /* synthetic */ void $anonfun$describeClientQuotaAndUserScramCredentialConfigs$4(DescribeUserScramCredentialsResult result$1, String user) {
        try {
            UserScramCredentialsDescription description = (UserScramCredentialsDescription)result$1.description(user).get(30L, TimeUnit.SECONDS);
            String descriptionText = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(description.credentialInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)info -> new StringBuilder(12).append(info.mechanism().mechanismName()).append("=iterations=").append(info.iterations()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
            Predef$.MODULE$.println((Object)new StringBuilder(51).append("SCRAM credential configs for user-principal '").append(user).append("' are ").append(descriptionText).toString());
            return;
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(67).append("Error retrieving SCRAM credential configs for user-principal '").append(user).append("': ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage()).toString());
            return;
        }
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$getClientQuotasConfig$1(Tuple2 x$18) {
        return (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)x$18._2()).asScala();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ClientQuotaFilterComponent $anonfun$getAllClientQuotasConfigs$3(Tuple2 x0$1) {
        block11: {
            block10: {
                if (x0$1 == null) ** GOTO lbl44
                entityTypeOpt = (Option)x0$1._1();
                entityNameOpt = (Option)x0$1._2();
                var5_3 = false;
                var6_4 = null;
                if (!(entityTypeOpt instanceof Some)) break block10;
                var5_3 = true;
                var6_4 = (Some)entityTypeOpt;
                var7_5 = (String)var6_4.value();
                v0 = ConfigType$.MODULE$.User();
                if (v0 != null ? v0.equals(var7_5) == false : var7_5 != null) break block10;
                var2_6 = "user";
                break block11;
            }
            if (!var5_3) ** GOTO lbl-1000
            var8_7 = (String)var6_4.value();
            v1 = ConfigType$.MODULE$.Client();
            if (!(v1 != null ? v1.equals(var8_7) == false : var8_7 != null)) {
                var2_6 = "client-id";
            } else lbl-1000:
            // 2 sources

            {
                if (var5_3) {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected entity type ").append(entityTypeOpt.get()).toString());
                }
                if (None$.MODULE$.equals(entityTypeOpt)) {
                    throw new IllegalArgumentException("More entity names specified than entity types");
                }
                throw new MatchError((Object)entityTypeOpt);
            }
        }
        var9_8 = false;
        var10_9 = null;
        if (!(entityNameOpt instanceof Some)) ** GOTO lbl-1000
        var9_8 = true;
        var10_9 = (Some)entityNameOpt;
        var11_10 = (String)var10_9.value();
        if ("".equals(var11_10)) {
            var1_11 = ClientQuotaFilterComponent.ofDefaultEntity((String)var2_6);
        } else if (var9_8) {
            name = (String)var10_9.value();
            var1_11 = ClientQuotaFilterComponent.ofEntity((String)var2_6, (String)name);
        } else if (None$.MODULE$.equals(entityNameOpt)) {
            var1_11 = ClientQuotaFilterComponent.ofEntityType((String)var2_6);
        } else {
            throw new MatchError((Object)entityNameOpt);
lbl44:
            // 1 sources

            throw new MatchError(null);
        }
        return var1_11;
    }

    private static final String sanitizeName$1(String entityType, String name) {
        boolean bl;
        if (name.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        String string = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            bl = true;
        } else {
            String string2 = ConfigType$.MODULE$.Client();
            bl = !(string2 != null ? !string2.equals(entityType) : entityType != null);
        }
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Invalid entity type ").append(entityType).toString());
        }
        String string3 = Sanitizer.sanitize((String)name);
        return string3;
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseClientQuotaEntity$1(Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        kafka.common.Config.$init$(this);
        this.BrokerDefaultEntityName = "";
        this.BrokerLoggerConfigType = "broker-loggers";
        this.BrokerSupportedConfigTypes = (Seq)ConfigType$.MODULE$.all().$colon$plus((Object)this.BrokerLoggerConfigType(), Seq$.MODULE$.canBuildFrom());
        this.ZkSupportedConfigTypes = ConfigType$.MODULE$.all();
        this.DefaultScramIterations = 4096;
        this.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()}));
    }

    public static final /* synthetic */ Object $anonfun$createPasswordEncoder$3$adapted(String x$4) {
        return BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$3(x$4));
    }

    public static final /* synthetic */ Object $anonfun$createPasswordEncoder$5$adapted(String x$5) {
        return BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$5(x$5));
    }

    public static final /* synthetic */ Object $anonfun$describeConfigWithZk$1$adapted(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        ConfigCommand$.$anonfun$describeConfigWithZk$1(adminZkClient$1, describeAllUsers$1, entity);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$alterConfig$20$adapted(String x$13) {
        return BoxesRunTime.boxToBoolean((boolean)x$13.isEmpty());
    }

    public static final /* synthetic */ Object $anonfun$getResourceConfig$1$adapted(Option configSourceFilter$1, ConfigEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$getResourceConfig$1(configSourceFilter$1, entry));
    }
}

