/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.inlong.manager.common.plugin.Plugin;
import org.apache.inlong.manager.common.plugin.PluginBinder;
import org.apache.inlong.manager.service.listener.queue.ClusterConfigListener;
import org.apache.inlong.manager.service.listener.queue.ClusterQueueResourceListener;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.event.task.ClusterOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusterTaskListenerFactory
implements PluginBinder,
TaskListenerFactory {
    private List<ClusterOperateListener> clusterOperateListeners;
    @Autowired
    private ClusterQueueResourceListener clusterQueueResourceListener;
    @Autowired
    private ClusterConfigListener clusterConfigListener;

    @PostConstruct
    public void init() {
        this.clusterOperateListeners = new LinkedList<ClusterOperateListener>();
        this.clusterOperateListeners.add(this.clusterQueueResourceListener);
        this.clusterOperateListeners.add(this.clusterConfigListener);
    }

    public void acceptPlugin(Plugin plugin) {
    }

    public List<? extends TaskEventListener> get(WorkflowContext workflowContext, ServiceTaskType taskType) {
        switch (taskType) {
            case INIT_MQ: {
                List<ClusterOperateListener> clusterOperateListeners = this.getQueueOperateListener(workflowContext);
                return Lists.newArrayList(clusterOperateListeners);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported ServiceTaskType %s", taskType));
    }

    public void clearListeners() {
        this.clusterOperateListeners = new LinkedList<ClusterOperateListener>();
    }

    public List<ClusterOperateListener> getQueueOperateListener(WorkflowContext context) {
        ArrayList<ClusterOperateListener> listeners = new ArrayList<ClusterOperateListener>();
        for (ClusterOperateListener listener : this.clusterOperateListeners) {
            if (listener == null || !listener.accept(context)) continue;
            listeners.add(listener);
        }
        return listeners;
    }
}

