/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group;

import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitGroupListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(InitGroupListener.class);
    @Autowired
    private InlongGroupService groupService;

    public ProcessEvent event() {
        return ProcessEvent.CREATE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to execute InitGroupListener for groupId={}", (Object)groupId);
        InlongGroupInfo groupInfo = form.getGroupInfo();
        if (groupInfo == null) {
            throw new WorkflowListenerException("inlong group info cannot be null for init group process");
        }
        this.groupService.updateStatus(groupId, GroupStatus.CONFIG_ING.getCode(), context.getOperator());
        log.info("success to execute InitGroupListener for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }
}

