/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.transform;

import com.github.pagehelper.PageHelper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.StreamTransformEntity;
import org.apache.inlong.manager.dao.entity.StreamTransformFieldEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamTransformEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamTransformFieldEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.transform.DeleteTransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformPageRequest;
import org.apache.inlong.manager.pojo.transform.TransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.group.GroupCheckService;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.transform.StreamTransformService;
import org.apache.inlong.manager.service.transform.TransformSqlParser;
import org.apache.inlong.manager.service.user.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StreamTransformServiceImpl
implements StreamTransformService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamTransformServiceImpl.class);
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    protected StreamTransformEntityMapper transformMapper;
    @Autowired
    protected StreamTransformFieldEntityMapper transformFieldMapper;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldEntityMapper;
    @Autowired
    protected GroupCheckService groupCheckService;
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    protected UserService userService;

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public Integer save(TransformRequest request, String operator) {
        LOGGER.info("begin to save transform info: {}", (Object)request);
        this.checkParams(request);
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String transformName = request.getTransformName();
        this.groupCheckService.checkGroupStatus(groupId, operator);
        List transformEntities = this.transformMapper.selectByRelatedId(groupId, streamId, transformName);
        if (CollectionUtils.isNotEmpty((Collection)transformEntities)) {
            String err = "stream transform already exists with groupId=%s, streamId=%s, transformName=%s";
            throw new BusinessException(String.format(err, groupId, streamId, transformName));
        }
        StreamTransformEntity transformEntity = (StreamTransformEntity)CommonBeanUtils.copyProperties((Object)request, StreamTransformEntity::new);
        transformEntity.setCreator(operator);
        transformEntity.setModifier(operator);
        this.transformMapper.insert(transformEntity);
        this.saveFieldOpt(transformEntity, request.getFieldList());
        this.saveTransformSql(request, operator);
        return transformEntity.getId();
    }

    @Override
    public PageResult<TransformResponse> listByCondition(TransformPageRequest request, UserInfo opInfo) {
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        LOGGER.debug("begin to fetch transform info by groupId={} and streamId={} ", (Object)groupId, (Object)streamId);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        if (groupEntity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND, String.format("InlongGroup does not exist with InlongGroupId=%s", groupId));
        }
        List entityList = this.transformMapper.selectByCondition(request);
        List<Object> responses = Collections.emptyList();
        if (!CollectionUtils.isEmpty((Collection)entityList)) {
            responses = this.getTransformResponse(entityList);
        }
        return new PageResult(responses, Long.valueOf(responses.size()), Integer.valueOf(request.getPageNum()), Integer.valueOf(request.getPageSize()));
    }

    @Override
    public TransformResponse get(Integer id, UserInfo opInfo) {
        StreamTransformEntity entity = this.transformMapper.selectById(id);
        List fieldEntities = this.transformFieldMapper.selectByTransformId(id);
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.TRANSFORM_NOT_FOUND, String.format("transform not found by id=%s", id));
        }
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(entity.getInlongGroupId());
        if (groupEntity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND, String.format("InlongGroup does not exist with InlongGroupId=%s", entity.getInlongGroupId()));
        }
        Map fieldInfoMap = fieldEntities.stream().map(transformFieldEntity -> {
            StreamField fieldInfo = (StreamField)CommonBeanUtils.copyProperties((Object)transformFieldEntity, StreamField::new);
            fieldInfo.setFieldType(transformFieldEntity.getFieldType());
            fieldInfo.setId(transformFieldEntity.getRankNum());
            return Pair.of((Object)transformFieldEntity.getTransformId(), (Object)fieldInfo);
        }).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        TransformResponse transformResponse = (TransformResponse)CommonBeanUtils.copyProperties((Object)entity, TransformResponse::new);
        transformResponse.setFieldList(fieldInfoMap.get(id));
        return transformResponse;
    }

    @Override
    public List<TransformResponse> listTransform(String groupId, String streamId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        List entityList = this.transformMapper.selectByRelatedId(groupId, streamId, null);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Collections.emptyList();
        }
        return this.getTransformResponse(entityList);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean update(TransformRequest request, String operator) {
        LOGGER.info("begin to update transform info: {}", (Object)request);
        this.chkUnmodifiableParams(request);
        String groupId = request.getInlongGroupId();
        this.groupCheckService.checkGroupStatus(groupId, operator);
        Preconditions.expectNotNull((Object)request.getId(), (String)ErrorCodeEnum.ID_IS_EMPTY.getMessage());
        StreamTransformEntity transformEntity = (StreamTransformEntity)CommonBeanUtils.copyProperties((Object)request, StreamTransformEntity::new);
        transformEntity.setModifier(operator);
        int rowCount = this.transformMapper.updateByIdSelective(transformEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            String msg = String.format("transform has already updated with groupId=%s, streamId=%s, name=%s, curVersion=%s", request.getInlongGroupId(), request.getInlongStreamId(), request.getTransformName(), request.getVersion());
            LOGGER.error(msg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.updateFieldOpt(transformEntity, request.getFieldList());
        this.saveTransformSql(request, operator);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean delete(DeleteTransformRequest request, String operator) {
        LOGGER.info("begin to logic delete transform for request={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"delete request of transform cannot be null");
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        this.groupCheckService.checkGroupStatus(groupId, operator);
        List entityList = this.transformMapper.selectByRelatedId(groupId, streamId, request.getTransformName());
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (StreamTransformEntity entity : entityList) {
                Integer id = entity.getId();
                entity.setIsDeleted(id);
                entity.setModifier(operator);
                int rowCount = this.transformMapper.updateByIdSelective(entity);
                if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
                    LOGGER.error("transform has already updated with groupId={}, streamId={}, name={}, curVersion={}", new Object[]{entity.getInlongGroupId(), entity.getInlongStreamId(), entity.getTransformName(), entity.getVersion()});
                    throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
                }
                this.transformFieldMapper.deleteAll(id);
            }
        }
        LOGGER.info("success to logic delete transform for request={} by user={}", (Object)request, (Object)operator);
        return true;
    }

    private List<TransformResponse> getTransformResponse(List<StreamTransformEntity> entityList) {
        List transformIds = entityList.stream().map(StreamTransformEntity::getId).collect(Collectors.toList());
        List fieldEntities = this.transformFieldMapper.selectByTransformIds(transformIds);
        Map fieldInfoMap = fieldEntities.stream().map(transformFieldEntity -> {
            StreamField fieldInfo = (StreamField)CommonBeanUtils.copyProperties((Object)transformFieldEntity, StreamField::new);
            fieldInfo.setFieldType(transformFieldEntity.getFieldType());
            fieldInfo.setId(transformFieldEntity.getRankNum());
            return Pair.of((Object)transformFieldEntity.getTransformId(), (Object)fieldInfo);
        }).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        List<TransformResponse> transformResponses = entityList.stream().map(entity -> (TransformResponse)CommonBeanUtils.copyProperties((Object)entity, TransformResponse::new)).collect(Collectors.toList());
        transformResponses.forEach(transformResponse -> {
            int transformId = transformResponse.getId();
            List fieldInfos = (List)fieldInfoMap.get(transformId);
            if (CollectionUtils.isNotEmpty((Collection)fieldInfos)) {
                transformResponse.setFieldList(fieldInfos);
            }
        });
        return transformResponses;
    }

    private void checkParams(TransformRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        String groupId = request.getInlongGroupId();
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        String streamId = request.getInlongStreamId();
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        String transformType = request.getTransformType();
        Preconditions.expectNotBlank((String)transformType, (ErrorCodeEnum)ErrorCodeEnum.TRANSFORM_TYPE_IS_NULL);
        String transformName = request.getTransformName();
        Preconditions.expectNotBlank((String)transformName, (ErrorCodeEnum)ErrorCodeEnum.TRANSFORM_NAME_IS_NULL);
    }

    private void chkUnmodifiableParams(TransformRequest request) {
        StreamTransformEntity entity = this.transformMapper.selectById(request.getId());
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.TRANSFORM_NOT_FOUND);
        }
        Preconditions.expectEquals((Object)entity.getVersion(), (Object)request.getVersion(), (ErrorCodeEnum)ErrorCodeEnum.CONFIG_EXPIRED, (String)String.format("record has expired with record version=%d, request version=%d", entity.getVersion(), request.getVersion()));
        if (StringUtils.isNotBlank((CharSequence)request.getInlongGroupId()) && !entity.getInlongGroupId().equals(request.getInlongGroupId())) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "inlongGroupId not allowed modify");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getInlongStreamId()) && !entity.getInlongStreamId().equals(request.getInlongStreamId())) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "inlongStreamId not allowed modify");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTransformType()) && !entity.getTransformType().equals(request.getTransformType())) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "transformType not allowed modify");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTransformName()) && !entity.getTransformName().equals(request.getTransformName())) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "transformName not allowed modify");
        }
        request.setInlongGroupId(entity.getInlongGroupId());
        request.setInlongStreamId(entity.getInlongStreamId());
        request.setTransformType(entity.getTransformType());
        request.setTransformName(entity.getTransformName());
    }

    private void updateFieldOpt(StreamTransformEntity entity, List<StreamField> fieldList) {
        Integer transformId = entity.getId();
        if (CollectionUtils.isEmpty(fieldList)) {
            return;
        }
        this.transformFieldMapper.deleteAll(transformId);
        this.saveFieldOpt(entity, fieldList);
        LOGGER.debug("success to update transform field");
    }

    private void saveFieldOpt(StreamTransformEntity entity, List<StreamField> fieldList) {
        LOGGER.debug("begin to save transform field={}", fieldList);
        if (CollectionUtils.isEmpty(fieldList)) {
            return;
        }
        int size = fieldList.size();
        ArrayList<StreamTransformFieldEntity> entityList = new ArrayList<StreamTransformFieldEntity>(size);
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        String transformType = entity.getTransformType();
        Integer transformId = entity.getId();
        for (StreamField fieldInfo : fieldList) {
            StreamTransformFieldEntity fieldEntity = (StreamTransformFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StreamTransformFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            fieldEntity.setId(null);
            fieldEntity.setInlongGroupId(groupId);
            fieldEntity.setInlongStreamId(streamId);
            fieldEntity.setFieldType(fieldInfo.getFieldType());
            fieldEntity.setRankNum(fieldInfo.getId());
            fieldEntity.setTransformId(transformId);
            fieldEntity.setTransformType(transformType);
            fieldEntity.setIsDeleted(InlongConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.transformFieldMapper.insertAll(entityList);
        LOGGER.debug("success to save transform fields");
    }

    @Override
    public String getTransformSql(StreamSink sink) {
        List<TransformResponse> transformResponseList = this.listTransform(sink.getInlongGroupId(), sink.getInlongStreamId());
        List<TransformResponse> filterList = transformResponseList.stream().filter(v -> {
            HashSet postNodes = Sets.newHashSet((Object[])v.getPostNodeNames().split(","));
            return postNodes.contains(sink.getSinkName());
        }).collect(Collectors.toList());
        List sinkFieldEntityList = this.sinkFieldEntityMapper.selectBySinkId(sink.getId());
        return TransformSqlParser.parse(filterList, CommonBeanUtils.copyListProperties((List)sinkFieldEntityList, SinkField::new));
    }

    @Override
    public String parseTransformSql(TransformRequest request, String operator) {
        List sinkFields = CommonBeanUtils.copyListProperties((List)request.getFieldList(), SinkField::new);
        sinkFields.forEach(v -> v.setSourceFieldName(v.getOriginFieldName()));
        List<Object> filterList = Collections.singletonList(CommonBeanUtils.copyProperties((Object)request, TransformResponse::new));
        return TransformSqlParser.parse(filterList, CommonBeanUtils.copyListProperties((List)sinkFields, SinkField::new));
    }

    private void saveTransformSql(TransformRequest request, String operator) {
        LOGGER.info("begin to save transform sql: {}", (Object)request);
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        if (InlongConstants.STANDARD_MODE.equals(groupEntity.getInlongGroupMode())) {
            HashSet postNodes = Sets.newHashSet((Object[])request.getPostNodeNames().split(","));
            List<StreamSink> sinkList = this.sinkService.listSink(groupId, streamId);
            sinkList.stream().filter(v -> postNodes.contains(v.getSinkName())).forEach(v -> {
                SinkRequest sinkRequest = v.genSinkRequest();
                sinkRequest.setTransformSql(this.getTransformSql((StreamSink)v));
                this.sinkService.update(sinkRequest, operator);
            });
        }
    }
}

