/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ResolvedSchema {
    private final List<Column> columns;
    private final List<WatermarkSpec> watermarkSpecs;
    @Nullable
    private final UniqueConstraint primaryKey;

    public ResolvedSchema(List<Column> columns, List<WatermarkSpec> watermarkSpecs, @Nullable UniqueConstraint primaryKey) {
        this.columns = (List)Preconditions.checkNotNull(columns, (String)"Columns must not be null.");
        this.watermarkSpecs = (List)Preconditions.checkNotNull(watermarkSpecs, (String)"Watermark specs must not be null.");
        this.primaryKey = primaryKey;
    }

    public static ResolvedSchema of(List<Column> columns) {
        return new ResolvedSchema(columns, Collections.emptyList(), null);
    }

    public static ResolvedSchema of(Column ... columns) {
        return ResolvedSchema.of(Arrays.asList(columns));
    }

    public static ResolvedSchema physical(List<String> columnNames, List<DataType> columnDataTypes) {
        Preconditions.checkArgument((columnNames.size() == columnDataTypes.size() ? 1 : 0) != 0, (Object)"Mismatch between number of columns names and data types.");
        List<Column> columns = IntStream.range(0, columnNames.size()).mapToObj(i -> Column.physical((String)columnNames.get(i), (DataType)columnDataTypes.get(i))).collect(Collectors.toList());
        return new ResolvedSchema(columns, Collections.emptyList(), null);
    }

    public static ResolvedSchema physical(String[] columnNames, DataType[] columnDataTypes) {
        return ResolvedSchema.physical(Arrays.asList(columnNames), Arrays.asList(columnDataTypes));
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<String> getColumnNames() {
        return this.columns.stream().map(Column::getName).collect(Collectors.toList());
    }

    public List<DataType> getColumnDataTypes() {
        return this.columns.stream().map(Column::getDataType).collect(Collectors.toList());
    }

    public Optional<Column> getColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            return Optional.empty();
        }
        return Optional.of(this.columns.get(columnIndex));
    }

    public Optional<Column> getColumn(String columnName) {
        return this.columns.stream().filter(column -> column.getName().equals(columnName)).findFirst();
    }

    public List<WatermarkSpec> getWatermarkSpecs() {
        return this.watermarkSpecs;
    }

    public Optional<UniqueConstraint> getPrimaryKey() {
        return Optional.ofNullable(this.primaryKey);
    }

    public int[] getPrimaryKeyIndexes() {
        List<String> columns = this.getColumnNames();
        return this.getPrimaryKey().map(UniqueConstraint::getColumns).map(pkColumns -> pkColumns.stream().mapToInt(columns::indexOf).toArray()).orElseGet(() -> new int[0]);
    }

    public DataType toSourceRowDataType() {
        return this.toRowDataType(c -> true);
    }

    public DataType toPhysicalRowDataType() {
        return this.toRowDataType(Column::isPhysical);
    }

    public DataType toSinkRowDataType() {
        return this.toRowDataType(Column::isPersisted);
    }

    public String toString() {
        ArrayList<Object> components = new ArrayList<Object>();
        components.addAll(this.columns);
        components.addAll(this.watermarkSpecs);
        if (this.primaryKey != null) {
            components.add(this.primaryKey);
        }
        return components.stream().map(Objects::toString).map(s -> "  " + s).collect(Collectors.joining(",\n", "(\n", "\n)"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedSchema that = (ResolvedSchema)o;
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.watermarkSpecs, that.watermarkSpecs) && Objects.equals(this.primaryKey, that.primaryKey);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.watermarkSpecs, this.primaryKey);
    }

    private DataType toRowDataType(Predicate<Column> columnPredicate) {
        return (DataType)this.columns.stream().filter(columnPredicate).map(ResolvedSchema::columnToField).collect(Collectors.collectingAndThen(Collectors.toList(), DataTypes::ROW)).notNull();
    }

    private static DataTypes.Field columnToField(Column column) {
        return DataTypes.FIELD(column.getName(), DataTypeUtils.removeTimeAttribute(column.getDataType()));
    }
}

