/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;

public class ConnectionUtils {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 10000;
    private static final String DEFAULT_HTTP_METHOD = "GET";
    private static ConnectionUtils instance;

    public static ConnectionUtils getInstance() {
        if (null == instance) {
            instance = new ConnectionUtils();
        }
        return instance;
    }

    private ConnectionUtils() {
    }

    public HttpURLConnection connectToEndpoint(URI endpoint, Map<String, String> headers) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)endpoint.toURL().openConnection(Proxy.NO_PROXY);
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(10000);
        connection.setRequestMethod(DEFAULT_HTTP_METHOD);
        connection.setDoOutput(true);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.addRequestProperty(header.getKey(), header.getValue());
        }
        connection.connect();
        return connection;
    }
}

