/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveDatabase;

public class SqlAlterHiveDatabaseOwner
extends SqlAlterHiveDatabase {
    public static final String DATABASE_OWNER_NAME = "hive.database.owner.name";
    public static final String DATABASE_OWNER_TYPE = "hive.database.owner.type";
    public static final String USER_OWNER = "user";
    public static final String ROLE_OWNER = "role";
    private final String ownerType;
    private final SqlIdentifier ownerName;

    public SqlAlterHiveDatabaseOwner(SqlParserPos pos, SqlIdentifier databaseName, String ownerType, SqlIdentifier ownerName) {
        super(pos, databaseName, new SqlNodeList(pos));
        SqlParserPos ownerPos = ownerName.getParserPosition();
        this.getPropertyList().add(new SqlTableOption(SqlLiteral.createCharString(DATABASE_OWNER_TYPE, ownerPos), SqlLiteral.createCharString(ownerType, ownerPos), ownerPos));
        this.getPropertyList().add(new SqlTableOption(SqlLiteral.createCharString(DATABASE_OWNER_NAME, ownerPos), SqlLiteral.createCharString(ownerName.getSimple(), ownerPos), ownerPos));
        this.ownerName = ownerName;
        this.ownerType = ownerType;
    }

    @Override
    protected SqlAlterHiveDatabase.AlterHiveDatabaseOp getAlterOp() {
        return SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_OWNER;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("OWNER");
        if (this.ownerType.equalsIgnoreCase(USER_OWNER)) {
            writer.keyword("USER");
        } else {
            writer.keyword("ROLE");
        }
        this.ownerName.unparse(writer, leftPrec, rightPrec);
    }
}

