/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;

public class SqlAlterHiveTableFileFormat
extends SqlAlterHiveTable {
    private final SqlIdentifier format;

    public SqlAlterHiveTableFileFormat(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList partSpec, SqlIdentifier format) {
        super(SqlAlterHiveTable.AlterTableOp.CHANGE_FILE_FORMAT, pos, tableName, partSpec, SqlAlterHiveTableFileFormat.createPropList(format));
        this.format = format;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET FILEFORMAT");
        this.format.unparse(writer, leftPrec, rightPrec);
    }

    private static SqlNodeList createPropList(SqlIdentifier format) {
        SqlNodeList res = new SqlNodeList(format.getParserPosition());
        res.add(HiveDDLUtils.toTableOption("hive.storage.file-format", format.getSimple(), format.getParserPosition()));
        return res;
    }
}

