/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl$;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class SortUtil$ {
    public static SortUtil$ MODULE$;

    static {
        new SortUtil$();
    }

    public long getLimitStart(RexNode offset) {
        return offset != null ? (long)RexLiteral.intValue(offset) : 0L;
    }

    public long getLimitEnd(RexNode offset, RexNode fetch) {
        return fetch != null ? this.getLimitStart(offset) + (long)RexLiteral.intValue(fetch) : Long.MAX_VALUE;
    }

    public RelFieldCollation.Direction getFirstSortDirection(RelCollation collationSort) {
        return collationSort.getFieldCollations().get((int)0).direction;
    }

    public RelDataTypeField getFirstSortField(RelCollation collationSort, RelDataType rowType) {
        int idx = collationSort.getFieldCollations().get(0).getFieldIndex();
        return rowType.getFieldList().get(idx);
    }

    public boolean[] getNullDefaultOrders(boolean[] ascendings) {
        return (boolean[])new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(ascendings)).map((Function1 & Serializable & scala.Serializable)asc -> BoxesRunTime.boxToBoolean((boolean)SortUtil$.$anonfun$getNullDefaultOrders$1(BoxesRunTime.unboxToBoolean((Object)asc))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
    }

    public boolean getNullDefaultOrder(boolean ascending) {
        return FlinkPlannerImpl$.MODULE$.defaultNullCollation().last(!ascending);
    }

    public SortSpec getSortSpec(Seq<RelFieldCollation> fieldCollations) {
        Seq fieldMappingDirections = (Seq)fieldCollations.map((Function1 & Serializable & scala.Serializable)c -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()), (Object)MODULE$.directionToOrder(c.getDirection())), Seq$.MODULE$.canBuildFrom());
        Seq keys = (Seq)fieldMappingDirections.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), Seq$.MODULE$.canBuildFrom());
        Seq orders = (Seq)fieldMappingDirections.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SortUtil$.$anonfun$getSortSpec$3(x$2)), Seq$.MODULE$.canBuildFrom());
        boolean[] nullsIsLast = (boolean[])((TraversableOnce)((TraversableLike)fieldCollations.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.nullDirection, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SortUtil$.$anonfun$getSortSpec$5(x0$1)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
        return this.deduplicateSortKeys((int[])keys.toArray(ClassTag$.MODULE$.Int()), (boolean[])orders.toArray(ClassTag$.MODULE$.Boolean()), nullsIsLast);
    }

    public SortSpec getAscendingSortSpec(int[] fields) {
        boolean[] originalOrders = (boolean[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(fields)).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> true, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
        boolean[] nullsIsLast = this.getNullDefaultOrders(originalOrders);
        return this.deduplicateSortKeys(fields, originalOrders, nullsIsLast);
    }

    private SortSpec deduplicateSortKeys(int[] keys, boolean[] orders, boolean[] nullsIsLast) {
        SortSpec.SortSpecBuilder builder = SortSpec.builder();
        HashSet keySet = new HashSet();
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).indices().foreach((Function1 & Serializable & scala.Serializable)i -> SortUtil$.$anonfun$deduplicateSortKeys$1(keys, orders, nullsIsLast, builder, keySet, BoxesRunTime.unboxToInt((Object)i)));
        return builder.build();
    }

    public Order directionToOrder(RelFieldCollation.Direction direction) {
        Order order;
        RelFieldCollation.Direction direction2 = direction;
        boolean bl = ((Object)((Object)RelFieldCollation.Direction.ASCENDING)).equals((Object)direction2) ? true : ((Object)((Object)RelFieldCollation.Direction.STRICTLY_ASCENDING)).equals((Object)direction2);
        if (bl) {
            order = Order.ASCENDING;
        } else {
            boolean bl2 = ((Object)((Object)RelFieldCollation.Direction.DESCENDING)).equals((Object)direction2) ? true : ((Object)((Object)RelFieldCollation.Direction.STRICTLY_DESCENDING)).equals((Object)direction2);
            if (bl2) {
                order = Order.DESCENDING;
            } else {
                throw new IllegalArgumentException("Unsupported direction.");
            }
        }
        return order;
    }

    public static final /* synthetic */ boolean $anonfun$getNullDefaultOrders$1(boolean asc) {
        return FlinkPlannerImpl$.MODULE$.defaultNullCollation().last(!asc);
    }

    public static final /* synthetic */ boolean $anonfun$getSortSpec$3(Tuple2 x$2) {
        Object object = x$2._2();
        Order order = Order.ASCENDING;
        return !(object != null ? !object.equals(order) : order != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSortSpec$5(RelFieldCollation.NullDirection x0$1) {
        boolean bl;
        RelFieldCollation.NullDirection nullDirection = x0$1;
        if (((Object)((Object)RelFieldCollation.NullDirection.LAST)).equals((Object)nullDirection)) {
            bl = true;
        } else if (((Object)((Object)RelFieldCollation.NullDirection.FIRST)).equals((Object)nullDirection)) {
            bl = false;
        } else {
            if (((Object)((Object)RelFieldCollation.NullDirection.UNSPECIFIED)).equals((Object)nullDirection)) {
                throw new TableException("Do not support UNSPECIFIED for null order.");
            }
            throw new MatchError((Object)nullDirection);
        }
        return bl;
    }

    public static final /* synthetic */ Object $anonfun$deduplicateSortKeys$1(int[] keys$1, boolean[] orders$1, boolean[] nullsIsLast$1, SortSpec.SortSpecBuilder builder$1, HashSet keySet$1, int i) {
        return keySet$1.add((Object)BoxesRunTime.boxToInteger((int)keys$1[i])) ? builder$1.addField(keys$1[i], orders$1[i], nullsIsLast$1[i]) : BoxedUnit.UNIT;
    }

    private SortUtil$() {
        MODULE$ = this;
    }
}

