/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Context;

public class ConfStringUtils {
    public static boolean isValidIp(String ip) {
        if (ip == null || ip.trim().isEmpty()) {
            return false;
        }
        if (ip.equals("localhost")) {
            ip = "127.0.0.1";
        }
        boolean b = false;
        if ((ip = ip.trim()).matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
            String[] s = ip.split("\\.");
            int number0 = Integer.parseInt(s[0]);
            int number1 = Integer.parseInt(s[1]);
            int number2 = Integer.parseInt(s[2]);
            int number3 = Integer.parseInt(s[3]);
            if (number0 >= 0 && number0 <= 255 && number1 >= 0 && number1 <= 255 && number2 >= 0 && number2 <= 255 && number3 >= 0 && number3 <= 255) {
                b = true;
            }
        }
        return b;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static int getIntValue(Context context, String fieldKey, int defVal) {
        String tmpVal = context.getString(fieldKey);
        if (StringUtils.isNotBlank((CharSequence)tmpVal)) {
            int result;
            tmpVal = tmpVal.trim();
            try {
                result = Integer.parseInt(tmpVal);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(fieldKey + "(" + tmpVal + ") must specify an integer value!");
            }
            return result;
        }
        return defVal;
    }

    public static long getLongValue(Context context, String fieldKey, long defVal) {
        String tmpVal = context.getString(fieldKey);
        if (StringUtils.isNotBlank((CharSequence)tmpVal)) {
            long result;
            tmpVal = tmpVal.trim();
            try {
                result = Long.parseLong(tmpVal);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(fieldKey + "(" + tmpVal + ") must specify an long value!");
            }
            return result;
        }
        return defVal;
    }
}

