/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network.tcp.codec;

import com.google.common.base.Joiner;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;

public class EncodeObject {
    private static final Joiner.MapJoiner mapJoiner = Joiner.on((String)"&").withKeyValueSeparator("=");
    private final MsgType msgType;
    private int intMsgType;
    private final String groupId;
    private final String streamId;
    private final long dtMs;
    private final long rtms;
    private int messageId;
    private int msgCnt = 0;
    private int eventSize;
    private int extField = 0;
    private int attrDataLength = 0;
    private byte[] attrData = null;
    private int bodyDataLength = 0;
    private byte[] bodyData = null;
    private int groupIdNum = 0;
    private int streamIdNum = 0;
    private final Map<String, String> attrMap = new HashMap<String, String>();
    private boolean compress;
    private byte[] aesKey;

    public EncodeObject(String groupId, String streamId, MsgType msgType, long dtMs, int eventSize) {
        this.groupId = groupId;
        this.streamId = streamId;
        this.msgType = msgType;
        this.eventSize = eventSize;
        this.intMsgType = this.msgType.getValue();
        this.rtms = System.currentTimeMillis();
        this.dtMs = this.msgType == MsgType.MSG_BIN_MULTI_BODY ? dtMs / 1000L : dtMs;
    }

    public void setGroupAndStreamId2Num(int groupIdNum, int streamIdNum) {
        this.groupIdNum = groupIdNum;
        this.streamIdNum = streamIdNum;
    }

    public void setExtField(int extField) {
        this.extField = extField;
    }

    public void setAttrInfo(int intMsgType, boolean isCompress, byte[] aesKey, Map<String, String> tgtAttrs) {
        this.intMsgType = intMsgType;
        this.compress = isCompress;
        this.aesKey = aesKey;
        if (tgtAttrs != null && !tgtAttrs.isEmpty()) {
            for (Map.Entry<String, String> entry : tgtAttrs.entrySet()) {
                if (entry == null || StringUtils.isBlank(entry.getKey()) || entry.getValue() == null) continue;
                this.attrMap.put(entry.getKey().trim(), entry.getValue().trim());
            }
            String preAttrStr = mapJoiner.join(this.attrMap);
            this.attrData = preAttrStr.getBytes(StandardCharsets.UTF_8);
            this.attrDataLength = this.attrData.length;
        }
    }

    public void setMessageIdInfo(int messageId) {
        this.messageId = messageId;
        if (this.msgType == MsgType.MSG_ACK_SERVICE || this.msgType == MsgType.MSG_MULTI_BODY) {
            this.attrMap.put("messageId", String.valueOf(this.messageId));
            String preAttrStr = mapJoiner.join(this.attrMap);
            this.attrData = preAttrStr.getBytes(StandardCharsets.UTF_8);
            this.attrDataLength = this.attrData.length;
        }
    }

    public void setBodyData(int msgCnt, byte[] bodyBytes) {
        this.msgCnt = msgCnt;
        this.bodyData = bodyBytes;
        if (this.bodyData != null) {
            this.bodyDataLength = this.bodyData.length;
        }
    }

    public MsgType getMsgType() {
        return this.msgType;
    }

    public int getIntMsgType() {
        return this.intMsgType;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public long getRtms() {
        return this.rtms;
    }

    public int getStreamIdNum() {
        return this.streamIdNum;
    }

    public int getGroupIdNum() {
        return this.groupIdNum;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public byte[] getAesKey() {
        return this.aesKey;
    }

    public int getBodyDataLength() {
        return this.bodyDataLength;
    }

    public byte[] getBodyData() {
        return this.bodyData;
    }

    public int getAttrDataLength() {
        return this.attrDataLength;
    }

    public byte[] getAttrData() {
        return this.attrData;
    }

    public int getExtField() {
        return this.extField;
    }

    public int getMsgSize() {
        return this.attrDataLength + this.bodyDataLength;
    }

    public int getMsgCnt() {
        return this.msgCnt;
    }

    public long getDtMs() {
        return this.dtMs;
    }

    public int getEventSize() {
        return this.eventSize;
    }
}

