/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
public class JsonIgnorePropertiesModelPlugin
implements ModelBuilderPlugin {
    private final TypeResolver typeResolver;

    @Autowired
    public JsonIgnorePropertiesModelPlugin(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void apply(ModelContext context) {
        JsonIgnoreProperties ignorable = (JsonIgnoreProperties)AnnotationUtils.findAnnotation(this.forClass(context), JsonIgnoreProperties.class);
        if (ignorable != null && ignorable.value().length > 0) {
            context.getModelSpecificationBuilder().compoundModelIfExists(c -> Stream.of(ignorable.value()).forEach(name -> c.propertyIfExists(name).apply(p -> p.isHidden(Boolean.valueOf(true)))));
        }
    }

    private Class<?> forClass(ModelContext context) {
        return this.typeResolver.resolve((Type)context.getType(), new Type[0]).getErasedType();
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

