/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.store;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.store.KeyValueEntity;
import org.apache.inlong.agent.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStore.class);
    private final Store store;

    public TaskStore(Store store) {
        this.store = store;
    }

    public List<TaskProfile> getTasks() {
        List<KeyValueEntity> result = this.store.findAll(this.getKey());
        ArrayList<TaskProfile> taskList = new ArrayList<TaskProfile>();
        for (KeyValueEntity entity : result) {
            taskList.add(entity.getAsTaskProfile());
        }
        return taskList;
    }

    public void storeTask(TaskProfile task) {
        if (task.allRequiredKeyExist()) {
            String keyName = this.getKeyByTaskId(task.getTaskId());
            KeyValueEntity entity = new KeyValueEntity(keyName, task.toJsonStr(), "");
            this.store.put(entity);
        }
    }

    public TaskProfile getTask(String taskId) {
        KeyValueEntity result = this.store.get(this.getKeyByTaskId(taskId));
        if (result == null) {
            return null;
        }
        return result.getAsTaskProfile();
    }

    public void deleteTask(String taskId) {
        this.store.remove(this.getKeyByTaskId(taskId));
    }

    public String getKey() {
        if (this.store.getUniqueKey().isEmpty()) {
            return "task";
        }
        return this.store.getUniqueKey() + this.store.getSplitter() + "task";
    }

    public String getKeyByTaskId(String taskId) {
        return this.getKey() + this.store.getSplitter() + taskId;
    }
}

