/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;

public class AgentDbUtils {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(((0x)|(0X)|o|O)??[0-9a-fA-F]+?) *, *(((0x)|(0X)|o|O)??[0-9a-fA-F]+?) *(, *[0-9]*?)??}");
    private static final Pattern OCT_PATTERN = Pattern.compile("^o[0-7]+?$");
    private static final Pattern DEC_PATTERN = Pattern.compile("^[0-9]+?$");
    private static final int HEX_MODE = 16;
    private static final int EIGHT_MODE = 8;
    private static final String HEX_PREFIX = "0x";
    private static final String O_PREFIX = "o";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnectionFailover(String driverClassName, String connectionUrl, String userName, String password) throws Exception {
        int totalRetryTimes = 3;
        int timeInterval = 10;
        connectionUrl = StringUtils.trim((String)connectionUrl);
        connectionUrl = StringUtils.replace((String)connectionUrl, (String)"\r", (String)"");
        connectionUrl = StringUtils.replace((String)connectionUrl, (String)"\n", (String)"");
        Class<AgentDbUtils> clazz = AgentDbUtils.class;
        synchronized (AgentDbUtils.class) {
            DbUtils.loadDriver((String)driverClassName);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            Connection conn = null;
            int retryTimes = 0;
            while (conn == null) {
                try {
                    conn = DriverManager.getConnection(connectionUrl, userName, password);
                }
                catch (Exception e) {
                    if (++retryTimes >= totalRetryTimes) {
                        throw new SQLException("Failed to connect database after retry " + retryTimes + " times.", e);
                    }
                    TimeUnit.SECONDS.sleep(timeInterval);
                }
            }
            conn.setAutoCommit(false);
            return conn;
        }
    }

    private static String format(int num, boolean lengthEquals, int length, int mode) {
        String numStr;
        if (mode == 16) {
            numStr = Integer.toHexString(num);
            length -= 2;
        } else if (mode == 8) {
            numStr = Integer.toOctalString(num);
            --length;
        } else {
            numStr = String.valueOf(num);
        }
        if (lengthEquals && numStr.length() < length) {
            StringBuilder numberFormatStr = new StringBuilder();
            for (int i = 0; i < length - numStr.length(); ++i) {
                numberFormatStr.append(0);
            }
            numberFormatStr.append(numStr);
            numStr = numberFormatStr.toString();
        }
        return numStr;
    }

    private static int parseInt(String parseStr) {
        int parseValue = -1;
        if (parseStr.startsWith(HEX_PREFIX)) {
            parseStr = parseStr.substring(2).trim();
            parseValue = Integer.parseInt(parseStr, 16);
        } else if (parseStr.startsWith(O_PREFIX)) {
            parseStr = parseStr.substring(1).trim();
            parseValue = Integer.parseInt(parseStr, 8);
        } else {
            parseValue = Integer.parseInt(parseStr);
        }
        return parseValue;
    }

    public static String[] replaceDynamicSeq(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        Matcher matcher = PATTERN.matcher(str);
        ArrayList<String> startNum = new ArrayList<String>();
        ArrayList<String> endNum = new ArrayList<String>();
        ArrayList<Integer> modes = new ArrayList<Integer>();
        ArrayList<Integer> steps = new ArrayList<Integer>();
        while (matcher.find()) {
            Matcher endMatch;
            Matcher startMatch;
            String stepStr;
            String matchStr = matcher.group(0);
            matchStr = StringUtils.strip((String)matchStr, (String)"${");
            matchStr = StringUtils.strip((String)matchStr, (String)"}");
            String[] patterns = matchStr.split(",");
            String startStr = patterns[0].trim().toLowerCase();
            String endStr = patterns[1].trim().toLowerCase();
            int step = 1;
            if (patterns.length >= 3 && (stepStr = patterns[2].trim()).length() > 0) {
                step = AgentDbUtils.parseInt(stepStr);
            }
            boolean bFound = false;
            int mode = -1;
            if (startStr.startsWith(HEX_PREFIX) && endStr.startsWith(HEX_PREFIX)) {
                bFound = true;
                mode = 16;
            } else if (startStr.startsWith(O_PREFIX) && endStr.startsWith(O_PREFIX)) {
                startMatch = OCT_PATTERN.matcher(startStr);
                endMatch = OCT_PATTERN.matcher(endStr);
                if (startMatch.find() && endMatch.find()) {
                    bFound = true;
                    mode = 8;
                }
            } else {
                startMatch = DEC_PATTERN.matcher(startStr);
                endMatch = DEC_PATTERN.matcher(endStr);
                if (startMatch.find() && endMatch.find()) {
                    bFound = true;
                    mode = 10;
                }
            }
            if (!bFound) continue;
            startNum.add(startStr);
            endNum.add(endStr);
            modes.add(mode);
            steps.add(step);
            matcher.appendReplacement(sb, "\\${" + index++ + "}");
        }
        matcher.appendTail(sb);
        ArrayList<String>[] tempArray = AgentDbUtils.formatStartNum(startNum, endNum, modes, steps, sb);
        return tempArray[startNum.size()].toArray(new String[0]);
    }

    private static ArrayList<String>[] formatStartNum(ArrayList<String> startNum, ArrayList<String> endNum, ArrayList<Integer> modes, ArrayList<Integer> steps, StringBuffer sb) {
        ArrayList[] tempArray = new ArrayList[startNum.size() + 1];
        tempArray[0] = new ArrayList();
        tempArray[0].add(sb.toString());
        for (int index = 0; index < startNum.size(); ++index) {
            String start = startNum.get(index);
            String end = endNum.get(index);
            int mode = modes.get(index);
            int step = steps.get(index);
            tempArray[index + 1] = new ArrayList();
            boolean lengthEquals = start.length() == end.length();
            for (String currentPath : tempArray[index]) {
                for (int i = AgentDbUtils.parseInt(start); i <= AgentDbUtils.parseInt(end); i += step) {
                    tempArray[index + 1].add(currentPath.replaceAll("\\$\\{" + index + "}", AgentDbUtils.format(i, lengthEquals, end.length(), mode)));
                }
            }
        }
        return tempArray;
    }
}

