/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.fielddef;

public enum WebFieldType {
    UNKNOWN(-1, "Unknown field type"),
    STRING(1, "String"),
    INT(2, "int"),
    LONG(3, "long"),
    BOOLEAN(4, "Boolean"),
    DATE(5, "Date"),
    COMPSTRING(6, "Compound string"),
    COMPINT(7, "Compound integer"),
    COMPLONG(8, "Compound long"),
    JSONDICT(9, "Json dict"),
    JSONSET(10, "Json set"),
    DELPOLICY(11, "Delete policy");

    private int value;
    private String desc;

    private WebFieldType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static WebFieldType valueOf(int value) {
        for (WebFieldType fieldType : WebFieldType.values()) {
            if (fieldType.getValue() != value) continue;
            return fieldType;
        }
        return UNKNOWN;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}

