/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.statusdef;

import org.apache.inlong.tubemq.corebase.utils.Tuple2;

public enum ManageStatus {
    STATUS_MANAGE_UNDEFINED(-2, "-", false, false),
    STATUS_MANAGE_APPLY(1, "draft", false, false),
    STATUS_MANAGE_ONLINE(5, "online", true, true),
    STATUS_MANAGE_ONLINE_NOT_WRITE(6, "only-read", false, true),
    STATUS_MANAGE_ONLINE_NOT_READ(7, "only-write", true, false),
    STATUS_MANAGE_OFFLINE(9, "offline", false, false);

    private int code;
    private String description;
    private boolean isAcceptPublish;
    private boolean isAcceptSubscribe;

    private ManageStatus(int code, String description, boolean acceptPublish, boolean acceptSubscribe) {
        this.code = code;
        this.description = description;
        this.isAcceptPublish = acceptPublish;
        this.isAcceptSubscribe = acceptSubscribe;
    }

    public boolean isOnlineStatus() {
        return this == STATUS_MANAGE_ONLINE || this == STATUS_MANAGE_ONLINE_NOT_WRITE || this == STATUS_MANAGE_ONLINE_NOT_READ;
    }

    public boolean isApplied() {
        return this.code > STATUS_MANAGE_APPLY.getCode();
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Tuple2<Boolean, Boolean> getPubSubStatus() {
        return new Tuple2((Object)this.isAcceptPublish, (Object)this.isAcceptSubscribe);
    }

    public boolean isAcceptSubscribe() {
        return this.isAcceptSubscribe;
    }

    public boolean isAcceptPublish() {
        return this.isAcceptPublish;
    }

    public static ManageStatus valueOf(int code) {
        for (ManageStatus status : ManageStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalArgumentException(String.format("unknown broker manage status code %s", code));
    }

    public static ManageStatus descOf(String description) {
        for (ManageStatus status : ManageStatus.values()) {
            if (!status.getDescription().equalsIgnoreCase(description)) continue;
            return status;
        }
        throw new IllegalArgumentException(String.format("unknown broker manage status name %s", description));
    }

    public static ManageStatus getNewStatus(ManageStatus oldStatus, Boolean acceptPublish, Boolean acceptSubscribe) {
        if (acceptPublish == null && acceptSubscribe == null) {
            return oldStatus;
        }
        boolean newPublish = oldStatus.isAcceptPublish;
        boolean newSubscribe = oldStatus.isAcceptSubscribe;
        if (acceptPublish != null) {
            newPublish = acceptPublish;
        }
        if (acceptSubscribe != null) {
            newSubscribe = acceptSubscribe;
        }
        if (newPublish) {
            if (newSubscribe) {
                return STATUS_MANAGE_ONLINE;
            }
            return STATUS_MANAGE_ONLINE_NOT_READ;
        }
        if (newSubscribe) {
            return STATUS_MANAGE_ONLINE_NOT_WRITE;
        }
        return STATUS_MANAGE_OFFLINE;
    }
}

