/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.utils;

import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import java.io.IOException;
import org.apache.inlong.tubemq.corebase.utils.AbstractSamplePrint;
import org.slf4j.Logger;

public class MetaConfigSamplePrint
extends AbstractSamplePrint {
    private final Logger logger;

    public MetaConfigSamplePrint(Logger logger) {
        this.logger = logger;
    }

    public MetaConfigSamplePrint(Logger logger, long sampleDetailDur, long sampleResetDur, long maxDetailCount, long maxTotalCount) {
        super(sampleDetailDur, sampleResetDur, maxDetailCount, maxTotalCount);
        this.logger = logger;
    }

    public void printExceptionCaught(Throwable e) {
    }

    public void printExceptionCaught(Throwable e, String hostName, String nodeName) {
        if (e != null) {
            if (e instanceof IOException) {
                long now = System.currentTimeMillis();
                long diffTime = now - this.lastLogTime.get();
                long curPrintCnt = this.totalPrintCount.incrementAndGet();
                if (curPrintCnt < this.maxTotalCount) {
                    if (diffTime < this.sampleDetailDur && curPrintCnt < this.maxDetailCount) {
                        this.logger.error(this.sBuilder.append("[MetaConfig Error] Connect to node:[").append(hostName).append(",").append(nodeName).append("] IOException error").toString(), e);
                    } else {
                        this.logger.error(this.sBuilder.append("[MetaConfig Error] Connect to node:[").append(hostName).append(",").append(nodeName).append("] IOException error is ").append(e.toString()).toString());
                    }
                    this.sBuilder.delete(0, this.sBuilder.length());
                }
                if (diffTime > this.sampleResetDur && this.lastLogTime.compareAndSet(now - diffTime, now)) {
                    this.totalPrintCount.set(0L);
                }
            } else if (e instanceof ServiceDispatcher.ServiceConnectFailedException) {
                long curPrintCnt = this.totalUncheckCount.incrementAndGet();
                if (curPrintCnt < this.maxUncheckDetailCount) {
                    this.logger.error(this.sBuilder.append("[MetaConfig Error] Connect to node:[").append(hostName).append(",").append(nodeName).append("] ServiceConnectFailedException error").toString(), e);
                } else {
                    this.logger.error(this.sBuilder.append("[MetaConfig Error] Connect to node:[").append(hostName).append(",").append(nodeName).append("] ServiceConnectFailedException error is ").append(e.toString()).toString());
                }
                this.sBuilder.delete(0, this.sBuilder.length());
            } else {
                this.logger.error(this.sBuilder.append("[MetaConfig Error] Connect to node:[").append(hostName).append(",").append(nodeName).append("] throw error").toString(), e);
                this.sBuilder.delete(0, this.sBuilder.length());
            }
        }
    }

    public void printWarn(String err) {
    }

    public void printError(String err) {
    }
}

