/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Properties;
import kafka.server.ConfigAdminManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.logger.RuntimeLoggerManager;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourceType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t%c\u0001B\r\u001b\u0001}A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0004C\u0001\t\u0007I\u0011A\"\t\r)\u0003\u0001\u0015!\u0003E\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u001d\tI\u0003\u0001C\u0005\u0003WAq!!\u000b\u0001\t\u0013\t)\u0005\u0003\u0004L\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003S\u0001A\u0011BA6\u0011\u001d\t\t\b\u0001C\u0001\u0003g:q!!\u001f\u001b\u0011\u0003\tYH\u0002\u0004\u001a5!\u0005\u0011Q\u0010\u0005\u0007y9!\t!a \t\u0013\u0005\u0005eB1A\u0005\u0002\u0005\r\u0005\u0002CAI\u001d\u0001\u0006I!!\"\t\u000f\u0005Me\u0002\"\u0001\u0002\u0016\"9\u00111\u0013\b\u0005\u0002\u0005u\u0005bBAR\u001d\u0011\u0005\u0011Q\u0015\u0005\b\u0003ssA\u0011AA^\u0011\u001d\tIM\u0004C\u0001\u0003\u0017Dq!a?\u000f\t\u0003\ti\u0010C\u0004\u0003\u00129!\tAa\u0005\u0003%\r{gNZ5h\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\u0006\u00037q\taa]3sm\u0016\u0014(\"A\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9#&D\u0001)\u0015\tIC$A\u0003vi&d7/\u0003\u0002,Q\t9Aj\\4hS:<\u0017A\u00028pI\u0016LE\r\u0005\u0002\"]%\u0011qF\t\u0002\u0004\u0013:$\u0018\u0001B2p]\u001a\u0004\"AM\u001a\u000e\u0003iI!\u0001\u000e\u000e\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011G>tg-[4SKB|7/\u001b;pef\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\u000e\u0002\u00115,G/\u00193bi\u0006L!a\u000f\u001d\u0003!\r{gNZ5h%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u0003?\u007f\u0001\u000b\u0005C\u0001\u001a\u0001\u0011\u0015aC\u00011\u0001.\u0011\u0015\u0001D\u00011\u00012\u0011\u0015)D\u00011\u00017\u0003Q\u0011XO\u001c;j[\u0016dunZ4fe6\u000bg.Y4feV\tA\t\u0005\u0002F\u00116\taI\u0003\u0002H5\u00051An\\4hKJL!!\u0013$\u0003)I+h\u000e^5nK2{wmZ3s\u001b\u0006t\u0017mZ3s\u0003U\u0011XO\u001c;j[\u0016dunZ4fe6\u000bg.Y4fe\u0002\n!\u0002\u001d:faJ|7-Z:t)\ri\u0005P \t\u0005\u001dN+&/D\u0001P\u0015\t\u0001\u0016+\u0001\u0003vi&d'\"\u0001*\u0002\t)\fg/Y\u0005\u0003)>\u0013q\"\u00133f]RLG/\u001f%bg\"l\u0015\r\u001d\t\u0003->t!a\u00167\u000f\u0005aKgBA-g\u001d\tQFM\u0004\u0002\\C:\u0011AlX\u0007\u0002;*\u0011aLH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001\f1a\u001c:h\u0013\t\u00117-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A&\u0011Q$\u001a\u0006\u0003E\u000eL!a\u001a5\u0002\r\r|W.\\8o\u0015\tiR-\u0003\u0002kW\u00069Q.Z:tC\u001e,'BA4i\u0013\tig.\u0001\u0012J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0003U.L!\u0001]9\u0003)\u0005cG/\u001a:D_:4\u0017nZ:SKN|WO]2f\u0015\tig\u000e\u0005\u0002tm6\tAO\u0003\u0002vW\u0006A!/Z9vKN$8/\u0003\u0002xi\nA\u0011\t]5FeJ|'\u000fC\u0003z\u000f\u0001\u0007!0A\u0004sKF,Xm\u001d;\u0011\u0005mdX\"\u00018\n\u0005ut'AI%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\t\u0006$\u0018\r\u0003\u0004\u0000\u000f\u0001\u0007\u0011\u0011A\u0001\nCV$\bn\u001c:ju\u0016\u0004\u0012\"IA\u0002\u0003\u000f\t\u0019\"a\t\n\u0007\u0005\u0015!EA\u0005Gk:\u001cG/[8oeA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e-\f\u0001B]3t_V\u00148-Z\u0005\u0005\u0003#\tYA\u0001\u0007SKN|WO]2f)f\u0004X\r\u0005\u0003\u0002\u0016\u0005ua\u0002BA\f\u00033\u0001\"\u0001\u0018\u0012\n\u0007\u0005m!%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037\u0011\u0003cA\u0011\u0002&%\u0019\u0011q\u0005\u0012\u0003\u000f\t{w\u000e\\3b]\u0006Qb/\u00197jI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0005.\u00198hKR1\u0011QFA\u001a\u0003k\u00012!IA\u0018\u0013\r\t\tD\t\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u000e!\u0001\r!\u0016\u0005\b\u0003oA\u0001\u0019AA\u001d\u00039\u0019wN\u001c4jOJ+7o\\;sG\u0016\u0004B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fY\u0017AB2p]\u001aLw-\u0003\u0003\u0002D\u0005u\"AD\"p]\u001aLwMU3t_V\u00148-\u001a\u000b\u0007\u0003[\t9%!\u0015\t\u000f\u0005%\u0013\u00021\u0001\u0002L\u0005)\u0001O]8qgB\u0019a*!\u0014\n\u0007\u0005=sJ\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a\u000e\n\u0001\u0004\tI\u0004\u0006\u0003\u0002V\u0005\r\u0004#\u0002(T\u0003/\u0012\b\u0003BA-\u0003?r1aVA.\u0013\r\tiF\\\u0001\u0018\u00032$XM]\"p]\u001aLwm\u001d*fcV,7\u000f\u001e#bi\u0006L1\u0001]A1\u0015\r\tiF\u001c\u0005\u0007s*\u0001\r!!\u001a\u0011\u0007m\f9'C\u0002\u0002j9\u0014q#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR$\u0015\r^1\u0015\r\u00055\u0012QNA8\u0011\u001d\tia\u0003a\u0001\u0003/Bq!a\u000e\f\u0001\u0004\tI$A\u0012wC2LG-\u0019;f%\u0016\u001cx.\u001e:dK:\u000bW.Z%t\u0007V\u0014(/\u001a8u\u001d>$W-\u00133\u0015\t\u00055\u0012Q\u000f\u0005\b\u0003ob\u0001\u0019AA\n\u0003\u0011q\u0017-\\3\u0002%\r{gNZ5h\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\t\u0003e9\u0019\"A\u0004\u0011\u0015\u0005\u0005m\u0014a\u00017pOV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111R2\u0002\u000bMdg\r\u000e6\n\t\u0005=\u0015\u0011\u0012\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u0018G>\u0004\u0018pV5uQ>,H\u000f\u0015:faJ|7-Z:tK\u0012$RA_AL\u00033CQ!\u001f\nA\u0002iDa!a'\u0013\u0001\u0004i\u0015!\u00039s_\u000e,7o]3e)\u0019\t)'a(\u0002\"\"1\u0011p\u0005a\u0001\u0003KBq!a'\u0014\u0001\u0004\t)&A\u000fsK\u0006\u001c8/Z7cY\u0016Len\u0019:f[\u0016tG/\u00197SKN\u0004xN\\:f)!\t9+!,\u00022\u0006U\u0006cA>\u0002*&\u0019\u00111\u00168\u0003G%s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:q_:\u001cX\rR1uC\"1\u0011q\u0016\u000bA\u0002i\f\u0001b\u001c:jO&t\u0017\r\u001c\u0005\u0007\u0003g#\u0002\u0019A'\u0002-A\u0014X\r\u001d:pG\u0016\u001c8/\u001b8h%\u0016\u001c\bo\u001c8tKNDq!a.\u0015\u0001\u0004\t9+A\nqKJ\u001c\u0018n\u001d;f]R\u0014Vm\u001d9p]N,7/\u0001\rsK\u0006\u001c8/Z7cY\u0016dUmZ1dsJ+7\u000f]8og\u0016$\u0002\"!0\u0002D\u0006\u0015\u0017q\u0019\t\u0004w\u0006}\u0016bAAa]\nA\u0012\t\u001c;fe\u000e{gNZ5hgJ+7\u000f]8og\u0016$\u0015\r^1\t\u000f\u0005=V\u00031\u0001\u0002f!9\u00111W\u000bA\u0002\u0005U\u0003bBA\\+\u0001\u0007\u0011QX\u0001\u0013G>tG/Y5og\u0012+\b\u000f\\5dCR,7/\u0006\u0003\u0002N\u0006%H\u0003BA\u0012\u0003\u001fDq!!5\u0017\u0001\u0004\t\u0019.\u0001\u0005ji\u0016\u0014\u0018M\u00197f!\u0019\t).a8\u0002f:!\u0011q[An\u001d\ra\u0016\u0011\\\u0005\u0002G%\u0019\u0011Q\u001c\u0012\u0002\u000fA\f7m[1hK&!\u0011\u0011]Ar\u0005!IE/\u001a:bE2,'bAAoEA!\u0011q]Au\u0019\u0001!q!a;\u0017\u0005\u0004\tiOA\u0001U#\u0011\ty/!>\u0011\u0007\u0005\n\t0C\u0002\u0002t\n\u0012qAT8uQ&tw\rE\u0002\"\u0003oL1!!?#\u0005\r\te._\u0001\u0010i>dunZ4bE2,\u0007K]8qgR1\u0011q B\u0006\u0005\u001b\u0001\u0002B!\u0001\u0003\b\u0005M\u00111C\u0007\u0003\u0005\u0007Q1A!\u0002#\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0013\u0011\u0019AA\u0002NCBDq!!\u0004\u0018\u0001\u0004\tI\u0004C\u0004\u0003\u0010]\u0001\r!a\u0013\u0002\u0017\r|gNZ5h!J|\u0007o]\u0001\u001aaJ,\u0007/\u0019:f\u0013:\u001c'/Z7f]R\fGnQ8oM&<7\u000f\u0006\u0005\u0002.\tU!q\u0006B\u0019\u0011\u001d\u00119\u0002\u0007a\u0001\u00053\ta\"\u00197uKJ\u001cuN\u001c4jO>\u00038\u000f\u0005\u0004\u0003\u0002\tm!qD\u0005\u0005\u0005;\u0011\u0019AA\u0002TKF\u0004BA!\t\u0003,5\u0011!1\u0005\u0006\u0005\u0005K\u00119#A\u0003bI6LgNC\u0002\u0003*!\fqa\u00197jK:$8/\u0003\u0003\u0003.\t\r\"!D!mi\u0016\u00148i\u001c8gS\u001e|\u0005\u000fC\u0004\u0003\u0010a\u0001\r!a\u0013\t\u000f\tM\u0002\u00041\u0001\u00036\u0005Q1m\u001c8gS\u001e\\U-_:\u0011\u0011\t\u0005!qAA\n\u0005o\u0001BA!\u000f\u0003D9!!1\bB \u001d\rA&QH\u0005\u0004\u0003\u007fY\u0017\u0002\u0002B!\u0003{\t\u0011bQ8oM&<G)\u001a4\n\t\t\u0015#q\t\u0002\n\u0007>tg-[4LKfTAA!\u0011\u0002>\u0001")
public class ConfigAdminManager
implements Logging {
    private final int nodeId;
    private final KafkaConfig conf;
    private final ConfigRepository configRepository;
    private final RuntimeLoggerManager runtimeLoggerManager;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void prepareIncrementalConfigs(Seq<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        ConfigAdminManager$.MODULE$.prepareIncrementalConfigs(alterConfigOps, configProps, configKeys);
    }

    public static Map<String, String> toLoggableProps(ConfigResource resource, Properties configProps) {
        return ConfigAdminManager$.MODULE$.toLoggableProps(resource, configProps);
    }

    public static <T> boolean containsDuplicates(Iterable<T> iterable) {
        return ConfigAdminManager$.MODULE$.containsDuplicates(iterable);
    }

    public static AlterConfigsResponseData reassembleLegacyResponse(AlterConfigsRequestData original, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, AlterConfigsResponseData persistentResponses) {
        return ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessingResponses, persistentResponses);
    }

    public static IncrementalAlterConfigsResponseData reassembleIncrementalResponse(IncrementalAlterConfigsRequestData original, IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, IncrementalAlterConfigsResponseData persistentResponses) {
        return ConfigAdminManager$.MODULE$.reassembleIncrementalResponse(original, preprocessingResponses, persistentResponses);
    }

    public static AlterConfigsRequestData copyWithoutPreprocessed(AlterConfigsRequestData request, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        return ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed);
    }

    public static IncrementalAlterConfigsRequestData copyWithoutPreprocessed(IncrementalAlterConfigsRequestData request, IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        return ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed);
    }

    public static Logger log() {
        return ConfigAdminManager$.MODULE$.log();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RuntimeLoggerManager runtimeLoggerManager() {
        return this.runtimeLoggerManager;
    }

    public IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocess(IncrementalAlterConfigsRequestData request, Function2<ResourceType, String, Object> authorize) {
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> results = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        HashMap resourceIds = new HashMap();
        request.resources().forEach(resource -> {
            IncrementalAlterConfigsRequestData.AlterConfigsResource preexisting = resourceIds.put(new Tuple2((Object)BoxesRunTime.boxToByte((byte)resource.resourceType()), (Object)resource.resourceName()), resource);
            if (preexisting != null) {
                new .colon.colon((Object)preexisting, (List)new .colon.colon(resource, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)r -> results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)r, new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once.")));
                return;
            }
        });
        request.resources().forEach(resource -> {
            if (!results.containsKey(resource)) {
                ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)resource.resourceType());
                ConfigResource configResource = new ConfigResource(resourceType, resource.resourceName());
                try {
                    if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x$1 -> x$1.name()))) {
                        throw new InvalidRequestException("Error due to duplicate config keys");
                    }
                    ArrayList nullUpdates = new ArrayList();
                    resource.configs().forEach(config -> {
                        if (config.configOperation() != AlterConfigOp.OpType.DELETE.id() && config.value() == null) {
                            nullUpdates.add(config.name());
                            return;
                        }
                    });
                    if (!nullUpdates.isEmpty()) {
                        throw new InvalidRequestException("Null value not supported for : " + String.join((CharSequence)", ", nullUpdates));
                    }
                    if (ConfigResource.Type.BROKER_LOGGER.equals(resourceType)) {
                        this.runtimeLoggerManager().applyChangesForResource(BoxesRunTime.unboxToBoolean((Object)authorize.apply((Object)ResourceType.CLUSTER, (Object)"kafka-cluster")), request.validateOnly(), (IncrementalAlterConfigsRequestData.AlterConfigsResource)resource);
                        results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.NONE);
                    } else if (ConfigResource.Type.BROKER.equals(resourceType)) {
                        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configResource.name()))) {
                            this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                        }
                        this.validateBrokerConfigChange((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, configResource);
                    } else if (!(ConfigResource.Type.TOPIC.equals(resourceType) ? true : (ConfigResource.Type.CLIENT_METRICS.equals(resourceType) ? true : ConfigResource.Type.GROUP.equals(resourceType)))) {
                        throw new InvalidRequestException("Unknown resource type " + resource.resourceType());
                    }
                }
                catch (Throwable t) {
                    ApiError err = ApiError.fromThrowable((Throwable)t);
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Error preprocessing incrementalAlterConfigs request on " + configResource, (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, err);
                }
                return;
            }
        });
        return results;
    }

    private void validateBrokerConfigChange(IncrementalAlterConfigsRequestData.AlterConfigsResource resource, ConfigResource configResource) {
        boolean perBrokerConfig = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configResource.name()));
        Properties persistentProps = this.configRepository.config(configResource);
        Properties configProps = this.conf.dynamicConfig().fromPersistentProps(persistentProps, perBrokerConfig);
        scala.collection.immutable.Seq alterConfigOps = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)config -> {
            AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId((byte)config.configOperation());
            if (opType == null) {
                throw new InvalidRequestException("Unknown operations type " + config.configOperation());
            }
            return new AlterConfigOp(new ConfigEntry(config.name(), config.value()), opType);
        })).toSeq();
        ConfigAdminManager$.MODULE$.prepareIncrementalConfigs((Seq<AlterConfigOp>)alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
        try {
            this.validateBrokerConfigChange(configProps, configResource);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "validation of configProps " + configProps + " for " + configResource + " failed with exception", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            throw t;
        }
    }

    private void validateBrokerConfigChange(Properties props, ConfigResource configResource) {
        try {
            this.conf.dynamicConfig().validate(props, StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configResource.name())));
            return;
        }
        catch (ApiException apiException) {
            throw apiException;
        }
        catch (Throwable e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocess(AlterConfigsRequestData request) {
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> results = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        HashMap resourceIds = new HashMap();
        request.resources().forEach(resource -> {
            AlterConfigsRequestData.AlterConfigsResource preexisting = resourceIds.put(new Tuple2((Object)BoxesRunTime.boxToByte((byte)resource.resourceType()), (Object)resource.resourceName()), resource);
            if (preexisting != null) {
                new .colon.colon((Object)preexisting, (List)new .colon.colon(resource, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)r -> results.put((AlterConfigsRequestData.AlterConfigsResource)r, new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once.")));
                return;
            }
        });
        request.resources().forEach(resource -> {
            if (!results.containsKey(resource)) {
                ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)resource.resourceType());
                ConfigResource configResource = new ConfigResource(resourceType, resource.resourceName());
                try {
                    if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x$2 -> x$2.name()))) {
                        throw new InvalidRequestException("Error due to duplicate config keys");
                    }
                    ArrayList nullUpdates = new ArrayList();
                    resource.configs().forEach(config -> {
                        if (config.value() == null) {
                            nullUpdates.add(config.name());
                            return;
                        }
                    });
                    if (!nullUpdates.isEmpty()) {
                        throw new InvalidRequestException("Null value not supported for : " + String.join((CharSequence)", ", nullUpdates));
                    }
                    if (ConfigResource.Type.BROKER.equals(resourceType)) {
                        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(configResource.name()))) {
                            this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                        }
                        this.validateBrokerConfigChange((AlterConfigsRequestData.AlterConfigsResource)resource, configResource);
                    } else if (!(ConfigResource.Type.TOPIC.equals(resourceType) ? true : (ConfigResource.Type.CLIENT_METRICS.equals(resourceType) ? true : ConfigResource.Type.GROUP.equals(resourceType)))) {
                        throw new InvalidRequestException("Unknown resource type " + resource.resourceType());
                    }
                }
                catch (Throwable throwable) {
                    ApiError err = ApiError.fromThrowable((Throwable)throwable);
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Error preprocessing alterConfigs request on " + configResource + ": " + err);
                    results.put((AlterConfigsRequestData.AlterConfigsResource)resource, err);
                }
                return;
            }
        });
        return results;
    }

    private void validateBrokerConfigChange(AlterConfigsRequestData.AlterConfigsResource resource, ConfigResource configResource) {
        Properties props = new Properties();
        resource.configs().forEach(config -> props.setProperty(config.name(), config.value()));
        this.validateBrokerConfigChange(props, configResource);
    }

    public void validateResourceNameIsCurrentNodeId(String name) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(name));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException("Node id must be an integer, but it is: " + name);
        }
        if (n != this.nodeId) {
            throw new InvalidRequestException("Unexpected broker id, expected " + this.nodeId + ", but received " + name);
        }
    }

    public ConfigAdminManager(int nodeId, KafkaConfig conf, ConfigRepository configRepository) {
        this.nodeId = nodeId;
        this.conf = conf;
        this.configRepository = configRepository;
        this.logIdent_$eq("[ConfigAdminManager[nodeId=" + nodeId + "]: ");
        this.runtimeLoggerManager = new RuntimeLoggerManager(nodeId, this.logger().underlying());
    }
}

