/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.server.DelayedRemoteFetchMetrics$;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\b\u0010\u0001QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tq\u0001\u0011\t\u0011)A\u0005s!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u00111\u0004!\u0011!Q\u0001\n5D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005o\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\tY\u0003\u0001C!\u0003S\u0011!\u0003R3mCf,GMU3n_R,g)\u001a;dQ*\u0011\u0001#E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001+\u0005\u0002\"AF\u0010\u000e\u0003]Q!\u0001G\r\u0002\u0013A,(oZ1u_JL(B\u0001\t\u001b\u0015\t\u00112D\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<\u0017B\u0001\u0011\u0018\u0005A!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000e\u0005\u0002#K5\t1E\u0003\u0002%#\u0005)Q\u000f^5mg&\u0011ae\t\u0002\b\u0019><w-\u001b8h\u0003=\u0011X-\\8uK\u001a+Go\u00195UCN\\\u0007cA\u00151e5\t!F\u0003\u0002,Y\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00055r\u0013\u0001B;uS2T\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022U\t1a)\u001e;ve\u0016\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0018\u0002\t1\fgnZ\u0005\u0003oQ\u0012AAV8jI\u0006\t\"/Z7pi\u00164U\r^2i%\u0016\u001cX\u000f\u001c;\u0011\u0007%RD(\u0003\u0002<U\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015a\u00017pO*\u0011\u0011IQ\u0001\nS:$XM\u001d8bYNT!a\u0011\u000e\u0002\u000fM$xN]1hK&\u0011QI\u0010\u0002\u0014%\u0016lw\u000e^3M_\u001e\u0014V-\u00193SKN,H\u000e^\u0001\u0010e\u0016lw\u000e^3GKR\u001c\u0007.\u00138g_B\u0011Q\bS\u0005\u0003\u0013z\u0012aCU3n_R,7\u000b^8sC\u001e,g)\u001a;dQ&sgm\\\u0001\u0015e\u0016lw\u000e^3GKR\u001c\u0007.T1y/\u0006LG/T:\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\t1{gnZ\u0001\u0015M\u0016$8\r\u001b)beRLG/[8o'R\fG/^:\u0011\u0007M3\u0006,D\u0001U\u0015\t)V*\u0001\u0006d_2dWm\u0019;j_:L!a\u0016+\u0003\u0007M+\u0017\u000f\u0005\u0003M3n\u000b\u0017B\u0001.N\u0005\u0019!V\u000f\u001d7feA\u0011AlX\u0007\u0002;*\u0011aLG\u0001\u0007G>lWn\u001c8\n\u0005\u0001l&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o!\t\u00117-D\u0001\u0010\u0013\t!wB\u0001\u000bGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8Ti\u0006$Xo]\u0001\fM\u0016$8\r\u001b)be\u0006l7\u000f\u0005\u0002hU6\t\u0001N\u0003\u0002@S*\u00111)G\u0005\u0003W\"\u00141BR3uG\"\u0004\u0016M]1ng\u0006\u0001Bn\\2bYJ+\u0017\r\u001a*fgVdGo\u001d\t\u0004'Zs\u0007\u0003\u0002'Z7>\u0004\"A\u00199\n\u0005E|!!\u0004'pOJ+\u0017\r\u001a*fgVdG/\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005\t$\u0018BA;\u0010\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\t1C(p`\u0005\u0003s6\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0007M36\u0010\u0005\u0003M3nc\bCA4~\u0013\tq\bN\u0001\nGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007c\u0001'\u0002\u0002%\u0019\u00111A'\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015)\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e!\t\u0011\u0007\u0001C\u0003(\u0015\u0001\u0007\u0001\u0006C\u00039\u0015\u0001\u0007\u0011\bC\u0003G\u0015\u0001\u0007q\tC\u0003K\u0015\u0001\u00071\nC\u0003R\u0015\u0001\u0007!\u000bC\u0003f\u0015\u0001\u0007a\rC\u0003m\u0015\u0001\u0007Q\u000eC\u0003s\u0015\u0001\u00071\u000fC\u0003w\u0015\u0001\u0007q/A\u0006uef\u001cu.\u001c9mKR,GCAA\u0011!\ra\u00151E\u0005\u0004\u0003Ki%a\u0002\"p_2,\u0017M\\\u0001\r_:,\u0005\u0010]5sCRLwN\u001c\u000b\u0002\u007f\u0006QqN\\\"p[BdW\r^3")
public class DelayedRemoteFetch
extends DelayedOperation
implements Logging {
    private final Future<Void> remoteFetchTask;
    private final CompletableFuture<RemoteLogReadResult> remoteFetchResult;
    private final RemoteStorageFetchInfo remoteFetchInfo;
    private final Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus;
    private final FetchParams fetchParams;
    private final Seq<Tuple2<TopicIdPartition, LogReadResult>> localReadResults;
    private final ReplicaManager replicaManager;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            this.fetchPartitionStatus.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Partition partition;
                    TopicIdPartition topicPartition = (TopicIdPartition)x0$1._1();
                    LogOffsetMetadata logOffsetMetadata = ((FetchPartitionStatus)x0$1._2()).startOffsetMetadata();
                    try {
                        LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                        if (!(logOffsetMetadata == null ? logOffsetMetadata2 != null : !logOffsetMetadata.equals(logOffsetMetadata2))) {
                            return BoxedUnit.UNIT;
                        }
                        partition = $this.replicaManager.getPartitionOrException(topicPartition.topicPartition());
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Partition " + topicPartition + " is in an offline log directory, satisfy " + $this.fetchParams + " immediately");
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Broker no longer knows of partition " + topicPartition + ", satisfy " + $this.fetchParams + " immediately");
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Broker is no longer the leader or follower of %s, satisfy %s immediately"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, $this.fetchParams})));
                        throw new NonLocalReturnControl.mcZ.sp(object, this.forceComplete());
                    }
                    return partition;
                }
                throw new MatchError(null);
            });
            if (!this.remoteFetchResult.isDone()) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public void onExpiration() {
        if (!this.remoteFetchTask.cancel(false)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Remote fetch task for RemoteStorageFetchInfo: " + $this.remoteFetchInfo + " could not be cancelled and its isDone value is " + $this.remoteFetchTask.isDone());
        }
        DelayedRemoteFetchMetrics$.MODULE$.expiredRequestMeter().mark();
    }

    public void onComplete() {
        Seq fetchPartitionData = (Seq)this.localReadResults.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                LogReadResult result = (LogReadResult)x0$1._2();
                if (tp.topicPartition().equals((Object)$this.remoteFetchInfo.topicPartition) && $this.remoteFetchResult.isDone()) {
                    Errors errors = result.error();
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null) && result.info().delayedRemoteStorageFetch.isPresent()) {
                        if ($this.remoteFetchResult.get().error.isPresent()) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)ReplicaManager$.MODULE$.createLogReadResult((Throwable)$this.remoteFetchResult.get().error.get()).toFetchPartitionData(false));
                        }
                        FetchDataInfo info = (FetchDataInfo)$this.remoteFetchResult.get().fetchDataInfo.get();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchPartitionData(result.error(), result.highWatermark(), result.leaderLogStartOffset(), info.records, Optional.empty(), result.lastStableOffset().isDefined() ? OptionalLong.of(BoxesRunTime.unboxToLong((Object)result.lastStableOffset().get())) : OptionalLong.empty(), info.abortedTransactions, result.preferredReadReplica().isDefined() ? OptionalInt.of(BoxesRunTime.unboxToInt((Object)result.preferredReadReplica().get())) : OptionalInt.empty(), false));
                    }
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)result.toFetchPartitionData(false));
            }
            throw new MatchError(null);
        });
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public DelayedRemoteFetch(Future<Void> remoteFetchTask, CompletableFuture<RemoteLogReadResult> remoteFetchResult, RemoteStorageFetchInfo remoteFetchInfo, long remoteFetchMaxWaitMs, Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus, FetchParams fetchParams, Seq<Tuple2<TopicIdPartition, LogReadResult>> localReadResults, ReplicaManager replicaManager, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.remoteFetchTask = remoteFetchTask;
        this.remoteFetchResult = remoteFetchResult;
        this.remoteFetchInfo = remoteFetchInfo;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.fetchParams = fetchParams;
        this.localReadResults = localReadResults;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(remoteFetchMaxWaitMs);
        if (fetchParams.isFromFollower()) {
            throw new IllegalStateException("The follower should not invoke remote fetch. Fetch params are: " + fetchParams);
        }
    }
}

