/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.assignment;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ProcessId;

public class KafkaStreamsAssignment {
    private final ProcessId processId;
    private final Map<TaskId, AssignedTask> tasks;
    private final Optional<Instant> followupRebalanceDeadline;

    public static KafkaStreamsAssignment of(ProcessId processId, Set<AssignedTask> assignment) {
        Map<TaskId, AssignedTask> tasks = assignment.stream().collect(Collectors.toMap(AssignedTask::id, Function.identity()));
        return new KafkaStreamsAssignment(processId, tasks, Optional.empty());
    }

    public KafkaStreamsAssignment withFollowupRebalance(Instant rebalanceDeadline) {
        return new KafkaStreamsAssignment(this.processId(), this.tasks(), Optional.of(rebalanceDeadline));
    }

    private KafkaStreamsAssignment(ProcessId processId, Map<TaskId, AssignedTask> tasks, Optional<Instant> followupRebalanceDeadline) {
        this.processId = processId;
        this.tasks = tasks;
        this.followupRebalanceDeadline = followupRebalanceDeadline;
    }

    public ProcessId processId() {
        return this.processId;
    }

    public Map<TaskId, AssignedTask> tasks() {
        return Collections.unmodifiableMap(this.tasks);
    }

    public void assignTask(AssignedTask newTask) {
        this.tasks.put(newTask.id(), newTask);
    }

    public void removeTask(AssignedTask removedTask) {
        this.tasks.remove(removedTask.id());
    }

    public Optional<Instant> followupRebalanceDeadline() {
        return this.followupRebalanceDeadline;
    }

    public String toString() {
        return String.format("KafkaStreamsAssignment{%s, %s, %s}", this.processId, Arrays.toString(this.tasks.values().toArray(new AssignedTask[0])), this.followupRebalanceDeadline);
    }

    public static class AssignedTask {
        private final TaskId id;
        private final Type taskType;

        public AssignedTask(TaskId id, Type taskType) {
            this.id = id;
            this.taskType = taskType;
        }

        public TaskId id() {
            return this.id;
        }

        public Type type() {
            return this.taskType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.id.hashCode();
            result = 31 * result + this.type().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AssignedTask other = (AssignedTask)obj;
            return this.id.equals(other.id()) && this.taskType == other.taskType;
        }

        public String toString() {
            return String.format("AssignedTask{%s, %s}", new Object[]{this.taskType, this.id});
        }

        public static enum Type {
            ACTIVE,
            STANDBY;

        }
    }
}

