/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;

public class ProvenanceNode
implements MetadataNode {
    public static final String NAME = "provenance";
    private final MetadataProvenance provenance;

    public ProvenanceNode(MetadataProvenance provenance) {
        this.provenance = provenance;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public void print(MetadataNodePrinter printer) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(this.provenance.lastContainedLogTimeMs()).atZone(ZoneId.of("UTC"));
        printer.output("offset " + this.provenance.lastContainedOffset() + ", epoch " + this.provenance.lastContainedEpoch() + ", time " + DateTimeFormatter.ISO_ZONED_DATE_TIME.format(zonedDateTime));
    }
}

