/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.image.node.ConfigurationImageNode;
import org.apache.kafka.image.writer.ImageWriter;

public record ConfigurationImage(ConfigResource resource, Map<String, String> data) {
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.data);
        return properties;
    }

    public Map<String, String> toMap() {
        return Collections.unmodifiableMap(this.data);
    }

    public void write(ConfigResource configResource, ImageWriter writer) {
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            writer.write(0, new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(entry.getKey()).setValue(entry.getValue()));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ConfigurationImage)) {
            return false;
        }
        ConfigurationImage other = (ConfigurationImage)o;
        return this.data.equals(other.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public String toString() {
        return new ConfigurationImageNode(this).stringify();
    }
}

