/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.karaf.jaas.boot.principal.RolePolicy;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKarafLoginModule
implements LoginModule {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(AbstractKarafLoginModule.class);
    protected Set<Principal> principals = new HashSet<Principal>();
    protected Subject subject;
    protected String user;
    protected CallbackHandler callbackHandler;
    protected boolean debug;
    protected Map<String, ?> options;
    protected String rolePolicy;
    protected String roleDiscriminator;
    protected boolean detailedLoginExcepion;
    protected boolean succeeded = false;
    protected boolean commitSucceeded = false;
    protected BundleContext bundleContext;
    private EncryptionSupport encryptionSupport;

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded || this.principals.isEmpty()) {
            this.clear();
            this.succeeded = false;
            return false;
        }
        RolePolicy policy = RolePolicy.getPolicy((String)this.rolePolicy);
        if (policy != null && this.roleDiscriminator != null) {
            policy.handleRoles(this.subject, this.principals, this.roleDiscriminator);
        } else {
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            LOGGER.debug("abort");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && this.commitSucceeded) {
            this.logout();
        } else {
            this.clear();
            this.succeeded = false;
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.debug) {
            LOGGER.debug("logout");
        }
        this.subject.getPrincipals().removeAll(this.principals);
        this.clear();
        this.succeeded = false;
        this.commitSucceeded = false;
        return true;
    }

    protected void clear() {
        this.user = null;
        this.principals.clear();
    }

    public void initialize(Subject sub, CallbackHandler handler, Map<String, ?> options) {
        this.subject = sub;
        this.callbackHandler = handler;
        this.options = options;
        this.rolePolicy = JAASUtils.getString(options, "role.policy");
        this.roleDiscriminator = JAASUtils.getString(options, "role.discriminator");
        this.debug = Boolean.parseBoolean(JAASUtils.getString(options, "debug"));
        this.detailedLoginExcepion = Boolean.parseBoolean(JAASUtils.getString(options, "detailed.login.exception"));
        this.bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        this.encryptionSupport = new EncryptionSupport(options);
    }

    public boolean checkPassword(String password, String storedPassword) {
        return this.encryptionSupport.checkPassword(password, storedPassword);
    }
}

