/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.io.IOException;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.Map;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.ldap.LDAPCache;
import org.apache.karaf.jaas.modules.ldap.LDAPOptions;
import org.apache.karaf.jaas.modules.ldap.ManagedSSLSocketFactory;
import org.apache.karaf.jaas.modules.ldap.Util;
import org.apache.karaf.jaas.modules.publickey.PublickeyCallback;
import org.apache.karaf.jaas.modules.publickey.PublickeyLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPPubkeyLoginModule
extends AbstractKarafLoginModule {
    private static Logger logger = LoggerFactory.getLogger(LDAPPubkeyLoginModule.class);

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
    }

    @Override
    public boolean login() throws LoginException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            boolean bl = this.doLogin();
            return bl;
        }
        finally {
            ManagedSSLSocketFactory.setSocketFactory(null);
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected boolean doLogin() throws LoginException {
        String[] userDnAndNamespace;
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PublickeyCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioException) {
            throw new LoginException(ioException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage() + " not available to obtain information from user.");
        }
        this.user = Util.doRFC2254Encoding(((NameCallback)callbacks[0]).getName());
        PublicKey remotePubkey = ((PublickeyCallback)callbacks[1]).getPublicKey();
        LDAPOptions options = new LDAPOptions(this.options);
        if (options.isUsernameTrim() && this.user != null) {
            this.user = this.user.trim();
        }
        this.principals = new HashSet();
        LDAPCache cache = LDAPCache.getCache(options);
        try {
            logger.debug("Get the user DN.");
            userDnAndNamespace = cache.getUserDnAndNamespace(this.user);
            if (userDnAndNamespace == null) {
                return false;
            }
        }
        catch (Exception e) {
            logger.warn("Can't connect to the LDAP server: {}", (Object)e.getMessage(), (Object)e);
            throw new LoginException("Can't connect to the LDAP server: " + e.getMessage());
        }
        String userFullDn = userDnAndNamespace[0] + "," + options.getUserBaseDn();
        try {
            this.authenticatePubkey(userFullDn, remotePubkey, cache);
        }
        catch (NamingException e) {
            logger.warn("Can't connect to the LDAP server: {}", (Object)e.getMessage(), (Object)e);
            throw new LoginException("Can't connect to the LDAP server: " + e.getMessage());
        }
        catch (FailedLoginException e) {
            if (!this.detailedLoginExcepion) {
                throw new LoginException("Authentication failed");
            }
            logger.warn("Public key authentication failed for user {}: {}", new Object[]{this.user, e.getMessage(), e});
            throw new LoginException("Public key authentication failed for user " + this.user + ": " + e.getMessage());
        }
        this.principals.add(new UserPrincipal(this.user));
        try {
            String[] roles;
            for (String role : roles = cache.getUserRoles(this.user, userDnAndNamespace[0], userDnAndNamespace[1])) {
                this.principals.add(new RolePrincipal(role));
            }
        }
        catch (Exception e) {
            throw new LoginException("Can't get user " + this.user + " roles: " + e.getMessage());
        }
        this.succeeded = true;
        return true;
    }

    private void authenticatePubkey(String userDn, PublicKey key, LDAPCache cache) throws FailedLoginException, NamingException {
        if (key == null) {
            throw new FailedLoginException("no public key supplied by the client");
        }
        String[] storedKeys = cache.getUserPubkeys(userDn);
        if (storedKeys.length > 0) {
            for (String storedKey : storedKeys) {
                if (!PublickeyLoginModule.equals(key, storedKey)) continue;
                return;
            }
        }
        throw new FailedLoginException("no matching public key found");
    }
}

