/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.pool.transx;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSRuntimeException;
import javax.jms.XAConnectionFactory;
import javax.resource.spi.TransactionSupport;
import org.ops4j.pax.jms.pool.transx.TransxPooledConnectionFactoryFactory;
import org.ops4j.pax.jms.service.ConnectionFactoryFactory;
import org.ops4j.pax.jms.service.internal.BeanConfig;
import org.ops4j.pax.transx.jms.ManagedConnectionFactoryBuilder;
import org.ops4j.pax.transx.tm.TransactionManager;

public class TransxXAPooledConnectionFactoryFactory
extends TransxPooledConnectionFactoryFactory {
    private final TransactionManager transactionManager;

    public TransxXAPooledConnectionFactoryFactory(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public ConnectionFactory create(ConnectionFactoryFactory cff, Map<String, Object> props) throws JMSRuntimeException {
        try {
            ConnectionFactory cf = cff.createConnectionFactory(BeanConfig.getNonPoolProps(props));
            XAConnectionFactory xacf = cff.createXAConnectionFactory(BeanConfig.getNonPoolProps(props));
            ConnectionFactory mcf = ManagedConnectionFactoryBuilder.builder().connectionFactory(cf, xacf).transaction(TransactionSupport.TransactionSupportLevel.XATransaction).transactionManager(this.transactionManager).properties(BeanConfig.getPoolProps(props)).build();
            return mcf;
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled connection factory: " + e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

